/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import numerics.ErrorFunctionException;

public class ErrorFunction {
    private static final double THRESHOLD = 1.0E-15;
    private static final int ITMAX = 100;
    private static final double EPS = 3.0E-7;
    private static final double FPMIN = 1.0E-30;

    private static double gammln(double d) {
        double d2;
        double[] dArray = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double d3 = d2 = d;
        double d4 = d2 + 5.5;
        d4 -= (d2 + 0.5) * Math.log(d4);
        double d5 = 1.000000000190015;
        for (int i = 0; i <= 5; ++i) {
            d5 += dArray[i] / (d3 += 1.0);
        }
        return -d4 + Math.log(2.5066282746310007 * d5 / d2);
    }

    private static double gcf(double d, double d2) throws ErrorFunctionException {
        int n;
        double d3;
        double d4 = ErrorFunction.gammln(d);
        double d5 = d2 + 1.0 - d;
        double d6 = 9.999999999999999E29;
        double d7 = d3 = 1.0 / d5;
        for (n = 1; n <= 100; ++n) {
            double d8 = (double)(-n) * ((double)n - d);
            if (Math.abs(d3 = d8 * d3 + (d5 += 2.0)) < 1.0E-30) {
                d3 = 1.0E-30;
            }
            if (Math.abs(d6 = d5 + d8 / d6) < 1.0E-30) {
                d6 = 1.0E-30;
            }
            d3 = 1.0 / d3;
            double d9 = d3 * d6;
            d7 *= d9;
            if (Math.abs(d9 - 1.0) < 3.0E-7) break;
        }
        if (n > 100) {
            throw new ErrorFunctionException("a too large, ITMAX too small in gcf");
        }
        double d10 = Math.exp(-d2 + d * Math.log(d2) - d4) * d7;
        return d10;
    }

    private static double gser(double d, double d2) throws ErrorFunctionException {
        double d3;
        double d4 = ErrorFunction.gammln(d);
        if (d2 <= 0.0) {
            if (d2 < 0.0) {
                throw new ErrorFunctionException("x less than 0 in routine gser");
            }
            return 0.0;
        }
        double d5 = d;
        double d6 = d3 = 1.0 / d;
        for (int i = 1; i <= 100; ++i) {
            d3 += (d6 *= d2 / (d5 += 1.0));
            if (!(Math.abs(d6) < Math.abs(d3) * 3.0E-7)) continue;
            double d7 = d3 * Math.exp(-d2 + d * Math.log(d2) - d4);
            return d7;
        }
        throw new ErrorFunctionException("a too large, ITMAX too small in routine gser");
    }

    public static double gammp(double d, double d2) throws ErrorFunctionException {
        if (d2 < 0.0 || d <= 0.0) {
            throw new ErrorFunctionException("Invalid arguments in routine gammp");
        }
        if (d2 < d + 1.0) {
            double d3 = ErrorFunction.gser(d, d2);
            return d3;
        }
        double d4 = ErrorFunction.gcf(d, d2);
        return 1.0 - d4;
    }

    public static double erf(double d) throws ErrorFunctionException {
        return d < 0.0 ? -ErrorFunction.gammp(0.5, d * d) : ErrorFunction.gammp(0.5, d * d);
    }

    public static void main(String[] stringArray) {
        System.err.println("testing error function evaluation");
        for (int i = -20; i <= 20; ++i) {
            double d = (double)i / 5.0;
            try {
                System.err.println(d + " " + ErrorFunction.erf(d));
                continue;
            }
            catch (ErrorFunctionException errorFunctionException) {
                throw new RuntimeException(errorFunctionException);
            }
        }
    }
}

