/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.util.Random;
import numerics.AxialDistribution;
import numerics.BinghamFitter;
import numerics.ConvergenceException;
import numerics.Vector3D;
import numerics.WatsonDistribution;

public final class BinghamDistribution
implements AxialDistribution {
    private final Vector3D e1;
    private final Vector3D e2;
    private final Vector3D e3;
    private final double k1;
    private final double k2;
    private final double normC;
    private final WatsonDistribution wrapper;
    private final double wrapperK;
    private final double wrapperPDFNormC;
    private final Random ran;
    private final double logNormC;

    private BinghamDistribution() {
        this.e1 = null;
        this.e2 = null;
        this.e3 = null;
        this.k1 = 0.0;
        this.k2 = 0.0;
        this.normC = 1.0;
        this.logNormC = 0.0;
        this.wrapperK = 0.0;
        this.wrapperPDFNormC = 0.0;
        this.ran = new Random();
        this.wrapper = null;
    }

    public BinghamDistribution(Vector3D[] vector3DArray, double d, double d2, double d3, Random random) {
        double d4;
        this.k1 = d;
        this.k2 = d2;
        if (d2 > 0.0 || d > d2) {
            throw new IllegalArgumentException("Can't have Bingham parameters > 0 or k1 > k2");
        }
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(1.0 - vector3DArray[i].mod()) > 1.0E-6)) continue;
            throw new IllegalArgumentException("Principal axes of Bingham distribution must be a unit vector. Magnitude of axis " + i + " was " + vector3DArray[i].mod());
        }
        this.e1 = vector3DArray[2];
        this.e2 = vector3DArray[1];
        this.e3 = vector3DArray[0];
        this.normC = d3;
        this.logNormC = Math.log(d3);
        this.ran = random;
        if (Math.abs(d2) > 0.02 * Math.abs(d) + 5.0) {
            this.wrapper = new WatsonDistribution(this.e3, random);
            this.wrapperK = -1.0 * d2;
            d4 = d3 * Math.exp(-1.0 * d2);
        } else {
            this.wrapper = new WatsonDistribution(this.e1, random);
            this.wrapperK = d;
            d4 = d3;
        }
        this.wrapperPDFNormC = Math.exp(WatsonDistribution.logHyper1F1(0.5, 1.5, this.wrapperK, 1.0E-9) - Math.log(d4));
    }

    public static BinghamDistribution getBinghamDistribution(Vector3D[] vector3DArray, double[] dArray, Random random) throws ConvergenceException {
        return BinghamDistribution.getBinghamDistribution(vector3DArray, dArray[0], dArray[1], random);
    }

    public static BinghamDistribution getBinghamDistribution(Vector3D[] vector3DArray, double d, double d2, Random random) throws ConvergenceException {
        double d3 = 0.0;
        d3 = BinghamFitter.bingc(d, d2);
        return new BinghamDistribution(vector3DArray, d, d2, d3, random);
    }

    @Override
    public double pdf(Vector3D vector3D) {
        double d = vector3D.dot(this.e1);
        double d2 = vector3D.dot(this.e2);
        return Math.exp(this.k1 * d * d + this.k2 * d2 * d2) / this.normC;
    }

    public double logPDF(Vector3D vector3D) {
        double d = vector3D.dot(this.e1);
        double d2 = vector3D.dot(this.e2);
        return this.k1 * d * d + this.k2 * d2 * d2 - this.logNormC;
    }

    public static double pdf(Vector3D[] vector3DArray, double[] dArray, Vector3D vector3D) {
        double d = vector3D.dot(vector3DArray[2]);
        double d2 = vector3D.dot(vector3DArray[1]);
        return Math.exp(dArray[0] * d * d + dArray[1] * d2 * d2) / dArray[2];
    }

    private static double logPDF(Vector3D[] vector3DArray, double d, double d2, double d3, Vector3D vector3D) {
        double d4 = vector3D.dot(vector3DArray[2]);
        double d5 = vector3D.dot(vector3DArray[1]);
        return d * d4 * d4 + d2 * d5 * d5 - d3;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Vector3D nextVector() {
        var1_1 = 0;
        if (this.k1 == 0.0) {
            var2_2 = 6.283185307179586 * this.ran.nextDouble();
            var4_4 = Math.acos(2.0 * this.ran.nextDouble() - 1.0);
            return Vector3D.vectorFromSPC(1.0, var4_4, var2_2);
        }
        do lbl-1000:
        // 3 sources

        {
            block3: {
                var2_3 = this.wrapper.nextVector(this.wrapperK);
                var3_5 = this.ran.nextDouble();
                if (!(this.wrapperK < 700.0)) break block3;
                var5_6 = 0.0;
                var5_6 = this.wrapper.pdf(var2_3, this.wrapperK) * this.wrapperPDFNormC;
                if (var3_5 <= this.pdf(var2_3) / var5_6) {
                    return var2_3;
                }
                if (++var1_1 % 10000 != 0) ** GOTO lbl-1000
                System.err.println("Still rejecting samples after " + var1_1 + " attempts");
                throw new IllegalStateException("Couldn't get nextVector.\nConcentration\n\t" + this.k1 + "\t" + this.k2 + "\nAxes\n" + this.e1 + "\n" + this.e2 + "\n" + this.e3);
            }
            var5_6 = this.wrapper.logPDF(var2_3, this.wrapperK) + Math.log(this.wrapperPDFNormC);
            if (!(Math.log(var3_5) <= this.logPDF(var2_3) - var5_6)) continue;
            return var2_3;
        } while (++var1_1 % 10000 != 0);
        System.err.println("Still rejecting samples after " + var1_1 + " attempts");
        throw new IllegalStateException("Couldn't get nextVector.\nConcentration\n\t" + this.k1 + "\t" + this.k2 + "\nAxes\n" + this.e1 + "\n" + this.e2 + "\n" + this.e3);
    }

    public static Vector3D nextVector(Vector3D[] vector3DArray, double d, double d2, double d3, Random random) {
        double d4;
        double d5;
        Vector3D vector3D;
        int n = 0;
        if (d >= 0.0 || d2 >= 0.0 || d > d2) {
            throw new IllegalArgumentException("Can't have Bingham parameters >= 0 or k1 > k2");
        }
        Vector3D vector3D2 = vector3DArray[2];
        Vector3D vector3D3 = vector3DArray[1];
        Vector3D vector3D4 = vector3DArray[0];
        if (Math.abs(d2) > 0.02 * Math.abs(d) + 5.0) {
            vector3D = vector3D4;
            d5 = -1.0 * d2;
            d4 = d3 + -1.0 * d2;
        } else {
            vector3D = vector3D2;
            d5 = d;
            d4 = d3;
        }
        while (true) {
            Vector3D vector3D5 = WatsonDistribution.nextVector(vector3D, d5, random);
            double d6 = random.nextDouble();
            double d7 = BinghamDistribution.logWrapperPDF(vector3D5, vector3D, d5, d4);
            if (Math.log(d6) <= BinghamDistribution.logPDF(vector3DArray, d, d2, d3, vector3D5) - d7) {
                return vector3D5;
            }
            if (++n % 10000 != 0) continue;
            System.out.println("Still rejecting samples after " + n / 1000 + "0000 attempts");
        }
    }

    private static double logWrapperPDF(Vector3D vector3D, Vector3D vector3D2, double d, double d2) {
        double d3 = vector3D.dot(vector3D2);
        return d3 * d3 * d - d2;
    }

    public double k1() {
        return this.k1;
    }

    public double k2() {
        return this.k2;
    }

    public Vector3D e1() {
        return this.e1;
    }

    public Vector3D e2() {
        return this.e2;
    }

    public Vector3D e3() {
        return this.e3;
    }

    public double normC() {
        return this.normC;
    }

    public double logNormC() {
        return this.logNormC;
    }

    public String toString() {
        return "Bingham Distribution, k_1 == " + this.k1 + " k2 == " + this.k2;
    }
}

