/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Random;
import misc.LoggedException;
import numerics.RealMatrix;
import numerics.Rotations;
import tools.FileInput;

public class SphericalPoints {
    public static String pointSetDirectory = "/PointSets/";
    public static final double[][] icosahedron = new double[][]{{0.200009, 0.601164, 0.773691}, {-0.200009, -0.601164, -0.773691}, {-0.665299, 0.00444, 0.746564}, {0.665299, -0.00444, -0.746564}, {-0.567356, 0.818696, 0.088562}, {0.567356, -0.818696, -0.088562}, {0.961832, 0.092438, 0.257555}, {-0.961832, -0.092438, -0.257555}, {0.279792, -0.444412, 0.851008}, {-0.279792, 0.444412, -0.851008}, {0.438265, 0.873082, -0.213663}, {-0.438265, -0.873082, 0.213663}};

    public static double[] getRandomPoint(Random random) {
        double[] dArray = new double[3];
        dArray[2] = 2.0 * random.nextDouble() - 1.0;
        double d = random.nextDouble() * 2.0 * Math.PI;
        double d2 = Math.acos(dArray[2]);
        dArray[0] = Math.sin(d2) * Math.cos(d);
        dArray[1] = Math.sin(d2) * Math.sin(d);
        return dArray;
    }

    public static double[][] getElecPointSet(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        String string = MessageFormat.format("Elec{0,number,000}.txt", objectArray);
        URL uRL = SphericalPoints.class.getResource(pointSetDirectory + string);
        if (uRL == null) {
            throw new LoggedException("Could not find file: " + pointSetDirectory + string);
        }
        return SphericalPoints.readFromFile(uRL.getFile());
    }

    public static double[][] getIcosahedralPointSet(int n, int n2) {
        double[][] dArray = new double[icosahedron.length * n / 2][icosahedron[0].length];
        double[] dArray2 = new double[3];
        for (int i = 0; i < n; ++i) {
            RealMatrix realMatrix = Rotations.randomRotMat(i + n2);
            for (int j = 0; j < icosahedron.length; j += 2) {
                dArray2[0] = icosahedron[j][0];
                dArray2[1] = icosahedron[j][1];
                dArray2[2] = icosahedron[j][2];
                double[] dArray3 = Rotations.transformPoint(realMatrix, dArray2);
                dArray[i * SphericalPoints.icosahedron.length / 2 + j / 2][0] = dArray3[0];
                dArray[i * SphericalPoints.icosahedron.length / 2 + j / 2][1] = dArray3[1];
                dArray[i * SphericalPoints.icosahedron.length / 2 + j / 2][2] = dArray3[2];
            }
        }
        return dArray;
    }

    public static double[][] rotatePointSet(double[][] dArray, RealMatrix realMatrix) {
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Rotations.transformPoint(realMatrix, dArray[i]);
        }
        return dArray2;
    }

    public static double[][] readFromFile(String string) {
        FileInput fileInput = new FileInput(string);
        int n = fileInput.readInteger();
        double[][] dArray = new double[n][3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = fileInput.readDouble();
            }
        }
        return dArray;
    }

    public static double[] getSphPolars(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        double d2 = d > 0.0 ? Math.acos(dArray[2] / d) : 0.0;
        double d3 = 0.0;
        if (d > 0.0 && 1.0 - Math.abs(dArray[2] / d) > 1.0E-10) {
            double d4 = dArray[0] / (d * Math.sin(d2));
            d4 = d4 < -1.0 ? -1.0 : d4;
            d4 = d4 > 1.0 ? 1.0 : d4;
            d3 = Math.acos(d4);
            double d5 = dArray[1] / (d * Math.sin(d2));
            d5 = d5 < -1.0 ? -1.0 : d5;
            double d6 = d5 = d5 > 1.0 ? 1.0 : d5;
            if (Math.asin(d5) < 0.0) {
                d3 = Math.PI * 2 - d3;
            }
        }
        double[] dArray2 = new double[]{d, d2, d3};
        return dArray2;
    }

    public static double[][] getZPhiXs(int n) {
        int n2;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[][] dArray3 = new double[n * n][3];
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = (double)(2 * n2 + 1) / (double)n - 1.0;
            dArray2[n2] = ((double)n2 + 0.5) * 2.0 * Math.PI / (double)n;
        }
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = Math.sqrt(1.0 - dArray[i] * dArray[i]);
                dArray3[n2][0] = d * Math.cos(dArray2[j]);
                dArray3[n2][1] = d * Math.sin(dArray2[j]);
                dArray3[n2][2] = dArray[i];
                ++n2;
            }
        }
        return dArray3;
    }
}

