/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.Random;
import misc.LoggedException;
import misc.OrderedAcqMinimizer;

public class OrderedAcqSingleSubsetMinimizer
extends OrderedAcqMinimizer {
    private double[][] bestEverPoints;
    private int i = 0;
    private int j = 0;
    private double currentStateEnergy = 0.0;
    private double candidateStateEnergy = 0.0;
    private double bestEverStateEnergy = 0.0;
    private final int pairsInSubset;

    public OrderedAcqSingleSubsetMinimizer(int n, int n2, double d, int n3, String string, Random random) {
        super(n, d, n3, string, random);
        this.pairsInSubset = n2;
        this.stateEnergy();
        this.saveStateAsLowestEnergy();
    }

    public OrderedAcqSingleSubsetMinimizer(double[][] dArray, int n, double d, int n2, String string, Random random) {
        super(dArray, d, n2, string, random);
        this.pairsInSubset = n;
        this.stateEnergy();
        this.saveStateAsLowestEnergy();
    }

    @Override
    protected double stateEnergy() {
        double d = 0.0;
        for (int i = 0; i < this.pairsInSubset; ++i) {
            for (int j = 0; j < i; ++j) {
                d += this.energy[i][j];
            }
        }
        this.currentStateEnergy = d;
        return d;
    }

    private double swappedStateEnergy() {
        double d = this.currentStateEnergy;
        for (int i = 0; i < this.pairsInSubset; ++i) {
            if (i == this.i) continue;
            d -= this.energy[i][this.i];
            d += this.energy[i][this.j];
        }
        this.candidateStateEnergy = d;
        return d;
    }

    private void calculateCandidateSwapPositions() {
        this.i = (int)(this.ran.nextFloat() * (float)this.pairsInSubset);
        this.j = this.pairsInSubset + (int)(this.ran.nextFloat() * (float)(this.noPairs - this.pairsInSubset));
    }

    @Override
    protected double generateCandidateState() {
        this.calculateCandidateSwapPositions();
        return this.swappedStateEnergy();
    }

    @Override
    protected void acceptCandidateState() {
        if (this.candidateStateEnergy == 0.0) {
            throw new LoggedException("Attempting to set an invalid state.");
        }
        this.currentStateEnergy = this.candidateStateEnergy;
        this.candidateStateEnergy = 0.0;
        this.swapPoints(this.i, this.j);
    }

    @Override
    protected void saveStateAsLowestEnergy() {
        this.bestEverPoints = this.getPoints();
        this.bestEverStateEnergy = this.currentStateEnergy;
    }

    @Override
    protected void setStateToLowestEnergy() {
        this.points = this.bestEverPoints;
        this.bestEverPoints = this.getPoints();
        this.buildEnergyMatrix();
        this.stateEnergy();
    }

    @Override
    public String state() {
        return this.state(this.points, this.temperature, this.currentStateEnergy);
    }

    @Override
    public String lowestEnergyState() {
        return this.state(this.bestEverPoints, this.temperature, this.bestEverStateEnergy);
    }

    private String state(double[][] dArray, double d, double d2) {
        String string = this.noPairs + " 1 " + this.pairsInSubset + " " + d + " " + d2 + "\n";
        for (int i = 0; i < this.noPairs; ++i) {
            string = string + dArray[i][0] + " " + dArray[i][1] + " " + dArray[i][2] + "\n";
        }
        return string;
    }
}

