/*
 * Decompiled with CFR 0.152.
 */
package mesd;

import imaging.Scheme;
import inverters.DiffusionInversion;
import java.util.Date;
import java.util.logging.Logger;
import mesd.MESD_Fitter;
import optimizers.MarquardtMinimiserException;
import sphfunc.ISCodes;

public class MESD_Inversion
extends DiffusionInversion {
    Logger logger = Logger.getLogger("mesd.MESD_Inversion");
    public static boolean doNumIntTests = true;
    public static double intErrThresh = 0.01;
    public static double intErrThreshUpper = 0.05;
    public static double predErrThresh = 0.05;
    public static double relResidThresh = 0.5;
    public static double convt = 1.0E-5;
    public MESD_Fitter mesdf;

    public MESD_Inversion(Scheme scheme, double[] dArray, int n) {
        this.ip = scheme;
        int n2 = this.ip.numZeroMeasurements();
        double[][] dArray2 = this.ip.getNormNonZeroQs();
        try {
            this.mesdf = new MESD_Fitter(dArray2, n2, dArray, n);
        }
        catch (MarquardtMinimiserException marquardtMinimiserException) {
            throw new RuntimeException(marquardtMinimiserException);
        }
    }

    @Override
    public double[] invert(double[] dArray) {
        double[] dArray2 = this.ip.normalizeData(dArray);
        try {
            long l;
            this.mesdf.newDepVals(dArray2);
            this.mesdf.setPointSet(0);
            this.mesdf.setConvergence(convt);
            long l2 = l = new Date().getTime();
            this.mesdf.minimise();
            l = new Date().getTime();
            double[] dArray3 = this.mesdf.integrationErrorStats();
            double d = dArray3[0];
            double d2 = dArray3[1];
            for (int i = 1; i < ISCodes.getNoPointSetsForMaxEnt() && d > intErrThresh && doNumIntTests; ++i) {
                this.mesdf.setPointSet(i);
                l = new Date().getTime();
                this.mesdf.minimise();
                l = new Date().getTime();
                dArray3 = this.mesdf.integrationErrorStats();
                d = dArray3[0];
                d2 = dArray3[1];
                if (d < intErrThresh) {
                    ++i;
                    break;
                }
                this.mesdf.reInit();
                l = new Date().getTime();
                this.mesdf.minimise();
                l = new Date().getTime();
                dArray3 = this.mesdf.integrationErrorStats();
                d = dArray3[0];
                d2 = dArray3[1];
            }
            int n = this.getMREClass(d);
            int n2 = this.getPredErrClass(d2);
            int n3 = this.getPredErrClass(Math.sqrt(this.mesdf.getRelativeResidual()));
            int n4 = n + 10 * n2 + 100 * n3;
            double[] dArray4 = this.mesdf.getParameters();
            double[] dArray5 = new double[dArray4.length + 1];
            dArray5[0] = n4;
            dArray5[1] = Math.log(this.ip.geoMeanZeroMeas(dArray));
            for (int i = 1; i < dArray4.length; ++i) {
                dArray5[i + 1] = dArray4[i];
            }
            return dArray5;
        }
        catch (Exception exception) {
            this.logger.warning("Fitting failed in MESD_Inversion.");
            this.logger.warning(exception.toString());
            double[] dArray6 = new double[dArray2.length + 3];
            dArray6[0] = 5.0;
            return dArray6;
        }
    }

    public int getMREClass(double d) {
        if (d > intErrThreshUpper) {
            return 2;
        }
        if (d > intErrThresh) {
            return 1;
        }
        return 0;
    }

    public int getPredErrClass(double d) {
        if (d > predErrThresh) {
            return 1;
        }
        return 0;
    }

    public int getResidErrClass(double d) {
        if (d > relResidThresh) {
            return 1;
        }
        return 0;
    }

    @Override
    public int itemsPerVoxel() {
        return this.ip.numMeasurements() - this.ip.numZeroMeasurements() + 3;
    }
}

