/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.Scheme;
import inverters.DT_Inversion;
import inverters.DiffusionInversion;
import inverters.ModelIndex;
import inverters.TwoTensorFitter;
import misc.DT;

public class TwoTensorInversion
extends DiffusionInversion {
    protected DT_Inversion dtInverter;
    protected TwoTensorFitter fitter;
    public static final int ITEMSPERVOX = 17;

    public TwoTensorInversion(Scheme scheme) {
        this.init(scheme, ModelIndex.DTDT, ModelIndex.LDT);
    }

    public TwoTensorInversion(Scheme scheme, ModelIndex modelIndex, ModelIndex modelIndex2) {
        this.init(scheme, modelIndex, modelIndex2);
    }

    protected void init(Scheme scheme, ModelIndex modelIndex, ModelIndex modelIndex2) {
        this.ip = scheme;
        this.dtInverter = DT_Inversion.getIndexedDT_Inversion(modelIndex2, scheme);
        int n = this.ip.numZeroMeasurements();
        double[] dArray = this.ip.getDiffusionTimes();
        double[][] dArray2 = new double[this.ip.numMeasurements() - n - this.ip.numIgnoredMeasurements()][3];
        for (int i = 0; i < dArray2.length; ++i) {
            double[] dArray3 = this.ip.getQ(i + n);
            dArray2[i][0] = dArray3[0];
            dArray2[i][1] = dArray3[1];
            dArray2[i][2] = dArray3[2];
        }
        double[] dArray4 = new double[this.ip.numMeasurements() - n - this.ip.numIgnoredMeasurements()];
        try {
            this.fitter = TwoTensorFitter.getIndexedTwoTensorFitter(dArray2, dArray4, dArray, n, modelIndex);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public double[] invert(double[] dArray) {
        double[] dArray2 = this.ip.normalizeData(dArray);
        double[] dArray3 = this.dtInverter.invert(dArray);
        double d = dArray3[0];
        double d2 = dArray3[1];
        double[] dArray4 = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray4[i] = dArray3[i + 2];
        }
        DT dT = new DT(dArray4);
        try {
            this.fitter.newDepVals(dArray2);
            this.fitter.setStartFromSingleDT(dT);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        double[] dArray5 = dT.getComponents();
        double[] dArray6 = dT.getComponents();
        double d3 = 0.5;
        try {
            this.fitter.minimise();
            dArray5 = this.fitter.getDT1().getComponents();
            dArray6 = this.fitter.getDT2().getComponents();
            d3 = this.fitter.getMix();
        }
        catch (Exception exception) {
            logger.info(exception.toString() + "Fitting failed.  Outputting single DT.");
            d = 2.0;
        }
        double[] dArray7 = new double[17];
        dArray7[0] = d;
        dArray7[1] = d2;
        dArray7[2] = 2.0;
        dArray7[3] = d3;
        dArray7[10] = 1.0 - d3;
        for (int i = 0; i < 6; ++i) {
            dArray7[i + 4] = dArray5[i];
            dArray7[i + 11] = dArray6[i];
        }
        return dArray7;
    }

    @Override
    public int itemsPerVoxel() {
        return 17;
    }
}

