/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import inverters.TwoTensorOneAxiSymFitter;
import misc.DT;
import optimizers.MarquardtMinimiserException;

public class TwoTensorAxiSymFitter
extends TwoTensorOneAxiSymFitter {
    private int AXISYMNOPARAMS = 9;

    public TwoTensorAxiSymFitter() {
    }

    public TwoTensorAxiSymFitter(double[][] dArray, double[] dArray2, double[] dArray3, int n) throws MarquardtMinimiserException {
        this.noParams = 9;
        this.dt1StartIndex = 1;
        this.dt2StartIndex = 5;
        this.mixParIndex = 9;
        this.initialize(dArray, dArray2, dArray3, n);
    }

    @Override
    protected double[] initParams2() {
        double d = 2.4E-9;
        double[] dArray = new double[4];
        for (int i = 0; i < 3; ++i) {
            dArray[i] = 0.0;
        }
        dArray[3] = Math.sqrt(d / 3.0);
        return dArray;
    }

    @Override
    protected double[] fAndBetaToParams2(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2], Math.sqrt(dArray[3])};
        return dArray2;
    }

    @Override
    protected void insertTensorParamDerivs(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2, double d3, double d4) {
        double d5 = dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2];
        double d6 = dArray2[this.dt1StartIndex + 3];
        double d7 = dArray2[this.dt2StartIndex + 3];
        double d8 = dArray3[0] * dArray2[this.dt1StartIndex] + dArray3[1] * dArray2[this.dt1StartIndex + 1] + dArray3[2] * dArray2[this.dt1StartIndex + 2];
        double d9 = dArray3[0] * dArray2[this.dt2StartIndex] + dArray3[1] * dArray2[this.dt2StartIndex + 1] + dArray3[2] * dArray2[this.dt2StartIndex + 2];
        this.insertAxiSymDerivs(dArray, d4, this.dt1StartIndex, dArray3, d6 * d5, d8, d3, d);
        this.insertAxiSymDerivs(dArray, d4, this.dt2StartIndex, dArray3, d7 * d5, d9, 1.0 - d3, d2);
    }

    @Override
    protected DT getDT2(double[] dArray) {
        return this.getDT_AxiSym(dArray, this.dt2StartIndex);
    }

    @Override
    protected double[] dt2ToParams(DT dT) {
        return TwoTensorAxiSymFitter.getAxiSymParams(dT);
    }
}

