/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import inverters.ThreeTensorFitter;
import misc.DT;
import optimizers.MarquardtMinimiserException;

public class ThreeTensorCholFitter
extends ThreeTensorFitter {
    public ThreeTensorCholFitter() {
    }

    public ThreeTensorCholFitter(double[][] dArray, double[] dArray2, double[] dArray3, int n) throws MarquardtMinimiserException {
        this.noParams = 20;
        this.dt1StartIndex = 1;
        this.dt2StartIndex = 7;
        this.dt3StartIndex = 13;
        this.mixPar1Index = 19;
        this.mixPar2Index = 20;
        this.initialize(dArray, dArray2, dArray3, n);
    }

    @Override
    protected void insertMixPars(double[] dArray, double d, double d2) {
        dArray[this.mixPar1Index] = Math.asin(Math.sqrt(d));
        dArray[this.mixPar2Index] = Math.asin(Math.sqrt(d2 / (1.0 - d)));
    }

    @Override
    protected void insertTensorParamDerivs(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = dArray3[0] * dArray2[this.dt1StartIndex] + dArray3[1] * dArray2[this.dt1StartIndex + 1] + dArray3[2] * dArray2[this.dt1StartIndex + 2];
        double d8 = dArray3[1] * dArray2[this.dt1StartIndex + 3] + dArray3[2] * dArray2[this.dt1StartIndex + 4];
        double d9 = dArray3[2] * dArray2[this.dt1StartIndex + 5];
        double d10 = dArray3[0] * dArray2[this.dt2StartIndex] + dArray3[1] * dArray2[this.dt2StartIndex + 1] + dArray3[2] * dArray2[this.dt2StartIndex + 2];
        double d11 = dArray3[1] * dArray2[this.dt2StartIndex + 3] + dArray3[2] * dArray2[this.dt2StartIndex + 4];
        double d12 = dArray3[2] * dArray2[this.dt2StartIndex + 5];
        double d13 = dArray3[0] * dArray2[this.dt3StartIndex] + dArray3[1] * dArray2[this.dt3StartIndex + 1] + dArray3[2] * dArray2[this.dt3StartIndex + 2];
        double d14 = dArray3[1] * dArray2[this.dt3StartIndex + 3] + dArray3[2] * dArray2[this.dt3StartIndex + 4];
        double d15 = dArray3[2] * dArray2[this.dt3StartIndex + 5];
        ThreeTensorCholFitter.insertCholDerivs(dArray, d6, this.dt1StartIndex, dArray3, d7, d8, d9, d4, d);
        ThreeTensorCholFitter.insertCholDerivs(dArray, d6, this.dt2StartIndex, dArray3, d10, d11, d12, d5, d2);
        ThreeTensorCholFitter.insertCholDerivs(dArray, d6, this.dt3StartIndex, dArray3, d13, d14, d15, 1.0 - d4 - d5, d3);
    }

    @Override
    protected void insertOtherDerivs(double[] dArray, double[] dArray2, double d, double d2, double d3, double d4, double d5) {
        double d6 = 2.0 * Math.cos(dArray2[this.mixPar1Index]) * Math.sin(dArray2[this.mixPar1Index]);
        double d7 = d5 / (1.0 - d4);
        dArray[this.mixPar1Index] = d6 * (d - d7 * d2 - (1.0 - d7) * d3);
        double d8 = (1.0 - d4) * (2.0 * Math.cos(dArray2[this.mixPar2Index]) * Math.sin(dArray2[this.mixPar2Index]));
        dArray[this.mixPar2Index] = d8 * (d2 - d3);
    }

    @Override
    protected DT getDT1(double[] dArray) {
        return ThreeTensorCholFitter.getDT_Chol(dArray, this.dt1StartIndex);
    }

    @Override
    protected DT getDT2(double[] dArray) {
        return ThreeTensorCholFitter.getDT_Chol(dArray, this.dt2StartIndex);
    }

    @Override
    protected DT getDT3(double[] dArray) {
        return ThreeTensorCholFitter.getDT_Chol(dArray, this.dt3StartIndex);
    }

    @Override
    protected double getP1(double[] dArray) {
        double d = Math.sin(dArray[this.mixPar1Index]);
        return d * d;
    }

    @Override
    protected double getP2(double[] dArray) {
        double d = Math.sin(dArray[this.mixPar2Index]);
        double d2 = this.getP1(dArray);
        return (1.0 - d2) * d * d;
    }

    @Override
    protected double[] dt1ToParams(DT dT) {
        return ThreeTensorCholFitter.getCholParams(dT);
    }

    @Override
    protected double[] dt2ToParams(DT dT) {
        return ThreeTensorCholFitter.getCholParams(dT);
    }

    @Override
    protected double[] dt3ToParams(DT dT) {
        return ThreeTensorCholFitter.getCholParams(dT);
    }
}

