/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.Scheme;
import inverters.DT_Inversion;
import inverters.DiffTensorFitter;
import inverters.DiffTensorFitterHess;
import inverters.DiffTensorUnConFitter;
import inverters.DiffTensorUnConFitterHess;
import inverters.LinearDT_Inversion;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import misc.DT;
import misc.LoggedException;
import optimizers.MarquardtMinimiserException;
import tools.ArrayOps;
import tools.CL_Initializer;

public class RestoreDT_Inversion
extends DT_Inversion {
    protected DiffTensorFitter fitter;
    protected LinearDT_Inversion ldti;
    protected double sigma;
    protected double[][] qNoZeros;
    protected double[] taus;
    protected int M;
    protected int fitterIndex;
    private final double MADFACTOR = 1.4826;
    private final double MAXRESTHRESH = 3.0;
    private final double RESCHANGETHRESH = 0.001;
    private int[] outlierHist;
    private DataOutputStream outlierMap;

    public RestoreDT_Inversion(Scheme scheme, double d) {
        this.ip = scheme;
        this.sigma = d;
        this.init(this.ip, 4);
    }

    public RestoreDT_Inversion(Scheme scheme, double d, int n) {
        this.ip = scheme;
        this.sigma = d;
        this.init(this.ip, n);
    }

    protected void init(Scheme scheme, int n) {
        this.ip = scheme;
        this.fitterIndex = n;
        this.ldti = new LinearDT_Inversion(this.ip);
        this.M = this.ip.numZeroMeasurements();
        this.taus = this.ip.getNonZeroQ_DiffusionTimes();
        this.qNoZeros = this.ip.getNonZeroQs();
        double[] dArray = new double[this.ip.numMeasurements() - this.M - this.ip.numIgnoredMeasurements()];
        this.fitter = this.getFitter(this.qNoZeros, dArray, this.taus, this.M, this.fitterIndex);
        this.outlierHist = new int[this.qNoZeros.length];
        if (CL_Initializer.outlierMapFile != null) {
            try {
                this.outlierMap = new DataOutputStream(new FileOutputStream(CL_Initializer.outlierMapFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.warning("" + fileNotFoundException);
            }
            catch (IOException iOException) {
                logger.warning("" + iOException);
            }
        }
    }

    @Override
    public double[] invert(double[] dArray) {
        double[] dArray2;
        DT dT;
        double d;
        block17: {
            d = 0.0;
            double[] dArray3 = this.ldti.invert(dArray);
            double[] dArray4 = new double[6];
            for (int i = 0; i < dArray4.length; ++i) {
                dArray4[i] = dArray3[i + 2];
            }
            double[] dArray5 = this.ip.normalizeData(dArray);
            double d2 = this.ip.geoMeanZeroMeas(dArray);
            double d3 = this.sigma / d2;
            dT = new DT(dArray3[2], dArray3[3], dArray3[4], dArray3[5], dArray3[6], dArray3[7]);
            try {
                this.fitter.newDepVals(dArray5);
                this.fitter.setInitParams(dArray4);
                for (int i = 1; i <= dArray5.length; ++i) {
                    this.fitter.setSig(i, d3);
                }
                this.fitter.minimise();
                dT = this.fitter.getDiffTensor();
                dArray2 = this.fitter.getResiduals();
                double d4 = ArrayOps.max(dArray2);
                if (d4 > 3.0 * d3) {
                    int n;
                    double[] dArray6;
                    double d5 = 0.0;
                    while (Math.abs(d5 - d4) > 0.001 * d4) {
                        d5 = d4;
                        double d6 = ArrayOps.median(dArray2);
                        dArray6 = new double[dArray2.length];
                        for (int i = 0; i < dArray6.length; ++i) {
                            dArray6[i] = Math.abs(dArray2[i] - d6);
                        }
                        double d7 = 1.4826 * ArrayOps.median(dArray6);
                        this.fitter.newDepVals(dArray5);
                        this.fitter.setInitParams(dArray4);
                        for (n = 1; n <= dArray5.length; ++n) {
                            this.fitter.setSig(n, Math.sqrt(dArray2[n - 1] * dArray2[n - 1] + d7 * d7));
                        }
                        this.fitter.minimise();
                        dArray2 = this.fitter.getResiduals();
                        d4 = ArrayOps.max(dArray2);
                    }
                    int[] nArray = this.getOutliers(dArray2, d3);
                    if (nArray.length > dArray2.length - 6) {
                        logger.info("Too many outliers.  Outputting linearly fitted DT.");
                        dT = new DT(dArray3[2], dArray3[3], dArray3[4], dArray3[5], dArray3[6], dArray3[7]);
                    } else {
                        double[][] dArray7 = new double[this.qNoZeros.length - nArray.length][3];
                        dArray6 = new double[dArray5.length - nArray.length];
                        double[] dArray8 = new double[dArray5.length - nArray.length];
                        int n2 = 0;
                        n = 0;
                        for (int i = 0; i < dArray2.length; ++i) {
                            if (n < nArray.length && i == nArray[n]) {
                                ++n;
                                continue;
                            }
                            dArray7[n2][0] = this.qNoZeros[i][0];
                            dArray7[n2][1] = this.qNoZeros[i][1];
                            dArray7[n2][2] = this.qNoZeros[i][2];
                            dArray6[n2] = dArray5[i];
                            dArray8[n2] = this.taus[i];
                            ++n2;
                        }
                        DiffTensorFitter diffTensorFitter = this.getFitter(dArray7, dArray6, dArray8, this.M, this.fitterIndex);
                        diffTensorFitter.setInitParams(dArray4);
                        diffTensorFitter.minimise();
                        dT = diffTensorFitter.getDiffTensor();
                    }
                    if (this.outlierMap != null) {
                        this.outputOutlierMap(nArray);
                    }
                    d = 1000 + nArray.length;
                    for (int i = 0; i < nArray.length; ++i) {
                        int n3 = nArray[i];
                        this.outlierHist[n3] = this.outlierHist[n3] + 1;
                    }
                } else if (this.outlierMap != null) {
                    this.outputOutlierMap(new int[0]);
                }
            }
            catch (MarquardtMinimiserException marquardtMinimiserException) {
                logger.info(marquardtMinimiserException.toString() + "Fitting failed.  Outputting best DT found, which may be affected by outliers.");
                d = 2.0;
                if (this.outlierMap == null) break block17;
                this.outputOutlierMap(new int[0]);
            }
        }
        dArray2 = dT.getComponents();
        double[] dArray9 = new double[8];
        dArray9[0] = d;
        double d8 = this.ip.geoMeanZeroMeas(dArray);
        dArray9[1] = d8 > 0.0 ? Math.log(d8) : 0.0;
        for (int i = 0; i < 6; ++i) {
            dArray9[i + 2] = dArray2[i];
        }
        return dArray9;
    }

    @Override
    public void close() {
        System.err.println("Outlier histogram:");
        for (int i = 0; i < this.outlierHist.length; ++i) {
            System.err.println(i + " : " + this.outlierHist[i]);
        }
        if (this.outlierMap != null) {
            try {
                this.outlierMap.close();
            }
            catch (Exception exception) {
                logger.warning("" + exception);
            }
        }
    }

    @Override
    public void background() {
        if (this.outlierMap != null) {
            this.outputOutlierMap(new int[0]);
        }
    }

    protected int[] getOutliers(double[] dArray, double d) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 3.0 * d)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 3.0 * d)) continue;
            nArray[n2] = i;
            ++n2;
        }
        return nArray;
    }

    protected void outputOutlierMap(int[] nArray) {
        int n = 0;
        try {
            for (int i = 0; i < this.qNoZeros.length; ++i) {
                if (n < nArray.length && i == nArray[n]) {
                    this.outlierMap.writeByte(1);
                    ++n;
                    continue;
                }
                this.outlierMap.writeByte(0);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new LoggedException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    protected DiffTensorFitter getFitter(double[][] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        DiffTensorFitter diffTensorFitter = null;
        try {
            diffTensorFitter = n2 == 3 ? new DiffTensorFitterHess(dArray, dArray2, dArray3, n) : (n2 == 4 ? new DiffTensorUnConFitter(dArray, dArray2, dArray3, n) : (n2 == 5 ? new DiffTensorUnConFitterHess(dArray, dArray2, dArray3, n) : new DiffTensorFitter(dArray, dArray2, dArray3, n)));
        }
        catch (MarquardtMinimiserException marquardtMinimiserException) {
            LoggedException.logExceptionSevere(marquardtMinimiserException, Thread.currentThread().getName());
            System.exit(1);
        }
        return diffTensorFitter;
    }
}

