/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.Scheme;
import inverters.DT_Inversion;
import inverters.DiffTensorFitter;
import inverters.DiffTensorFitterHess;
import inverters.DiffTensorUnConFitter;
import inverters.DiffTensorUnConFitterHess;
import inverters.LinearDT_Inversion;
import inverters.ModelIndex;
import misc.DT;
import misc.LoggedException;

public class NonLinearDT_Inversion
extends DT_Inversion {
    protected DiffTensorFitter fitter;
    protected LinearDT_Inversion ldti;
    int testindex = 0;

    public NonLinearDT_Inversion(Scheme scheme) {
        this.ip = scheme;
        this.init(this.ip, ModelIndex.NLDT_POS);
    }

    public NonLinearDT_Inversion(Scheme scheme, ModelIndex modelIndex) {
        this.ip = scheme;
        this.init(this.ip, modelIndex);
    }

    protected void init(Scheme scheme, ModelIndex modelIndex) {
        block6: {
            this.ip = scheme;
            this.ldti = new LinearDT_Inversion(this.ip);
            int n = this.ip.numZeroMeasurements();
            double[] dArray = this.ip.getNonZeroQ_DiffusionTimes();
            double[][] dArray2 = this.ip.getNonZeroQs();
            double[] dArray3 = new double[this.ip.numMeasurements() - n - this.ip.numIgnoredMeasurements()];
            try {
                if (modelIndex == ModelIndex.NLDT_POS) {
                    this.fitter = new DiffTensorFitter(dArray2, dArray3, dArray, n);
                    break block6;
                }
                if (modelIndex == ModelIndex.NLDT) {
                    this.fitter = new DiffTensorUnConFitter(dArray2, dArray3, dArray, n);
                    break block6;
                }
                if (modelIndex == ModelIndex.NLDT_POS_HESS) {
                    this.fitter = new DiffTensorFitterHess(dArray2, dArray3, dArray, n);
                    break block6;
                }
                if (modelIndex == ModelIndex.NLDT_HESS) {
                    this.fitter = new DiffTensorUnConFitterHess(dArray2, dArray3, dArray, n);
                    break block6;
                }
                throw new LoggedException("Unknown nonlinear DT inversion " + (Object)((Object)modelIndex));
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        }
    }

    @Override
    public double[] invert(double[] dArray) {
        double[] dArray2 = this.ldti.invert(dArray);
        double d = dArray2[0];
        double[] dArray3 = this.ip.normalizeData(dArray);
        try {
            this.fitter.newDepVals(dArray3);
            this.fitter.setStartPoint(dArray2);
            this.fitter.minimise();
        }
        catch (Exception exception) {
            LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
            d = 2.0;
        }
        DT dT = this.fitter.getDiffTensor();
        ++this.testindex;
        double[] dArray4 = dT.getComponents();
        double[] dArray5 = new double[8];
        dArray5[0] = d;
        dArray5[1] = dArray2[1];
        for (int i = 0; i < 6; ++i) {
            dArray5[i + 2] = dArray4[i];
        }
        return dArray5;
    }
}

