/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import apps.ModelFit;
import data.VoxelOrderDataSource;
import imaging.Scheme;
import inverters.DT_Inversion;
import inverters.DiffusionInversion;
import inverters.ModelIndex;
import misc.LoggedException;

public class MultiTensorInversion
extends DiffusionInversion {
    protected DiffusionInversion[] inverters;
    protected int comps;
    protected VoxelOrderDataSource voxClassStream;

    public MultiTensorInversion(Scheme scheme, String string, ModelIndex[][] modelIndexArray, int n) {
        this.init(scheme, string, modelIndexArray, n);
    }

    protected void init(Scheme scheme, String string, ModelIndex[][] modelIndexArray, int n) {
        this.ip = scheme;
        this.comps = n;
        if (this.comps < 1) {
            throw new LoggedException("Must have at least one output component in MultiTensorInversion.");
        }
        this.inverters = new DiffusionInversion[modelIndexArray.length];
        for (int i = 0; i < modelIndexArray.length; ++i) {
            this.inverters[i] = ModelFit.getIndexedInversion(modelIndexArray[i], scheme);
        }
        this.voxClassStream = new VoxelOrderDataSource(string, 1, "int");
    }

    @Override
    public double[] invert(double[] dArray) {
        boolean bl = false;
        if (!this.voxClassStream.more()) {
            throw new LoggedException("Voxel classification file too small.");
        }
        double[] dArray2 = this.voxClassStream.nextVoxel();
        int n = (int)dArray2[0];
        if (n >= this.inverters.length) {
            n = this.inverters.length - 1;
        } else if (n == -1) {
            bl = true;
            n = 0;
        }
        double[] dArray3 = this.inverters[n].invert(dArray);
        double[] dArray4 = new double[this.itemsPerVoxel()];
        if (this.inverters[n] instanceof DT_Inversion) {
            dArray4[0] = dArray3[0];
            dArray4[1] = dArray3[1];
            dArray4[2] = 1.0;
            dArray4[3] = 1.0;
            if (bl) {
                dArray4[0] = -1.0;
                dArray4[2] = 0.0;
            }
            for (int i = 0; i < 6; ++i) {
                dArray4[i + 4] = dArray3[i + 2];
            }
        } else {
            for (int i = 0; i < dArray4.length && i < dArray3.length; ++i) {
                dArray4[i] = dArray3[i];
            }
        }
        return dArray4;
    }

    @Override
    public void background() {
        if (!this.voxClassStream.more()) {
            throw new LoggedException("Voxel classification file too small.");
        }
        double[] dArray = this.voxClassStream.nextVoxel();
    }

    @Override
    public int itemsPerVoxel() {
        return 3 + 7 * this.comps;
    }
}

