/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import optimizers.MarquardtChiSqFitter;
import optimizers.MarquardtMinimiserException;

public abstract class DiffDataFitter
extends MarquardtChiSqFitter {
    protected double[] taus;
    protected double M;
    protected int noParams;

    protected void initialize(double[][] dArray, double[] dArray2, double[] dArray3, int n) throws MarquardtMinimiserException {
        this.taus = new double[dArray3.length + 1];
        for (int i = 0; i < dArray3.length; ++i) {
            this.taus[i + 1] = dArray3[i];
        }
        this.M = n;
        this.initData(dArray, dArray2, this.noParams);
        this.initASigs();
    }

    public void newDepVals(double[] dArray) throws MarquardtMinimiserException {
        if (dArray.length != this.y.length - 1) {
            System.err.println(dArray.length + " " + (this.y.length - 1));
            throw new MarquardtMinimiserException("New data contains the wrong number of values.");
        }
        for (int i = 0; i < this.ndata; ++i) {
            this.y[i + 1] = dArray[i];
        }
        this.initASigs();
    }

    protected void initASigs() {
        this.initAs();
        this.initSigs();
    }

    protected abstract void initAs();

    protected void initSigs() {
        for (int i = 1; i <= this.ndata; ++i) {
            if (!(this.M > 0.0)) continue;
            this.sig[i] = Math.sqrt(1.0 + this.y[i] * this.y[i] / this.M);
        }
    }

    public static double[] getQ(double[][] dArray, int n) {
        double[] dArray2 = new double[]{dArray[n][0], dArray[n][1], dArray[n][2]};
        return dArray2;
    }
}

