/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.Scheme;
import inverters.AlgebraicDT_Inversion;
import inverters.DiffusionInversion;
import inverters.LinearDT_Inversion;
import inverters.ModelIndex;
import inverters.NonLinearDT_Inversion;
import inverters.WeightedLinearDT_Inversion;

public abstract class DT_Inversion
extends DiffusionInversion {
    public static final int ITEMSPERVOX = 8;

    public static DT_Inversion getIndexedDT_Inversion(ModelIndex modelIndex, Scheme scheme) {
        if (modelIndex == ModelIndex.LDT || modelIndex == ModelIndex.LDT_ALIAS) {
            return new LinearDT_Inversion(scheme);
        }
        if (modelIndex == ModelIndex.LDT_WTD) {
            return new WeightedLinearDT_Inversion(scheme);
        }
        if (modelIndex == ModelIndex.ALGDT) {
            return new AlgebraicDT_Inversion(scheme);
        }
        return new NonLinearDT_Inversion(scheme, modelIndex);
    }

    @Override
    public int itemsPerVoxel() {
        return 8;
    }
}

