/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.Scheme;
import inverters.LinearDT_Inversion;
import misc.DT;
import numerics.Vector3D;
import optimizers.MarquardtChiSqFitter;
import optimizers.MarquardtMinimiserException;

public class BallStickFitter
extends MarquardtChiSqFitter {
    private Scheme ip;
    private LinearDT_Inversion inv;
    protected double[] taus;
    protected final int noParams = 5;

    public BallStickFitter(Scheme scheme) throws MarquardtMinimiserException {
        this.ip = scheme;
        int n = scheme.numMeasurements();
        double[][] dArrayArray = new double[n][];
        double[] dArray = scheme.getDiffusionTimes();
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = scheme.getQ(i);
        }
        this.inv = new LinearDT_Inversion(scheme);
        this.initialize(dArrayArray, dArray);
    }

    protected void initialize(double[][] dArray, double[] dArray2) throws MarquardtMinimiserException {
        this.taus = new double[dArray2.length + 1];
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            this.taus[i + 1] = dArray2[i];
        }
        this.initData(dArray, dArray3, 5);
    }

    public void newDepVals(double[] dArray) throws MarquardtMinimiserException {
        if (dArray.length != this.y.length - 1) {
            System.err.println(dArray.length + " " + (this.y.length - 1));
            throw new MarquardtMinimiserException("New data contains the wrong number of values.");
        }
        for (int i = 0; i < this.ndata; ++i) {
            this.y[i + 1] = dArray[i];
        }
        this.initASigs();
    }

    protected void initASigs() {
        double[] dArray = new double[this.ndata];
        for (int i = 0; i < this.ndata; ++i) {
            dArray[i] = this.y[i + 1];
        }
        double[] dArray2 = this.inv.invert(dArray);
        DT dT = new DT(dArray2[2], dArray2[3], dArray2[4], dArray2[5], dArray2[6], dArray2[7]);
        double d = Math.exp(dArray2[1]);
        double[][] dArray3 = dT.sortedEigenSystem();
        Vector3D vector3D = new Vector3D(dArray3[1][0], dArray3[2][0], dArray3[3][0]);
        double[] dArray4 = Vector3D.thetaPhi(vector3D);
        double d2 = 1.5707963267948966 - dArray4[0];
        double d3 = -dArray4[1];
        double d4 = dT.fa();
        this.a[1] = Math.sqrt(d);
        this.a[2] = Math.sqrt(dT.trace() / 3.0);
        this.a[3] = d4 < 0.1 ? Math.acos(Math.sqrt(0.1)) : (d4 > 0.9 ? Math.acos(Math.sqrt(0.9)) : Math.acos(Math.sqrt(d4)));
        this.a[4] = d2;
        this.a[5] = d3;
        double d5 = 0.0;
        for (int i = 1; i <= this.ndata; ++i) {
            double d6 = d * Math.exp(-this.taus[i] * dT.contractBy(this.x[i]));
            d5 += (this.y[i] - d6) * (this.y[i] - d6) / ((double)this.ndata - 5.0);
        }
        double d7 = Math.sqrt(d5);
        for (int i = 1; i <= this.ndata; ++i) {
            this.sig[i] = d7;
        }
    }

    @Override
    public double[] getParameters() {
        return new double[]{0.0, Math.log(this.a[1] * this.a[1]), this.a[2] * this.a[2], Math.cos(this.a[3]) * Math.cos(this.a[3]), this.a[4], this.a[5]};
    }

    @Override
    public void setInitParams(double[] dArray) throws MarquardtMinimiserException {
        this.a[1] = Math.sqrt(Math.exp(dArray[0]));
        this.a[2] = Math.sqrt(dArray[1]);
        this.a[3] = dArray[2];
        this.a[4] = Math.acos(Math.sqrt(dArray[3]));
        this.a[5] = dArray[4];
    }

    @Override
    protected double yfit(double[] dArray, int n) {
        double d = dArray[1];
        double d2 = dArray[2];
        double d3 = dArray[3];
        double d4 = dArray[4];
        double d5 = dArray[5];
        double d6 = Math.sin(d4);
        double d7 = Math.cos(d4);
        double d8 = Math.sin(d5);
        double d9 = Math.cos(d5);
        double d10 = this.x[n][0];
        double d11 = this.x[n][1];
        double d12 = this.x[n][2];
        double d13 = Math.cos(d3);
        double d14 = d * d * (d13 * d13 / Math.exp(d2 * d2 * this.taus[n] * (d10 * (d10 * (d9 * d9) * (d7 * d7) + d11 * d9 * (d7 * d7) * d8 - d12 * d9 * d7 * d6) + d11 * (d10 * d9 * (d7 * d7) * d8 + d11 * (d7 * d7) * (d8 * d8) - d12 * d7 * d8 * d6) + d12 * (-(d10 * d9 * d7 * d6) - d11 * d7 * d8 * d6 + d12 * (d6 * d6)))) + (1.0 - d13 * d13) / Math.exp(d2 * d2 * (d10 * d10 + d11 * d11 + d12 * d12) * this.taus[n]));
        return d14;
    }

    @Override
    protected double[] dydas(double[] dArray, int n) {
        double d = dArray[1];
        double d2 = dArray[2];
        double d3 = dArray[3];
        double d4 = dArray[4];
        double d5 = dArray[5];
        double[] dArray2 = new double[6];
        double d6 = Math.sin(d4);
        double d7 = Math.cos(d4);
        double d8 = Math.sin(d5);
        double d9 = Math.cos(d5);
        double d10 = Math.sin(d3);
        double d11 = Math.cos(d3);
        double d12 = this.x[n][0];
        double d13 = this.x[n][1];
        double d14 = this.x[n][2];
        double d15 = (d12 * d9 * d7 + d13 * d7 * d8 - d14 * d6) * (d12 * d9 * d7 + d13 * d7 * d8 - d14 * d6);
        double d16 = Math.exp(d2 * d2 * this.taus[n] * d15);
        dArray2[1] = 2.0 * d * (d11 * d11 / d16 + (1.0 - d11 * d11) / Math.exp(d2 * d2 * (d12 * d12 + d13 * d13 + d14 * d14) * this.taus[n]));
        dArray2[2] = d * d * (-2.0 * d2 * (d12 * d12 + d13 * d13 + d14 * d14) * this.taus[n] * (1.0 - d11 * d11) / Math.exp(d2 * d2 * (d12 * d12 + d13 * d13 + d14 * d14) * this.taus[n]) - 2.0 * d2 * this.taus[n] * (d11 * d11) * d15 / d16);
        dArray2[3] = -2.0 * (Math.exp(d2 * d2 * (d12 * d12 + d13 * d13 + d14 * d14) * this.taus[n]) - d16) * (d * d) * d11 * d10 / Math.exp(d2 * d2 * this.taus[n] * (d12 * d12 + d13 * d13 + d14 * d14 + d12 * d12 * (d9 * d9) * (d7 * d7) + d13 * (d7 * d7) * d8 * (2.0 * d12 * d9 + d13 * d8) - 2.0 * d12 * d14 * d9 * d7 * d6 - 2.0 * d13 * d14 * d7 * d8 * d6 + d14 * d14 * (d6 * d6)));
        dArray2[4] = 2.0 * (d2 * d2) * (d * d) * this.taus[n] * (d11 * d11) * (d13 * d14 * (d7 * d7) * d8 + d12 * d12 * (d9 * d9) * d7 * d6 + d7 * (-(d14 * d14) + d13 * d13 * (d8 * d8)) * d6 - d13 * d14 * d8 * (d6 * d6) + d12 * d9 * (d14 * (d7 * d7) - d14 * (d6 * d6) + d13 * d8 * Math.sin(2.0 * d4))) / d16;
        dArray2[5] = -2.0 * (d2 * d2) * (d * d) * this.taus[n] * (d11 * d11) * d7 * (d13 * d9 - d12 * d8) * (d12 * d9 * d7 + d13 * d7 * d8 - d14 * d6) / d16;
        return dArray2;
    }
}

