/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import imaging.Scheme;
import imaging.SchemeV1;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.logging.Logger;
import misc.LoggedException;

public class SchemeV3
implements Scheme {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final double GAMMA = SchemeV1.GAMMA;
    private final int numMeas;
    private final int numZeroMeas;
    private final double[][] gDir;
    private final double[] modQ;
    private final double[] modG;
    private final double[] bigDel;
    private final double[] del1;
    private final double[] t_del1;
    private final double[] del2;
    private final double[] t_del2;
    private final double[] del3;
    private final double[] t_del3;
    private final double[] del4;
    private final double[] t_del4;
    private final double[] TE;
    private final boolean[] zero;
    private final double[] halfP90;
    private int ignoreMeasurements = 0;

    public SchemeV3(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Scanner scanner = new Scanner(new File(string));
            scanner.useDelimiter("\r\n|\n");
            String string2 = scanner.next();
            while (scanner.hasNext()) {
                arrayList.add(scanner.next());
            }
            scanner.close();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        this.numMeas = arrayList.size();
        this.gDir = new double[this.numMeas][3];
        this.modQ = new double[this.numMeas];
        this.modG = new double[this.numMeas];
        this.bigDel = new double[this.numMeas];
        this.del1 = new double[this.numMeas];
        this.t_del1 = new double[this.numMeas];
        this.del2 = new double[this.numMeas];
        this.t_del2 = new double[this.numMeas];
        this.del3 = new double[this.numMeas];
        this.t_del3 = new double[this.numMeas];
        this.del4 = new double[this.numMeas];
        this.t_del4 = new double[this.numMeas];
        this.TE = new double[this.numMeas];
        this.zero = new boolean[this.numMeas];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            Scanner scanner = new Scanner((String)arrayList.get(i));
            this.gDir[i][0] = scanner.nextDouble();
            this.gDir[i][1] = scanner.nextDouble();
            this.gDir[i][2] = scanner.nextDouble();
            this.modG[i] = scanner.nextDouble();
            this.bigDel[i] = scanner.nextDouble();
            this.t_del1[i] = scanner.nextDouble();
            this.del1[i] = scanner.nextDouble();
            this.t_del2[i] = scanner.nextDouble();
            this.del2[i] = scanner.nextDouble();
            this.t_del3[i] = this.t_del2[i] + this.del2[i];
            this.del3[i] = scanner.nextDouble();
            System.err.println(i + ": gDir= (" + this.gDir[i][0] + "," + this.gDir[i][1] + "," + this.gDir[i][2] + ") G=" + this.modG[i] + " DEL=" + this.bigDel[i] + "t_del1= " + this.t_del1[i] + " t_del2= " + this.t_del2[i] + " t_del3=" + this.t_del3[i] + " del1= " + this.del1[i] + " del2= " + this.del2[i] + " del3= " + this.del3[i]);
            if (this.del3[i] > this.del1[i] + this.del2[i]) {
                throw new LoggedException(" third gradient pulse in direction " + i + " of schemefile is longer than sum of first two.");
            }
            this.t_del4[i] = scanner.nextDouble();
            this.del4[i] = this.del1[i] + this.del2[i] - this.del3[i];
            this.TE[i] = scanner.nextDouble();
            scanner.close();
            this.modQ[i] = GAMMA * (this.del1[i] + this.del2[i]) * this.modG[i];
            boolean bl = this.zero[i] = this.modQ[i] == 0.0;
            if (!this.zero[i]) continue;
            ++n;
        }
        this.numZeroMeas = n;
        this.halfP90 = new double[this.numMeas];
    }

    private SchemeV3(double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9, double[] dArray10, double[] dArray11) {
        this.numMeas = dArray.length;
        this.gDir = dArray;
        this.modG = dArray2;
        this.bigDel = dArray3;
        this.del1 = dArray4;
        this.t_del1 = dArray5;
        this.del2 = dArray6;
        this.t_del2 = dArray7;
        this.del3 = dArray8;
        this.t_del4 = dArray9;
        this.TE = dArray10;
        this.halfP90 = dArray11;
        this.zero = new boolean[this.numMeas];
        this.t_del3 = new double[this.numMeas];
        this.del4 = new double[this.numMeas];
        this.modQ = new double[this.numMeas];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            this.t_del3[i] = dArray7[i] + dArray6[i];
            this.del4[i] = dArray4[i] + dArray6[i] - dArray8[i];
            this.modQ[i] = GAMMA * (dArray4[i] + dArray6[i]) * dArray2[i];
            if (dArray2[i] == 0.0) {
                this.zero[i] = true;
                ++n;
                continue;
            }
            this.zero[i] = false;
        }
        this.numZeroMeas = n;
    }

    @Override
    public void flipX() {
        for (int i = 0; i < this.gDir.length; ++i) {
            double[] dArray = this.gDir[i];
            dArray[0] = dArray[0] * -1.0;
        }
    }

    @Override
    public void flipY() {
        for (int i = 0; i < this.gDir.length; ++i) {
            double[] dArray = this.gDir[i];
            dArray[1] = dArray[1] * -1.0;
        }
    }

    @Override
    public void flipZ() {
        for (int i = 0; i < this.gDir.length; ++i) {
            double[] dArray = this.gDir[i];
            dArray[2] = dArray[2] * -1.0;
        }
    }

    @Override
    public double geoMeanZeroMeas(double[] dArray) {
        if (this.numZeroMeas == 0) {
            return 0.0;
        }
        double d = 1.0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (!this.zero[i]) continue;
            d *= dArray[i];
        }
        return Math.pow(d, 1.0 / (double)this.numZeroMeas);
    }

    @Override
    public double getDELTA(int n) {
        return this.bigDel[n];
    }

    @Override
    public double getDelta(int n) {
        return this.del1[n] + this.del2[n];
    }

    @Override
    public double getDiffusionTime(int n) {
        return this.bigDel[n] - (this.del1[n] + this.del2[n]) / 3.0;
    }

    @Override
    public double[] getDiffusionTimes() {
        double[] dArray = new double[this.numMeas];
        for (int i = 0; i < this.numMeas; ++i) {
            dArray[i] = this.getDiffusionTime(i);
        }
        return dArray;
    }

    @Override
    public double getHalfP90(int n) {
        return this.halfP90[n];
    }

    @Override
    public int getIgnore() {
        return this.ignoreMeasurements;
    }

    @Override
    public double getMeanNonZeroModQ() {
        double d = 0.0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            d += this.modQ[i];
        }
        return d / (double)(this.numMeas - this.numZeroMeas);
    }

    @Override
    public double getModG(int n) {
        return this.modG[n];
    }

    @Override
    public double getModQ(int n) {
        return this.modQ[n];
    }

    @Override
    public double[] getNonZeroQ_DiffusionTimes() {
        double[] dArray = new double[this.numMeas - this.numZeroMeas];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            dArray[n] = this.getDiffusionTime(i);
            ++n;
        }
        return dArray;
    }

    @Override
    public double[][] getNormNonZeroQs() {
        double[][] dArray = new double[this.numMeas - this.numZeroMeas][3];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            for (int j = 0; j < 3; ++j) {
                dArray[n][j] = this.gDir[i][j];
            }
            ++n;
        }
        return dArray;
    }

    @Override
    public double[][] getNonZeroQs() {
        double[][] dArray = new double[this.numMeas - this.numZeroMeas][3];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            for (int j = 0; j < 3; ++j) {
                dArray[n][j] = this.modQ[i] * this.gDir[i][j];
            }
            ++n;
        }
        return dArray;
    }

    @Override
    public double[] getQ(int n) {
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray[i] = this.gDir[n][i] * this.modQ[n];
        }
        return dArray;
    }

    @Override
    public Scheme getSubsetScheme(int[] nArray) {
        int n = nArray.length;
        double[][] dArray = new double[n][3];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double[] dArray9 = new double[n];
        double[] dArray10 = new double[n];
        double[] dArray11 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = this.gDir[nArray[i]][0];
            dArray[i][1] = this.gDir[nArray[i]][1];
            dArray[i][2] = this.gDir[nArray[i]][2];
            dArray2[i] = this.modG[nArray[i]];
            dArray3[i] = this.bigDel[nArray[i]];
            dArray4[i] = this.del1[nArray[i]];
            dArray5[i] = this.t_del1[nArray[i]];
            dArray6[i] = this.del2[nArray[i]];
            dArray7[i] = this.t_del2[nArray[i]];
            dArray8[i] = this.del3[nArray[i]];
            dArray9[i] = this.t_del4[nArray[i]];
            dArray10[i] = this.TE[nArray[i]];
            dArray11[i] = this.halfP90[i];
        }
        return new SchemeV3(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9, dArray10, dArray11);
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public void gradOrder(int[] nArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.gDir.length; ++i) {
            d = this.gDir[i][nArray[0]];
            d2 = this.gDir[i][nArray[1]];
            d3 = this.gDir[i][nArray[2]];
            this.gDir[i][0] = d;
            this.gDir[i][1] = d2;
            this.gDir[i][2] = d3;
        }
    }

    @Override
    public double[] normalizeData(double[] dArray) {
        double d = this.geoMeanZeroMeas(dArray);
        if (d == 0.0) {
            this.logger.warning("Mean b=0 measurement is zero.  Cannot normalize.");
            d = 1.0;
        }
        double[] dArray2 = new double[this.numMeas - this.numZeroMeas];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            dArray2[n] = dArray[i] / d;
            ++n;
        }
        return dArray2;
    }

    @Override
    public int numMeasurements() {
        return this.numMeas;
    }

    @Override
    public int numZeroMeasurements() {
        return this.numZeroMeas;
    }

    @Override
    public void setDELTA(double d, int n) {
        this.bigDel[n] = d;
    }

    @Override
    public void setDelta(double d, int n) {
        this.logger.warning("setDelta in scheme V2 called. no action taken.");
    }

    @Override
    public void setDiffusionTime(double d, int n) {
        this.logger.warning("attempt to directly set diffusion time in V2 scheme. no action taken");
    }

    @Override
    public void setHalfP90(double d, int n) {
        this.halfP90[n] = d;
    }

    @Override
    public void setIgnore(int n) {
        this.ignoreMeasurements = n;
    }

    @Override
    public void setModG(double d, int n) {
        this.modG[n] = d;
    }

    public final double getTdel1(int n) {
        return this.t_del1[n];
    }

    public final double getTdel2(int n) {
        return this.t_del2[n];
    }

    public final double getTdel3(int n) {
        return this.t_del3[n];
    }

    public final double getTdel4(int n) {
        return this.t_del4[n];
    }

    public final double getDel1(int n) {
        return this.del1[n];
    }

    public final double getDel2(int n) {
        return this.del2[n];
    }

    public final double getDel3(int n) {
        return this.del3[n];
    }

    public final double getDel4(int n) {
        return this.del4[n];
    }

    @Override
    public int numDWMeasurements() {
        return this.numMeasurements() - this.numZeroMeasurements();
    }

    @Override
    public boolean isIgnored(int n) {
        return false;
    }

    @Override
    public int numIgnoredMeasurements() {
        return 0;
    }
}

