/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import imaging.ScannerSequences;
import imaging.Scheme;
import java.text.DecimalFormat;
import java.util.logging.Logger;
import misc.LoggedException;
import misc.SphericalPoints;
import simulation.SimulationParams;
import tools.FileInput;

public class SchemeV0
implements Scheme {
    private static final Logger logger = Logger.getLogger("camino.imaging.SchemeV0");
    public static final double GAMMA = 2.6751987E8;
    private String schemeString = null;
    protected double[][] q;
    protected double tau;
    protected int M;
    protected double meanNonZeroModQ = -1.0;
    protected int ignoreMeasurements;
    private double delta = 0.034;
    private double DELTA = 0.04;
    private double modG = 0.022;
    private double halfP90 = 0.0;

    public SchemeV0(double[][] dArray, double d) {
        this.init(dArray, d);
    }

    public SchemeV0(int n, int n2, double d, double d2) {
        int n3;
        this.tau = d2;
        this.M = n;
        this.q = new double[n2 + n][3];
        for (int i = 0; i < n; ++i) {
            for (n3 = 0; n3 < 3; ++n3) {
                this.q[i][n3] = 0.0;
            }
        }
        double[][] dArray = SphericalPoints.getElecPointSet(n2);
        for (n3 = 0; n3 < n2; ++n3) {
            for (int i = 0; i < 3; ++i) {
                this.q[n3 + n][i] = dArray[n3][i] * d;
            }
        }
    }

    public SchemeV0(String string) {
        this(string, 1.0, 1.0);
    }

    public SchemeV0(String string, double d, double d2) {
        FileInput fileInput = new FileInput(string);
        double d3 = fileInput.readDouble() * d2;
        int n = (int)fileInput.readDouble();
        if (n == 0) {
            throw new LoggedException("Number of measurements in scheme file " + string + " is 0");
        }
        double[][] dArray = new double[n][3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = fileInput.readDouble() * d;
            }
        }
        fileInput.close();
        if (SimulationParams.sim_delta_set || SimulationParams.sim_DELTA_set || SimulationParams.sim_G_set) {
            logger.warning("commandline values for delta (" + SimulationParams.sim_delta + "s), DELTA (" + SimulationParams.sim_DELTA + "s) and G (" + SimulationParams.sim_G + "Tm^-1) will override those specified in scheme file");
            double d4 = SimulationParams.sim_delta;
            double d5 = SimulationParams.sim_DELTA;
            double d6 = SimulationParams.sim_G;
            double d7 = 2.6751987E8 * d5 * d6 * d;
            this.delta = d4;
            this.DELTA = d5;
            this.modG = d6;
            d3 = d5 * d2;
            for (int i = 0; i < n; ++i) {
                int n2;
                double d8 = 0.0;
                for (n2 = 0; n2 < 3; ++n2) {
                    d8 += dArray[i][n2] * dArray[i][n2];
                }
                if ((d8 = Math.sqrt(d8)) == 0.0) continue;
                n2 = 0;
                while (n2 < 3) {
                    double[] dArray2 = dArray[i];
                    int n3 = n2++;
                    dArray2[n3] = dArray2[n3] * (d7 / d8);
                }
            }
        }
        this.init(dArray, d3);
    }

    protected void init(double[][] dArray, double d) {
        this.q = dArray;
        this.tau = d;
        this.ignoreMeasurements = 0;
        this.M = 0;
        while (this.M < this.q.length && this.q[this.M][0] == 0.0 && this.q[this.M][1] == 0.0 && this.q[this.M][2] == 0.0) {
            ++this.M;
        }
    }

    @Override
    public int numMeasurements() {
        return this.q.length - this.ignoreMeasurements;
    }

    @Override
    public int numZeroMeasurements() {
        return this.M;
    }

    @Override
    public double[] getQ(int n) {
        double[] dArray = new double[this.q[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.q[n][i];
        }
        return dArray;
    }

    @Override
    public double getMeanNonZeroModQ() {
        if (this.meanNonZeroModQ != -1.0) {
            return this.meanNonZeroModQ;
        }
        this.meanNonZeroModQ = 0.0;
        int n = this.numMeasurements();
        for (int i = this.M; i < n; ++i) {
            double[] dArray = this.getQ(i);
            double d = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                d += dArray[j] * dArray[j];
            }
            d = Math.sqrt(d);
            this.meanNonZeroModQ += d;
        }
        this.meanNonZeroModQ /= (double)(n - this.M);
        return this.meanNonZeroModQ;
    }

    @Override
    public double getDiffusionTime(int n) {
        return this.tau;
    }

    @Override
    public double getModQ(int n) {
        return Math.sqrt(this.q[n][0] * this.q[n][0] + this.q[n][1] * this.q[n][1] + this.q[n][2] * this.q[n][2]);
    }

    @Override
    public double[] getDiffusionTimes() {
        double[] dArray = new double[this.numMeasurements()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.tau;
        }
        return dArray;
    }

    @Override
    public double[] getNonZeroQ_DiffusionTimes() {
        double[] dArray = new double[this.numMeasurements() - this.M];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.tau;
        }
        return dArray;
    }

    @Override
    public void setDiffusionTime(double d, int n) {
        this.tau = d;
    }

    @Override
    public double[][] getNormNonZeroQs() {
        int n = this.numZeroMeasurements();
        double[][] dArray = new double[this.numMeasurements() - n][3];
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray2 = this.getQ(i + n);
            dArray[i][0] = dArray2[0];
            dArray[i][1] = dArray2[1];
            dArray[i][2] = dArray2[2];
            d = d + dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2];
        }
        double d2 = Math.sqrt(d / (double)dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray3 = dArray[i];
            dArray3[0] = dArray3[0] / d2;
            double[] dArray4 = dArray[i];
            dArray4[1] = dArray4[1] / d2;
            double[] dArray5 = dArray[i];
            dArray5[2] = dArray5[2] / d2;
        }
        return dArray;
    }

    @Override
    public double[][] getNonZeroQs() {
        int n = this.numZeroMeasurements();
        double[][] dArray = new double[this.numMeasurements() - n][3];
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray2 = this.getQ(i + n);
            dArray[i][0] = dArray2[0];
            dArray[i][1] = dArray2[1];
            dArray[i][2] = dArray2[2];
        }
        return dArray;
    }

    @Override
    public void setIgnore(int n) {
        this.ignoreMeasurements = n;
    }

    @Override
    public int getIgnore() {
        return this.ignoreMeasurements;
    }

    @Override
    public double[] normalizeData(double[] dArray) {
        double d = this.geoMeanZeroMeas(dArray);
        d = d == 0.0 ? 1.0 : d;
        double[] dArray2 = new double[dArray.length - this.M];
        for (int i = 0; i < dArray.length - this.M; ++i) {
            dArray2[i] = dArray[i + this.M] / d;
        }
        return dArray2;
    }

    @Override
    public double geoMeanZeroMeas(double[] dArray) {
        if (this.M == 0) {
            return 1.0;
        }
        double d = 1.0;
        for (int i = 0; i < this.M; ++i) {
            d *= dArray[i];
        }
        d = Math.pow(d, 1.0 / (double)this.M);
        return d;
    }

    public static SchemeV0 getSchemeV0(int n) {
        return SchemeV0.getSchemeV0(n, 1.0, 1.0);
    }

    public static SchemeV0 getSchemeV0(int n, double d, double d2) {
        if (n == 0) {
            double d3 = 0.032;
            double d4 = 0.04 * d2;
            double d5 = 0.022;
            double d6 = 2.6751987E8 * d3 * d5 * d;
            double[][] dArray = ScannerSequences.bMatToQ_Hats(ScannerSequences.ion3Z60Q);
            double[][] dArray2 = new double[dArray.length][dArray[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    dArray2[i][j] = dArray[i][j] * d6;
                }
            }
            SchemeV0 schemeV0 = new SchemeV0(dArray2, d4);
            schemeV0.setDelta(d3, 0);
            schemeV0.setModG(d5, 0);
            return schemeV0;
        }
        if (n == 1) {
            double d7 = 0.034;
            double d8 = 0.04 * d2;
            double d9 = 0.022;
            double d10 = 2.6751987E8 * d7 * d9 * d;
            double[][] dArray = ScannerSequences.bMatToQ_Hats(ScannerSequences.ion6Z54Q);
            double[][] dArray3 = new double[dArray.length][dArray[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    dArray3[i][j] = dArray[i][j] * d10;
                }
            }
            SchemeV0 schemeV0 = new SchemeV0(dArray3, d8);
            schemeV0.setDelta(d7, 0);
            schemeV0.setModG(d9, 0);
            return schemeV0;
        }
        if (n == 6 || n == 7) {
            int n2;
            int n3;
            double d11 = 0.034;
            double d12 = 0.04 * d2;
            double d13 = 0.022;
            double d14 = 2.6751987E8 * d11 * d13 * d;
            double[][] dArray = ScannerSequences.bMatToQ_Hats(ScannerSequences.ion6Z54Q_Iso);
            double[][] dArray4 = new double[dArray.length][dArray[0].length];
            for (n3 = 0; n3 < dArray.length - 6; ++n3) {
                for (n2 = 0; n2 < dArray[0].length; ++n2) {
                    dArray4[n3][n2] = dArray[n3][n2] * d14;
                }
            }
            for (n3 = dArray.length - 6; n3 < dArray.length; ++n3) {
                for (n2 = 0; n2 < dArray[0].length; ++n2) {
                    dArray4[n3][n2] = dArray[n3][n2] * d14 / 2.0;
                }
            }
            SchemeV0 schemeV0 = new SchemeV0(dArray4, d12);
            if (n == 7) {
                schemeV0.setIgnore(6);
            }
            schemeV0.setDelta(d11, 0);
            schemeV0.setModG(d13, 0);
            return schemeV0;
        }
        if (n == 8) {
            double d15 = 0.034;
            double d16 = 0.04 * d2;
            double d17 = 0.022;
            double d18 = 2.6751987E8 * d15 * d17 * d;
            double[][] dArray = ScannerSequences.bMatToQ_Hats(ScannerSequences.sghms2Z46Q);
            double[][] dArray5 = new double[dArray.length][dArray[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    dArray5[i][j] = dArray[i][j] * d18;
                }
            }
            SchemeV0 schemeV0 = new SchemeV0(dArray5, d16);
            schemeV0.setDelta(d15, 0);
            schemeV0.setModG(d17, 0);
            return schemeV0;
        }
        if (n > 9000 && n < 10000) {
            double d19 = (double)(n - 9000) / 1000.0;
            double d20 = 0.01247487;
            double d21 = -0.00361185;
            double d22 = 0.0419707;
            double d23 = d19 / 2.0 - d20;
            double d24 = (d19 / 2.0 - d21 - d20 / 3.0) * d2;
            double d25 = 2.6751987E8 * d23 * d22 * d;
            double[][] dArray = ScannerSequences.mancM8N61;
            double[][] dArray6 = new double[dArray.length][dArray[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    dArray6[i][j] = dArray[i][j] * d25;
                }
            }
            SchemeV0 schemeV0 = new SchemeV0(dArray6, d24);
            schemeV0.setDelta(d23, 0);
            schemeV0.setModG(d22, 0);
            return schemeV0;
        }
        throw new RuntimeException("Did not recognize b-matrix index.(bmxIndex=" + n + "). Did you forget the scheme file?");
    }

    @Override
    public double getDelta(int n) {
        return this.delta;
    }

    @Override
    public void setDelta(double d, int n) {
        this.delta = d;
    }

    @Override
    public double getDELTA(int n) {
        return this.DELTA;
    }

    @Override
    public void setDELTA(double d, int n) {
        this.DELTA = d;
    }

    @Override
    public double getModG(int n) {
        return this.modG;
    }

    @Override
    public void setModG(double d, int n) {
        this.modG = d;
    }

    @Override
    public double getHalfP90(int n) {
        return this.halfP90;
    }

    @Override
    public void setHalfP90(double d, int n) {
        this.halfP90 = d;
    }

    @Override
    public final int getVersion() {
        return 0;
    }

    @Override
    public Scheme getSubsetScheme(int[] nArray) {
        int n = nArray.length;
        double[][] dArray = new double[n][3];
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = this.q[nArray[i]][0];
            dArray[i][1] = this.q[nArray[i]][1];
            dArray[i][2] = this.q[nArray[i]][2];
        }
        SchemeV0 schemeV0 = new SchemeV0(dArray, this.tau);
        return schemeV0;
    }

    @Override
    public void flipX() {
        for (int i = 0; i < this.q.length; ++i) {
            this.q[i][0] = -1.0 * this.q[i][0];
        }
    }

    @Override
    public void flipY() {
        for (int i = 0; i < this.q.length; ++i) {
            this.q[i][1] = -1.0 * this.q[i][1];
        }
    }

    @Override
    public void flipZ() {
        for (int i = 0; i < this.q.length; ++i) {
            this.q[i][2] = -1.0 * this.q[i][2];
        }
    }

    @Override
    public void gradOrder(int[] nArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.q.length; ++i) {
            d = this.q[i][nArray[0]];
            d2 = this.q[i][nArray[1]];
            d3 = this.q[i][nArray[2]];
            this.q[i][0] = d;
            this.q[i][1] = d2;
            this.q[i][2] = d3;
        }
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(decimalFormat.format(this.tau));
        stringBuffer.append("\n");
        stringBuffer.append(this.q.length);
        stringBuffer.append("\n");
        for (int i = 0; i < this.q.length; ++i) {
            stringBuffer.append(decimalFormat.format(this.q[i][0]));
            stringBuffer.append("\n");
            stringBuffer.append(decimalFormat.format(this.q[i][1]));
            stringBuffer.append("\n");
            stringBuffer.append(decimalFormat.format(this.q[i][2]));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public int numDWMeasurements() {
        return this.numMeasurements() - this.numZeroMeasurements();
    }

    @Override
    public boolean isIgnored(int n) {
        return false;
    }

    @Override
    public int numIgnoredMeasurements() {
        return this.ignoreMeasurements;
    }
}

