/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import data.DataSource;
import imaging.AnalyzeHeader;
import imaging.MetaImageHeader;
import imaging.Nifti1Dataset;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import misc.LoggedException;

public abstract class ImageHeader {
    private static Logger logger = Logger.getLogger("camino.imaging.ImageHeader");

    public abstract int xDataDim();

    public abstract int yDataDim();

    public abstract int zDataDim();

    public abstract int[] getDataDims();

    public abstract double xVoxelDim();

    public abstract double yVoxelDim();

    public abstract double zVoxelDim();

    public abstract double[] getVoxelDims();

    public abstract int components();

    public abstract double[] getOrigin();

    public abstract DataSource getImageDataSource();

    public abstract double[][][][] readVolumeData();

    public abstract double[][][] readVolume(int var1);

    public static boolean imageExists(String string) {
        if (string.endsWith(".nii") || string.endsWith(".nii.gz") || string.endsWith(".mha") || string.endsWith(".mhd")) {
            File file = new File(string);
            return file.exists();
        }
        return AnalyzeHeader.getImageRoot(string) != null;
    }

    public static ImageHeader readHeader(String string) throws IOException {
        if (string == null) {
            throw new LoggedException("File name required to read image header (format determined by extension)");
        }
        if (AnalyzeHeader.getImageRoot(string) != null) {
            String string2 = AnalyzeHeader.getImageRoot(string);
            File file = new File(string2 + ".hdr");
            long l = file.length();
            if (l == 348L) {
                return AnalyzeHeader.readHeader(string2 + ".hdr");
            }
            if (l > 348L) {
                return Nifti1Dataset.readHeader(string2 + ".hdr");
            }
            throw new LoggedException("Image header " + string + " is smaller than 348 bytes.");
        }
        if (string.endsWith(".nii") || string.endsWith(".nii.gz")) {
            return Nifti1Dataset.readHeader(string);
        }
        if (string.endsWith(".mhd") || string.endsWith(".mha")) {
            return MetaImageHeader.readHeader(string);
        }
        throw new LoggedException("Can't find image for input file name " + string);
    }

    public static boolean checkDims(String string, int[] nArray, double[] dArray) {
        ImageHeader imageHeader = null;
        try {
            imageHeader = ImageHeader.readHeader(string);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        if (imageHeader.xVoxelDim() < 0.0 || imageHeader.yVoxelDim() < 0.0 || imageHeader.zVoxelDim() < 0.0) {
            logger.warning("Negative voxel size specified in one or more image files. Using absolute values.");
        }
        if ((double)nArray[0] == 0.0 && (double)nArray[1] == 0.0 && (double)nArray[2] == 0.0) {
            nArray[0] = imageHeader.xDataDim();
            nArray[1] = imageHeader.yDataDim();
            nArray[2] = imageHeader.zDataDim();
        } else if (nArray[0] != imageHeader.xDataDim() || nArray[1] != imageHeader.yDataDim() || nArray[2] != imageHeader.zDataDim()) {
            logger.warning("Inconsistent data dimensions detected. Data dimensions of " + string + " are " + imageHeader.xDataDim() + " " + imageHeader.yDataDim() + " " + imageHeader.zDataDim());
            return false;
        }
        if (dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 0.0) {
            dArray[0] = imageHeader.xVoxelDim();
            dArray[1] = imageHeader.yVoxelDim();
            dArray[2] = imageHeader.zVoxelDim();
        } else if (Math.abs(dArray[0] - imageHeader.xVoxelDim()) > 1.0E-6 || Math.abs(dArray[1] - imageHeader.yVoxelDim()) > 1.0E-6 || Math.abs(dArray[2] - imageHeader.zVoxelDim()) > 1.0E-6) {
            logger.warning("Inconsistent voxel dimensions detected. Voxel dimensions of " + string + " are " + imageHeader.xVoxelDim() + " " + imageHeader.yVoxelDim() + " " + imageHeader.zVoxelDim());
            return false;
        }
        return true;
    }
}

