/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import imaging.Scheme;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Logger;
import misc.LoggedException;
import simulation.SimulationParams;

public class B_MatrixScheme
implements Scheme {
    private static final Logger logger = Logger.getLogger("camino.imaging.B_MatrixScheme");
    public static final double GAMMA = 2.6751987E8;
    protected double[][] gDir;
    protected double[] bVal;
    protected double[][] q;
    protected double tau = 0.029;
    protected boolean[] zero;
    protected int numMeas;
    protected int numZeroMeas;
    protected double meanNonZeroModQ = -1.0;
    protected int ignoreMeasurements;
    private double DELTA = 0.04;
    private double delta = 0.033;
    private double modG = 0.022;
    private double halfP90 = 0.0;

    public B_MatrixScheme(String string) {
        this(string, 1.0, 1.0);
    }

    @Override
    public int numDWMeasurements() {
        return this.numMeasurements() - this.numZeroMeasurements();
    }

    @Override
    public boolean isIgnored(int n) {
        return false;
    }

    public B_MatrixScheme(String string, double d, double d2) {
        Object object;
        Object object2;
        Vector<String> vector = new Vector<String>();
        try {
            Scanner scanner = new Scanner(new File(string));
            scanner.useDelimiter("\r\n|\n");
            object2 = scanner.next();
            object = "VERSION: 2";
            if (!((String)object).equals(object2)) {
                throw new LoggedException("Attempted to create Version 2 scheme but scheme file is not version 2");
            }
            while (scanner.hasNext()) {
                String string2 = scanner.next();
                if (string2.length() <= 0) continue;
                vector.add(string2);
            }
            scanner.close();
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        if (vector.size() == 0) {
            throw new LoggedException("Number of measurements in scheme file " + string + " is 0");
        }
        int n = vector.size();
        object2 = new double[n][3];
        object = new double[n];
        for (int i = 0; i < n; ++i) {
            Scanner scanner = new Scanner((String)vector.elementAt(i));
            object2[i][0] = scanner.nextDouble();
            object2[i][1] = scanner.nextDouble();
            object2[i][2] = scanner.nextDouble();
            double d3 = Math.sqrt((double)(object2[i][0] * object2[i][0] + object2[i][1] * object2[i][1] + object2[i][2] * object2[i][2]));
            if (d3 > 0.0 && Math.abs(1.0 - d3) > 1.0E-5) {
                Object object3 = object2[i];
                object3[0] = object3[0] / d3;
                Object object4 = object2[i];
                object4[1] = object4[1] / d3;
                Object object5 = object2[i];
                object5[2] = object5[2] / d3;
            }
            object[i] = scanner.nextDouble();
        }
        this.init((double[][])object2, (double[])object, d, d2);
    }

    public B_MatrixScheme(double[][] dArray, double[] dArray2, double d, double d2) {
        this.init(dArray, dArray2, d, d2);
    }

    private void init(double[][] dArray, double[] dArray2, double d, double d2) {
        this.gDir = dArray;
        this.bVal = dArray2;
        this.numMeas = dArray.length;
        this.numZeroMeas = 0;
        this.ignoreMeasurements = 0;
        this.zero = new boolean[this.numMeas];
        this.tau *= d2;
        this.q = new double[this.numMeas][3];
        for (int i = 0; i < this.numMeas; ++i) {
            double d3 = d * Math.sqrt(dArray2[i] / this.tau);
            if (d3 == 0.0) {
                ++this.numZeroMeas;
                this.zero[i] = true;
            }
            this.q[i][0] = dArray[i][0] * d3;
            this.q[i][1] = dArray[i][1] * d3;
            this.q[i][2] = dArray[i][2] * d3;
        }
        if (SimulationParams.sim_delta_set || SimulationParams.sim_DELTA_set || SimulationParams.sim_G_set) {
            logger.warning("commandline values for delta (" + SimulationParams.sim_delta + "s), DELTA (" + SimulationParams.sim_DELTA + "s) and G (" + SimulationParams.sim_G + "Tm^-1) will override those specified in scheme file");
            double d4 = SimulationParams.sim_delta;
            double d5 = SimulationParams.sim_DELTA;
            double d6 = SimulationParams.sim_G;
            double d7 = 2.6751987E8 * d5 * d6 * d;
            this.delta = d4;
            this.modG = d6;
            this.tau = (d5 - d4 / 3.0) * d2;
            double d8 = d7 * d7 * this.tau;
            for (int i = 0; i < this.numMeas; ++i) {
                if (!this.zero[i]) {
                    dArray2[i] = d8;
                }
                for (int j = 0; j < 3; ++j) {
                    if (this.zero[i]) continue;
                    this.q[i][j] = dArray[i][j] * d7;
                }
            }
        }
    }

    @Override
    public int numMeasurements() {
        return this.numMeas - this.ignoreMeasurements;
    }

    @Override
    public int numZeroMeasurements() {
        return this.numZeroMeas;
    }

    @Override
    public int numIgnoredMeasurements() {
        return 0;
    }

    @Override
    public double[] getQ(int n) {
        double[] dArray = new double[this.q[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.q[n][i];
        }
        return dArray;
    }

    @Override
    public double getMeanNonZeroModQ() {
        if (this.meanNonZeroModQ != -1.0) {
            return this.meanNonZeroModQ;
        }
        this.meanNonZeroModQ = 0.0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            double[] dArray = this.getQ(i);
            double d = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                d += dArray[j] * dArray[j];
            }
            d = Math.sqrt(d);
            this.meanNonZeroModQ += d;
        }
        this.meanNonZeroModQ /= (double)(this.numMeas - this.numZeroMeas);
        return this.meanNonZeroModQ;
    }

    @Override
    public double getDiffusionTime(int n) {
        return this.tau;
    }

    @Override
    public double getModQ(int n) {
        return Math.sqrt(this.q[n][0] * this.q[n][0] + this.q[n][1] * this.q[n][1] + this.q[n][2] * this.q[n][2]);
    }

    @Override
    public double[] getDiffusionTimes() {
        double[] dArray = new double[this.numMeas];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.tau;
        }
        return dArray;
    }

    @Override
    public double[] getNonZeroQ_DiffusionTimes() {
        double[] dArray = new double[this.numMeas - this.numZeroMeas];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.tau;
        }
        return dArray;
    }

    @Override
    public void setDiffusionTime(double d, int n) {
        this.tau = d;
    }

    @Override
    public double[][] getNormNonZeroQs() {
        double[][] dArray = new double[this.numMeas - this.numZeroMeas][3];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            dArray[n][0] = this.gDir[i][0];
            dArray[n][1] = this.gDir[i][1];
            dArray[n][2] = this.gDir[i][2];
            ++n;
        }
        return dArray;
    }

    @Override
    public double[][] getNonZeroQs() {
        double[][] dArray = new double[this.numMeas - this.numZeroMeas][3];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            dArray[n][0] = this.q[i][0];
            dArray[n][1] = this.q[i][1];
            dArray[n][2] = this.q[i][2];
            ++n;
        }
        return dArray;
    }

    @Override
    public void setIgnore(int n) {
        logger.warning("Ignoring measurements is only supported by Scheme V0");
        this.ignoreMeasurements = n;
    }

    @Override
    public int getIgnore() {
        return this.ignoreMeasurements;
    }

    @Override
    public double[] normalizeData(double[] dArray) {
        double d = this.geoMeanZeroMeas(dArray);
        if (d == 0.0) {
            logger.warning("Mean b=0 measurement is zero.  Cannot normalize.");
            d = 1.0;
        }
        double[] dArray2 = new double[this.numMeas - this.numZeroMeas];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            dArray2[n] = dArray[i] / d;
            ++n;
        }
        return dArray2;
    }

    @Override
    public double geoMeanZeroMeas(double[] dArray) {
        if (this.numZeroMeas == 0) {
            return 0.0;
        }
        double d = 1.0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (!this.zero[i]) continue;
            d *= dArray[i];
        }
        return Math.pow(d, 1.0 / (double)this.numZeroMeas);
    }

    @Override
    public double getDelta(int n) {
        return this.delta;
    }

    @Override
    public void setDelta(double d, int n) {
        this.delta = d;
    }

    @Override
    public double getDELTA(int n) {
        return this.DELTA;
    }

    @Override
    public void setDELTA(double d, int n) {
        this.DELTA = d;
    }

    @Override
    public double getModG(int n) {
        return this.modG;
    }

    @Override
    public void setModG(double d, int n) {
        this.modG = d;
    }

    @Override
    public double getHalfP90(int n) {
        return this.halfP90;
    }

    @Override
    public void setHalfP90(double d, int n) {
        this.halfP90 = d;
    }

    @Override
    public final int getVersion() {
        return 2;
    }

    @Override
    public Scheme getSubsetScheme(int[] nArray) {
        int n = nArray.length;
        double[][] dArray = new double[n][3];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = this.gDir[nArray[i]][0];
            dArray[i][1] = this.gDir[nArray[i]][1];
            dArray[i][2] = this.gDir[nArray[i]][2];
            dArray2[i] = this.bVal[nArray[i]];
        }
        B_MatrixScheme b_MatrixScheme = new B_MatrixScheme(dArray, dArray2, 1.0, 1.0);
        return b_MatrixScheme;
    }

    @Override
    public void flipX() {
        for (int i = 0; i < this.q.length; ++i) {
            this.gDir[i][0] = -this.gDir[i][0];
            this.q[i][0] = -this.q[i][0];
        }
    }

    @Override
    public void flipY() {
        for (int i = 0; i < this.q.length; ++i) {
            this.gDir[i][0] = -this.gDir[i][1];
            this.q[i][0] = -this.q[i][1];
        }
    }

    @Override
    public void flipZ() {
        for (int i = 0; i < this.q.length; ++i) {
            this.gDir[i][0] = -this.gDir[i][2];
            this.q[i][0] = -this.q[i][2];
        }
    }

    @Override
    public void gradOrder(int[] nArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.numMeas; ++i) {
            d = this.q[i][nArray[0]];
            d2 = this.q[i][nArray[1]];
            d3 = this.q[i][nArray[2]];
            this.q[i][0] = d;
            this.q[i][1] = d2;
            this.q[i][2] = d3;
            d = this.gDir[i][nArray[0]];
            d2 = this.gDir[i][nArray[1]];
            d3 = this.gDir[i][nArray[2]];
            this.gDir[i][0] = d;
            this.gDir[i][1] = d2;
            this.gDir[i][2] = d3;
        }
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("   0.000000;  -0.000000");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("VERSION: 2");
        stringBuffer.append("\n");
        for (int i = 0; i < this.numMeas; ++i) {
            stringBuffer.append(decimalFormat.format(this.gDir[i][0]));
            stringBuffer.append(decimalFormat.format(this.gDir[i][1]));
            stringBuffer.append(decimalFormat.format(this.gDir[i][2]));
            stringBuffer.append(decimalFormat.format(this.bVal[i]));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

