/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSource;
import data.DataSourceException;
import imaging.Scheme;
import java.util.Random;
import misc.LoggedException;
import numerics.MTRandom;
import numerics.RealMatrix;

public abstract class WildBootstrapDataSynth
implements DataSource {
    private final DataSource rawDataSource;
    protected final int samples;
    protected final int components;
    protected int samplesGenerated = 0;
    protected double alpha = -1.0;
    protected final Random ran;
    protected boolean logData = false;
    protected boolean normalizeData = false;
    protected RealMatrix epsilon;
    protected double[] weightedResiduals;
    protected RealMatrix mu;
    protected double meanS0;
    protected RealMatrix H;
    protected RealMatrix X;
    protected RealMatrix linearInv;
    protected boolean reachedEndOfFile;
    protected boolean noMoreData;
    protected Scheme ip;

    public WildBootstrapDataSynth(DataSource dataSource, Scheme scheme, int n) {
        this(dataSource, scheme, n, new MTRandom(2350L));
    }

    public WildBootstrapDataSynth(DataSource dataSource, Scheme scheme, int n, int n2) {
        this(dataSource, scheme, n, new MTRandom(n2));
    }

    public WildBootstrapDataSynth(DataSource dataSource, Scheme scheme, int n, Random random) {
        this.rawDataSource = dataSource;
        this.ip = scheme;
        this.components = this.ip.numMeasurements();
        this.samples = n;
        this.ran = random;
    }

    protected void init() {
        this.reachedEndOfFile = false;
        this.initializeReconSpecificParams();
        if (this.rawDataSource != null) {
            try {
                this.getNextSourceVoxel();
            }
            catch (DataSourceException dataSourceException) {
                throw new LoggedException(dataSourceException);
            }
        } else {
            this.noMoreData = true;
        }
    }

    protected abstract void initializeReconSpecificParams();

    @Override
    public final double[] nextVoxel() {
        if (this.noMoreData) {
            throw new DataSourceException("No more voxels in data source.");
        }
        double[] dArray = this.getBootstrapSample();
        if (this.samples > -1) {
            ++this.samplesGenerated;
        }
        if (this.samplesGenerated == this.samples) {
            if (this.reachedEndOfFile || this.rawDataSource == null) {
                this.noMoreData = true;
            } else {
                this.getNextSourceVoxel();
            }
        }
        return dArray;
    }

    protected double[] getBootstrapSample() {
        double[] dArray = new double[this.components];
        for (int i = 0; i < this.components; ++i) {
            double d = this.ran.nextBoolean() ? 1.0 : -1.0;
            dArray[i] = this.mu.entries[i][0] + d * this.weightedResiduals[i];
            if (this.logData) {
                dArray[i] = Math.exp(dArray[i]);
            }
            if (!this.normalizeData) continue;
            int n = i;
            dArray[n] = dArray[n] * this.meanS0;
        }
        return dArray;
    }

    @Override
    public boolean more() {
        return !this.noMoreData;
    }

    protected void getNextSourceVoxel() {
        if (this.reachedEndOfFile) {
            this.noMoreData = true;
            throw new DataSourceException("No more voxels in data source.");
        }
        double[][] dArrayArray = new double[][]{this.rawDataSource.nextVoxel()};
        this.setSourceData(dArrayArray);
        if (!this.rawDataSource.more()) {
            this.reachedEndOfFile = true;
        }
    }

    public void setSourceData(float[] fArray) {
        double[][] dArray = new double[1][fArray.length];
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[0][i] = fArray[i];
        }
        this.setSourceData(dArray);
    }

    public void setSourceData(double[] dArray) {
        double[][] dArray2 = new double[1][dArray.length];
        System.arraycopy(dArray, 0, dArray2[0], 0, dArray.length);
        this.setSourceData(dArray2);
    }

    private void setSourceData(double[][] dArray) {
        this.noMoreData = false;
        this.samplesGenerated = 0;
        this.meanS0 = this.ip.geoMeanZeroMeas(dArray[0]);
        if (this.meanS0 == 0.0) {
            this.meanS0 = 1.0;
        }
        if (this.normalizeData) {
            dArray[0] = this.ip.normalizeData(dArray[0]);
        }
        if (this.logData) {
            dArray[0] = this.getLogData(dArray[0]);
        }
        RealMatrix realMatrix = new RealMatrix(dArray).transpose();
        RealMatrix realMatrix2 = this.linearInv.product(realMatrix);
        this.mu = this.X.product(realMatrix2);
        this.epsilon = realMatrix.sub(this.mu);
        this.calculateWeightedResiduals();
    }

    protected void calculateWeightedResiduals() {
        this.weightedResiduals = new double[this.components];
        for (int i = 0; i < this.components; ++i) {
            this.weightedResiduals[i] = this.epsilon.entries[i][0] / Math.pow(1.0 - this.H.entries[i][i], this.alpha);
        }
    }

    protected double[] getLogData(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] > 0.0 ? Math.log(dArray[i]) : 0.0;
        }
        return dArray2;
    }

    public void setHC2() {
        this.alpha = -0.5;
        this.calculateWeightedResiduals();
    }

    public void setHC3() {
        this.alpha = -1.0;
        this.calculateWeightedResiduals();
    }
}

