/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSource;
import data.WildBootstrapDataSynth;
import imaging.Scheme;
import java.util.Random;
import misc.LoggedException;
import numerics.MTRandom;
import numerics.RealMatrix;

public class WildBS_DT_DataSynth
extends WildBootstrapDataSynth {
    public WildBS_DT_DataSynth(DataSource dataSource, Scheme scheme, int n) {
        this(dataSource, scheme, n, new MTRandom(2350L));
    }

    public WildBS_DT_DataSynth(DataSource dataSource, Scheme scheme, int n, int n2) {
        this(dataSource, scheme, n, new MTRandom(n2));
    }

    public WildBS_DT_DataSynth(DataSource dataSource, Scheme scheme, int n, Random random) {
        super(dataSource, scheme, n, random);
        this.logData = true;
        this.init();
    }

    @Override
    protected void initializeReconSpecificParams() {
        Object object;
        this.X = new RealMatrix(this.ip.numMeasurements(), 7);
        for (int i = 0; i < this.X.rows(); ++i) {
            object = this.ip.getQ(i);
            double d = this.ip.getDiffusionTime(i);
            this.X.setEntry(i, 0, 1.0);
            this.X.setEntry(i, 1, -d * object[0] * object[0]);
            this.X.setEntry(i, 2, -2.0 * d * object[0] * object[1]);
            this.X.setEntry(i, 3, -2.0 * d * object[0] * object[2]);
            this.X.setEntry(i, 4, -d * object[1] * object[1]);
            this.X.setEntry(i, 5, -2.0 * d * object[1] * object[2]);
            this.X.setEntry(i, 6, -d * object[2] * object[2]);
        }
        RealMatrix realMatrix = this.X.transpose().product(this.X);
        object = null;
        try {
            object = realMatrix.inverse();
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.linearInv = ((RealMatrix)object).product(this.X.transpose());
        this.H = this.X.product(this.linearInv);
    }
}

