/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.GaussianMixture;
import data.ModelPDF;
import misc.DT;
import numerics.RealMatrix;
import numerics.Rotations;

public class StandardTestFunctions {
    protected static double traceD = 2.1E-9;
    protected static double lambda1 = 1.7E-9;
    protected static double[] mix3 = new double[]{0.5, 0.5};
    protected static double[] mix4 = new double[]{0.3333333333333333, 0.3333333333333333, 0.3333333333333333};
    protected static double scaleFactor = 1.0;
    protected static double dt2rotangle = 0.0;
    protected static RealMatrix trans = RealMatrix.identity(3);
    protected static DT dt0;
    protected static DT dt1;
    protected static DT dt2;
    protected static DT dt3;
    protected static DT dt4;
    private static boolean parametersChanged;

    public static ModelPDF getFunction(int n) {
        if (parametersChanged) {
            StandardTestFunctions.constructDTs();
        }
        if (n == 0 || n == 1 || n == 2) {
            DT[] dTArray = new DT[]{n == 0 ? dt0 : (n == 1 ? dt1 : dt4)};
            double[] dArray = new double[]{1.0};
            return new GaussianMixture(dTArray, dArray);
        }
        if (n == 3) {
            DT[] dTArray = new DT[]{dt1, dt2};
            return new GaussianMixture(dTArray, mix3);
        }
        if (n == 4) {
            DT[] dTArray = new DT[]{dt1, dt2, dt3};
            return new GaussianMixture(dTArray, mix4);
        }
        throw new RuntimeException("Unrecognized test function (index=" + n + ") requested.");
    }

    public static void reset() {
        traceD = 2.1E-9;
        lambda1 = 1.7E-9;
        double[] dArray = new double[]{0.5, 0.5};
        mix3 = dArray;
        double[] dArray2 = new double[]{0.3333333333333333, 0.3333333333333333, 0.3333333333333333};
        mix4 = dArray2;
        scaleFactor = 1.0;
        dt2rotangle = 0.0;
        trans = RealMatrix.identity(3);
    }

    public static void setScale(double d) {
        scaleFactor = d;
        parametersChanged = true;
    }

    public static void setDT2RotationAngle(double d) {
        dt2rotangle = d;
        parametersChanged = true;
    }

    public static void setTraceD(double d) {
        traceD = d;
        parametersChanged = true;
    }

    public static void setLambda1(double d) {
        lambda1 = d;
        parametersChanged = true;
    }

    public static void setMix3(double d) {
        StandardTestFunctions.mix3[0] = d;
        StandardTestFunctions.mix3[1] = 1.0 - d;
    }

    public static void setMix4(double d, double d2) {
        StandardTestFunctions.mix3[0] = d;
        StandardTestFunctions.mix3[1] = d2;
        StandardTestFunctions.mix3[2] = 1.0 - d - d2;
    }

    public static void setTransformation(RealMatrix realMatrix) {
        trans = realMatrix;
        parametersChanged = true;
    }

    protected static void constructDTs() {
        double d = traceD / 3.0;
        dt0 = new DT(d, 0.0, 0.0, d, 0.0, d);
        double d2 = (traceD - lambda1) / 2.0;
        dt1 = new DT(lambda1, 0.0, 0.0, d2, 0.0, d2);
        dt2 = new DT(d2, 0.0, 0.0, lambda1, 0.0, d2);
        dt3 = new DT(d2, 0.0, 0.0, d2, 0.0, lambda1);
        double d3 = (lambda1 + d2) / 2.0;
        dt4 = new DT(d3, 0.0, 0.0, d3, 0.0, d2);
        if (dt2rotangle != 0.0) {
            double[] dArray = new double[]{0.0, 0.0, 1.0};
            RealMatrix realMatrix = Rotations.getRotMat(dArray, dt2rotangle);
            dt2 = dt2.transform(realMatrix);
        }
        dt0 = dt0.transform(trans).scale(scaleFactor);
        dt1 = dt1.transform(trans).scale(scaleFactor);
        dt2 = dt2.transform(trans).scale(scaleFactor);
        dt3 = dt3.transform(trans).scale(scaleFactor);
        dt4 = dt4.transform(trans).scale(scaleFactor);
    }

    public static RealMatrix getRotationMatrix() {
        return trans;
    }

    static {
        parametersChanged = true;
    }
}

