/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSourceException;
import data.ExternalDataSource;
import java.io.EOFException;
import misc.LoggedException;

public class ScannerOrderDataSource
extends ExternalDataSource {
    protected int numVoxels;
    protected int nextVoxel = 0;
    protected double[][] data;

    public ScannerOrderDataSource(String string, int n, int n2, String string2) {
        this.initFileInput(string, false, 0);
        this.init(n, n2, string2);
    }

    public ScannerOrderDataSource(String string, int n, int n2, String string2, boolean bl) {
        this.initFileInput(string, bl, 0);
        this.init(n, n2, string2);
    }

    public ScannerOrderDataSource(String string, int n, int n2, String string2, boolean bl, int n3) {
        this.initFileInput(string, bl, n3);
        this.init(n, n2, string2);
    }

    public ScannerOrderDataSource(double[][] dArray) {
        this.data = dArray;
        this.numVoxels = dArray.length;
        this.numComponents = dArray[0].length;
    }

    protected void init(int n, int n2, String string) {
        this.numComponents = n2;
        this.numVoxels = n;
        this.data = new double[this.numVoxels][this.numComponents];
        try {
            this.datatype = ScannerOrderDataSource.getDataTypeCode(string);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        for (int i = 0; i < this.numComponents; ++i) {
            for (int j = 0; j < this.numVoxels; ++j) {
                try {
                    if (this.datatype == 0) {
                        this.data[j][i] = this.dataIn.readByte();
                        continue;
                    }
                    if (this.datatype == 6) {
                        this.data[j][i] = this.dataIn.readUnsignedByte();
                        continue;
                    }
                    if (this.datatype == 1) {
                        this.data[j][i] = this.dataIn.readShort();
                        continue;
                    }
                    if (this.datatype == 2) {
                        this.data[j][i] = this.dataIn.readInt();
                        continue;
                    }
                    if (this.datatype == 7) {
                        this.data[j][i] = this.dataIn.readUnsignedShort();
                        continue;
                    }
                    if (this.datatype == 8) {
                        this.data[j][i] = this.dataIn.readUnsignedInt();
                        continue;
                    }
                    if (this.datatype == 3) {
                        this.data[j][i] = this.dataIn.readLong();
                        continue;
                    }
                    if (this.datatype == 4) {
                        this.data[j][i] = this.dataIn.readFloat();
                        continue;
                    }
                    if (this.datatype != 5) continue;
                    this.data[j][i] = this.dataIn.readDouble();
                    continue;
                }
                catch (EOFException eOFException) {
                    throw new LoggedException("\nRan out of data.  Check inputdatatype.\nCurrently reading input data as " + ScannerOrderDataSource.typeString(this.datatype) + ". \n" + eOFException);
                }
                catch (Exception exception) {
                    throw new LoggedException(exception);
                }
            }
        }
    }

    @Override
    public double[] nextVoxel() throws DataSourceException {
        if (this.nextVoxel >= this.numVoxels) {
            throw new DataSourceException("No more voxels.");
        }
        double[] dArray = this.data[this.nextVoxel];
        ++this.nextVoxel;
        return dArray;
    }

    @Override
    public boolean more() {
        return this.nextVoxel < this.numVoxels;
    }
}

