/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.ModelPDF;
import misc.DT;

public class GaussianMixture
implements ModelPDF {
    protected DT[] dt;
    protected DT[] invDT;
    protected double[] sqrtDeterm;
    protected double[] mix;

    public GaussianMixture(DT[] dTArray, double[] dArray) {
        this.dt = new DT[dTArray.length];
        this.mix = new double[dArray.length];
        for (int i = 0; i < this.dt.length; ++i) {
            this.dt[i] = (DT)dTArray[i].clone();
            this.mix[i] = dArray[i];
        }
    }

    @Override
    public double at(double[] dArray, double d) {
        if (this.invDT == null) {
            this.computeInverses();
        }
        double d2 = 0.0;
        for (int i = 0; i < this.invDT.length; ++i) {
            d2 += this.mix[i] * Math.exp(-this.invDT[i].contractBy(dArray) / (4.0 * d)) / this.sqrtDeterm[i];
        }
        double d3 = Math.sqrt(1984.4017075391882 * d * d * d);
        return d2 / d3;
    }

    @Override
    public double ftAt(double[] dArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.dt.length; ++i) {
            d2 += this.mix[i] * Math.exp(-d * this.dt[i].contractBy(dArray));
        }
        return d2;
    }

    @Override
    public double[][] getPDs() {
        double[][] dArray = new double[this.dt.length][3];
        for (int i = 0; i < this.dt.length; ++i) {
            double[] dArray2 = this.dt[i].getPD();
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = dArray2[j];
            }
        }
        return dArray;
    }

    public DT[] getTensors() {
        DT[] dTArray = new DT[this.dt.length];
        for (int i = 0; i < this.dt.length; ++i) {
            dTArray[i] = this.dt[i];
        }
        return dTArray;
    }

    private void computeInverses() {
        this.invDT = new DT[this.dt.length];
        this.sqrtDeterm = new double[this.dt.length];
        for (int i = 0; i < this.dt.length; ++i) {
            this.invDT[i] = this.dt[i].inverse();
            this.sqrtDeterm[i] = Math.sqrt(this.dt[i].determinant());
        }
    }

    public String toString() {
        String string = "p = \n";
        for (int i = 0; i < this.dt.length; ++i) {
            string = string + this.mix[i] + " X " + this.dt[i].toString();
            if (i >= this.dt.length - 1) continue;
            string = string + " +\n";
        }
        return string;
    }
}

