/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSource;
import data.DataSourceException;
import data.ModelPDF;
import imaging.Scheme;
import java.util.Random;
import numerics.Complex;
import tools.CL_Initializer;

public class DataSynthesizer
implements DataSource {
    protected Scheme imParams;
    protected ModelPDF p;
    protected double snr;
    protected double[] noiseFreeSamples;
    protected int numVoxels = -1;
    protected int voxelNum;
    protected Random r;

    public DataSynthesizer(ModelPDF modelPDF, Scheme scheme, double d) {
        this.init(modelPDF, scheme, d, -1, 0);
    }

    public DataSynthesizer(ModelPDF modelPDF, Scheme scheme, double d, int n) {
        this.init(modelPDF, scheme, d, n, 0);
    }

    public DataSynthesizer(ModelPDF modelPDF, Scheme scheme, double d, int n, int n2) {
        this.init(modelPDF, scheme, d, n, n2);
    }

    public DataSynthesizer(ModelPDF modelPDF, Scheme scheme, double d, int n, Random random) {
        this.init(modelPDF, scheme, d, n, 0);
        this.r = random;
    }

    protected void init(ModelPDF modelPDF, Scheme scheme, double d, int n, int n2) {
        this.imParams = scheme;
        this.p = modelPDF;
        this.snr = d;
        this.noiseFreeSamples = new double[this.imParams.numMeasurements()];
        for (int i = 0; i < this.noiseFreeSamples.length; ++i) {
            this.noiseFreeSamples[i] = this.p.ftAt(scheme.getQ(i), scheme.getDiffusionTime(i));
        }
        this.r = new Random(n2);
        this.numVoxels = n;
        this.voxelNum = 1;
    }

    @Override
    public double[] nextVoxel() throws DataSourceException {
        double[] dArray;
        if (this.numVoxels >= 0 && this.voxelNum > this.numVoxels) {
            throw new DataSourceException("Exceeded the specified number of voxels.");
        }
        ++this.voxelNum;
        if (this.snr <= 0.0) {
            int n = this.noiseFreeSamples.length;
            dArray = new double[n];
            System.arraycopy(this.noiseFreeSamples, 0, dArray, 0, n);
        } else {
            dArray = CL_Initializer.noiseType.equals("gaussian") ? DataSynthesizer.addGaussianNoise(this.noiseFreeSamples, this.snr > 0.0 ? 1.0 / this.snr : 0.0, this.r) : DataSynthesizer.addNoise(this.noiseFreeSamples, this.snr > 0.0 ? 1.0 / this.snr : 0.0, this.r);
        }
        return dArray;
    }

    @Override
    public boolean more() {
        return this.numVoxels >= 0 && this.voxelNum <= this.numVoxels;
    }

    public static double[] addNoise(double[] dArray, double d, Random random) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            Complex complex = new Complex(dArray[i] + random.nextGaussian() * d, random.nextGaussian() * d);
            dArray2[i] = complex.mod();
        }
        return dArray2;
    }

    public static double[] addGaussianNoise(double[] dArray, double d, Random random) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] + random.nextGaussian() * d;
        }
        return dArray2;
    }
}

