/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSource;
import data.DataSourceException;
import data.ExternalDataSource;
import data.VoxelOrderDataSource;
import java.util.Random;
import misc.LoggedException;
import numerics.MTRandom;

public class BootstrapDataSynthesizer
implements DataSource {
    private DataSource[] rawDataSources;
    protected int repeats;
    protected int samples;
    protected int components;
    protected int samplesGenerated = 0;
    protected Random ran;
    protected double[][] next;
    protected boolean reachedEndOfFile;
    protected boolean noMoreData;

    protected BootstrapDataSynthesizer() {
    }

    protected BootstrapDataSynthesizer(int n) {
        this.repeats = n;
    }

    public BootstrapDataSynthesizer(String[] stringArray, int n, int n2, String string) {
        this(stringArray, n, n2, string, new MTRandom(2350L));
    }

    public BootstrapDataSynthesizer(String[] stringArray, int n, int n2, String string, int n3) {
        this(stringArray, n, n2, string, new MTRandom(n3));
    }

    public BootstrapDataSynthesizer(String[] stringArray, int n, int n2, String string, Random random) {
        this.initDataSource(stringArray, n, string);
        this.init(n2, n, random);
    }

    private void initDataSource(String[] stringArray, int n, String string) {
        this.repeats = stringArray.length;
        int n2 = ExternalDataSource.FILEBUFFERSIZE;
        ExternalDataSource.FILEBUFFERSIZE = 0x800000;
        this.rawDataSources = new VoxelOrderDataSource[this.repeats];
        for (int i = 0; i < this.repeats; ++i) {
            this.rawDataSources[i] = new VoxelOrderDataSource(stringArray[i], n, string);
        }
        ExternalDataSource.FILEBUFFERSIZE = n2;
    }

    protected void init(int n, int n2, Random random) {
        this.components = n2;
        this.samples = n;
        this.ran = random;
        this.next = new double[this.repeats][n2];
        this.reachedEndOfFile = false;
        this.noMoreData = false;
        try {
            this.getNextSourceVoxel();
        }
        catch (DataSourceException dataSourceException) {
            throw new LoggedException(dataSourceException);
        }
    }

    @Override
    public double[] nextVoxel() throws DataSourceException {
        double[] dArray = this.getBootstrapSample();
        ++this.samplesGenerated;
        if (this.samplesGenerated == this.samples) {
            if (this.reachedEndOfFile) {
                this.noMoreData = true;
            } else {
                this.getNextSourceVoxel();
                this.samplesGenerated = 0;
            }
        }
        return dArray;
    }

    @Override
    public boolean more() {
        return !this.noMoreData;
    }

    protected double[] getBootstrapSample() {
        double[] dArray = new double[this.components];
        for (int i = 0; i < this.components; ++i) {
            dArray[i] = this.next[this.ran.nextInt(this.repeats)][i];
        }
        return dArray;
    }

    protected void getNextSourceVoxel() throws DataSourceException {
        if (this.reachedEndOfFile) {
            this.noMoreData = true;
            throw new DataSourceException("No more voxels in data source.");
        }
        int n = 0;
        try {
            for (int i = 0; i < this.repeats; ++i) {
                n = i;
                this.next[i] = this.rawDataSources[i].nextVoxel();
                if (this.rawDataSources[i].more()) continue;
                this.reachedEndOfFile = true;
            }
        }
        catch (DataSourceException dataSourceException) {
            this.reachedEndOfFile = true;
            this.noMoreData = true;
            throw new DataSourceException("End of file reached without completing voxel in data source " + n);
        }
    }
}

