/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import imaging.AnalyzeHeader;
import imaging.ImageHeader;
import java.io.IOException;
import misc.LoggedException;
import misc.ScalarImage;
import tools.CL_Initializer;
import tractography.Tract;
import tractography.TractSource;
import tractography.TractStatisticFilter;
import tractography.TractStatisticImage;

public class TractStatistics {
    public static void main(String[] stringArray) {
        boolean bl = true;
        double d = 0.1;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = null;
        CL_Initializer.inputModel = "raw";
        CL_Initializer.CL_init(stringArray);
        String string2 = "tractstats";
        boolean bl5 = false;
        boolean bl6 = false;
        String string3 = "mean";
        String string4 = "mean";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-scalarfile")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-countintersect")) {
                bl5 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-interpolate")) {
                bl6 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-tractstat")) {
                string3 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-imagestat")) {
                string4 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-outputroot")) {
                string2 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-outputimage")) {
                bl4 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-resamplestepsize")) {
                d = Double.parseDouble(stringArray[i + 1]);
                bl2 = true;
                bl3 = true;
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (!stringArray[i].equals("-noresample")) continue;
            bl2 = false;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
        if (CL_Initializer.inputModel.equals("voxels")) {
            bl2 = false;
        }
        if (bl4 && string3.equals("none")) {
            throw new LoggedException("Tract statistic must be specified when an image is to be generated.");
        }
        if (bl2 || bl3) {
            bl2 = true;
        }
        ImageHeader imageHeader = null;
        try {
            Object object;
            ScalarImage scalarImage = null;
            if (string != null) {
                imageHeader = ImageHeader.readHeader(string);
                ImageHeader.checkDims(string, CL_Initializer.dataDims, CL_Initializer.voxelDims);
                object = imageHeader.readVolume(0);
                scalarImage = new ScalarImage((double[][][])object, CL_Initializer.voxelDims);
            }
            object = new TractSource(CL_Initializer.inputFile, CL_Initializer.inputModel, CL_Initializer.voxelDims[0], CL_Initializer.voxelDims[1], CL_Initializer.voxelDims[2]);
            if (bl4) {
                Object object2;
                TractStatisticImage tractStatisticImage = null;
                tractStatisticImage = scalarImage != null ? new TractStatisticImage(scalarImage) : new TractStatisticImage(CL_Initializer.dataDims, CL_Initializer.voxelDims);
                tractStatisticImage.setTractStatistic(string3);
                tractStatisticImage.setImageStatistic(string4);
                tractStatisticImage.setInterpolate(bl6);
                tractStatisticImage.setCountIntersect(bl5);
                while (((TractSource)object).more()) {
                    object2 = ((TractSource)object).nextTract();
                    if (bl2) {
                        object2 = ((Tract)object2).resample(d);
                    }
                    tractStatisticImage.processTract((Tract)object2);
                }
                object2 = tractStatisticImage.getImageStatistic();
                AnalyzeHeader analyzeHeader = AnalyzeHeader.getHeader((double[][][])object2, imageHeader.getVoxelDims(), (short)64);
                AnalyzeHeader.writeImage((double[][][])object2, analyzeHeader, string2, OutputManager.gzipOut);
            } else {
                OutputManager outputManager = new OutputManager();
                TractStatisticFilter tractStatisticFilter = null;
                tractStatisticFilter = scalarImage != null ? new TractStatisticFilter(scalarImage) : new TractStatisticFilter(CL_Initializer.dataDims, CL_Initializer.voxelDims);
                tractStatisticFilter.setTractStatistic(string3);
                tractStatisticFilter.setInterpolate(bl6);
                while (((TractSource)object).more()) {
                    Tract tract = ((TractSource)object).nextTract();
                    if (bl2) {
                        tract = tract.resample(d);
                    }
                    outputManager.output(tractStatisticFilter.processTract(tract));
                }
                outputManager.close();
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }
}

