/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.PointSetToScheme;
import imaging.Scheme;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.Scanner;
import java.util.logging.Logger;
import misc.LoggedException;
import misc.OrderedAcqMinimizer;
import misc.SphericalPoints;
import numerics.MTRandom;
import tools.ArrayOps;
import tools.CL_Initializer;
import tools.FileOutput;

public class SubsetScheme {
    private static final Logger logger = Logger.getLogger("apps/SubsetScheme");

    public static void main(String[] stringArray) {
        int n;
        int n2;
        Scanner scanner;
        if (stringArray.length == 0) {
            System.err.println("SubsetPoints -schemefile <schemefile> -subsetpoints <points> [-imagelist <list> -outputroot <root>]");
            System.exit(0);
        }
        CL_Initializer.CL_init(stringArray);
        int n3 = 0;
        double[][] dArray = null;
        int n4 = 0;
        int[] nArray = null;
        Object object = null;
        int n5 = 0;
        CL_Initializer.initImagingScheme();
        n5 = CL_Initializer.imPars.numMeasurements();
        dArray = CL_Initializer.imPars.getNormNonZeroQs();
        n3 = dArray.length;
        String string = null;
        String[] stringArray2 = null;
        String string2 = "subset";
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-subsetpoints")) {
                string3 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-imagelist")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (!stringArray[i].equals("-outputroot")) continue;
            string2 = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        try {
            scanner = new Scanner(new File(string3)).useDelimiter("\\s+");
            n2 = scanner.nextInt();
            if (n3 != n2) {
                throw new LoggedException("Full scheme has " + n3 + " non-zero q, but " + "subset is from a set of " + n2 + " points");
            }
            n4 = scanner.nextInt();
            nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = scanner.nextInt();
            }
            double[][] dArray2 = PointSetToScheme.readPoints(string3, false, false, false);
            int n6 = 0;
            object = new double[n4][][];
            for (n = 0; n < n4; ++n) {
                object[n] = new double[nArray[n]][];
                for (int i = 0; i < nArray[n]; ++i) {
                    object[n][i] = dArray2[n6++];
                }
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        if (string != null) {
            try {
                scanner = new Scanner(new File(string));
                scanner.useDelimiter("\\n");
                stringArray2 = new String[n5];
                for (n2 = 0; n2 < n5; ++n2) {
                    stringArray2[n2] = scanner.next();
                }
            }
            catch (IOException iOException) {
                logger.warning("Can't process image list " + string + ", image list will " + "not be written");
                stringArray2 = null;
            }
        }
        for (int i = 0; i < n4; ++i) {
            int n7;
            int n8;
            n2 = CL_Initializer.imPars.numZeroMeasurements();
            int n9 = nArray[i] + n2;
            int[] nArray2 = new int[n9];
            n = 0;
            for (n8 = 0; n8 < n5; ++n8) {
                double d = CL_Initializer.imPars.getModQ(n8);
                if (d != 0.0) continue;
                nArray2[n++] = n8;
            }
            for (n8 = 0; n8 < nArray[i]; ++n8) {
                int n10 = 0;
                double d = 0.0;
                for (int j = 0; j < n5; ++j) {
                    double[] dArray3 = CL_Initializer.imPars.getQ(j);
                    double d2 = CL_Initializer.imPars.getModQ(j);
                    dArray3[0] = dArray3[0] / d2;
                    dArray3[1] = dArray3[1] / d2;
                    dArray3[2] = dArray3[2] / d2;
                    double d3 = dArray3[0] * object[i][n8][0] + dArray3[1] * object[i][n8][1] + dArray3[2] * object[i][n8][2];
                    if (!(d3 > d)) continue;
                    n10 = j;
                    d = d3;
                }
                if (d < 0.99984769516) {
                    logger.warning("Couldn't match point " + n8 + " in subset " + i + " to a scheme direction within 1 degree. Closest angle was " + Math.acos(d) * 180.0 / Math.PI);
                }
                nArray2[n++] = n10;
            }
            if (n != nArray2.length) {
                throw new LoggedException("Could not match all points in subset to points in the full set");
            }
            Scheme scheme = CL_Initializer.imPars.getSubsetScheme(nArray2);
            FileOutput fileOutput = new FileOutput(string2 + "_" + i + ".scheme");
            fileOutput.writeString(scheme.toString());
            fileOutput.close();
            fileOutput = new FileOutput(string2 + "_" + i + ".indices");
            for (n7 = 0; n7 < n9; ++n7) {
                fileOutput.writeString(nArray2[n7] + "\n");
            }
            fileOutput.close();
            if (stringArray2 != null) {
                fileOutput = new FileOutput(string2 + "_" + i + ".imagelist");
                for (n7 = 0; n7 < n9; ++n7) {
                    fileOutput.writeString(stringArray2[nArray2[n7]] + "\n");
                }
                fileOutput.close();
            }
            DecimalFormat decimalFormat = new DecimalFormat("0.000");
            double[][] dArray4 = SphericalPoints.getElecPointSet(nArray[i]);
            double[] dArray5 = SubsetScheme.getRandomSubsetEnergy(dArray, nArray[i], 100, new MTRandom(CL_Initializer.seed));
            double d = ArrayOps.mean(dArray5);
            double d4 = ArrayOps.median(dArray5);
            System.out.println("Energy of subset " + i + "\t\t" + decimalFormat.format(SubsetScheme.pointsetEnergy(object[i])));
            System.out.println("Energy of optimal " + nArray[i] + "-point set\t" + decimalFormat.format(SubsetScheme.pointsetEnergy(dArray4)));
            System.out.println("Mean energy of random subset\t" + decimalFormat.format(d));
            System.out.println("Median energy of random subset\t" + decimalFormat.format(d4));
            System.out.println();
        }
    }

    public static double[][] getRandomSubset(double[][] dArray, int n, Random random) {
        int n2;
        int n3 = dArray.length;
        boolean[] blArray = new boolean[n3];
        int n4 = 0;
        while (n4 < n) {
            n2 = random.nextInt(n3);
            if (blArray[n2]) continue;
            blArray[n2] = true;
            ++n4;
        }
        n2 = 0;
        double[][] dArray2 = new double[n][3];
        for (int i = 0; i < n3; ++i) {
            if (!blArray[i]) continue;
            dArray2[n2][0] = dArray[i][0];
            dArray2[n2][1] = dArray[i][1];
            dArray2[n2][2] = dArray[i][2];
            ++n2;
        }
        return dArray2;
    }

    public static double[] getRandomSubsetEnergy(double[][] dArray, int n, int n2, Random random) {
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double[][] dArray3 = SubsetScheme.getRandomSubset(dArray, n, random);
            dArray2[i] = SubsetScheme.pointsetEnergy(dArray3);
        }
        return dArray2;
    }

    public static double pointsetEnergy(double[][] dArray) {
        double[][] dArray2 = OrderedAcqMinimizer.pairEnergyMatrix(dArray);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < i; ++j) {
                d += dArray2[i][j];
            }
        }
        return d;
    }
}

