/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.ExternalDataSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import misc.LoggedException;

public class Shredder {
    private static Logger logger = Logger.getLogger("camino.apps.Shredder");
    public static int FILEBUFFERSIZE = ExternalDataSource.FILEBUFFERSIZE;
    public static DataInputStream in = new DataInputStream(new BufferedInputStream(System.in, FILEBUFFERSIZE));
    public static DataOutputStream out = new DataOutputStream(new BufferedOutputStream(System.out, FILEBUFFERSIZE));
    private static int skipChunkSize = FILEBUFFERSIZE;
    private static byte[] skipChunk = null;

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.err.println("Usage: java Shredder <offset> <chunk size> <space>.\n\n");
            System.exit(0);
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        skipChunk = new byte[skipChunkSize];
        if (n2 == 0) {
            throw new LoggedException("Can't read zero byte chunks");
        }
        boolean bl = false;
        if (n2 < 0) {
            bl = true;
            n2 = -n2;
        }
        byte[] byArray = new byte[n2];
        if (!Shredder.skip(n)) {
            throw new LoggedException("Could not skip initial offset of " + n + " bytes");
        }
        while (Shredder.getChunk(byArray)) {
            if (bl) {
                Shredder.arrFlip(byArray);
            }
            Shredder.output(byArray);
            if (Shredder.skip(n3)) continue;
        }
        try {
            out.close();
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
    }

    public static boolean getChunk(byte[] byArray) {
        int n;
        try {
            int n2;
            for (n = 0; n < byArray.length && (n2 = in.read(byArray, n, byArray.length - n)) != -1; n += n2) {
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        return n > 0;
    }

    public static boolean skip(int n) {
        if (n == 0) {
            return true;
        }
        if (skipChunkSize == 0) {
            throw new LoggedException("Internal error: skip chunk size is zero!");
        }
        int n2 = n / skipChunkSize;
        int n3 = n % skipChunkSize;
        int n4 = 0;
        try {
            int n5;
            int n6;
            for (n6 = 0; n6 < n2; ++n6) {
                int n7;
                for (n5 = 0; n5 < skipChunkSize; n5 += n7) {
                    n7 = in.read(skipChunk, n5, skipChunkSize - n5);
                    if (n7 != -1) continue;
                    return false;
                }
                n4 += n5;
            }
            for (n6 = 0; n6 < n3; n6 += n5) {
                n5 = in.read(skipChunk, n6, n3 - n6);
                if (n5 != -1) continue;
                return false;
            }
            if ((n4 += n6) == n) {
                return true;
            }
            throw new LoggedException("Needed to skip " + n + " bytes, but skipped " + n4);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    public static void output(byte[] byArray) {
        try {
            out.write(byArray);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    public static void arrFlip(byte[] byArray) {
        for (int i = 0; i < byArray.length / 2; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[byArray.length - i - 1];
            byArray[byArray.length - i - 1] = by;
        }
    }
}

