/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import data.ScannerOrderDataSource;
import java.util.logging.Logger;
import tools.CL_Initializer;

public class ScannerToVoxel {
    private static Logger logger = Logger.getLogger("camino.apps.ScannerToVoxel");
    private static int components = 1;
    private static OutputManager om;

    public static void main(String[] stringArray) {
        CL_Initializer.inputDataType = "float";
        OutputManager.outputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-components")) continue;
            components = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i);
            CL_Initializer.markAsParsed(i + 1);
        }
        CL_Initializer.checkParsing(stringArray);
        om = new OutputManager();
        ScannerOrderDataSource scannerOrderDataSource = new ScannerOrderDataSource(CL_Initializer.inputFile, CL_Initializer.numVoxels, components, CL_Initializer.inputDataType);
        while (scannerOrderDataSource.more()) {
            try {
                double[] dArray = scannerOrderDataSource.nextVoxel();
                om.output(dArray);
            }
            catch (Exception exception) {
                logger.warning(exception.toString() + "  (Program will continue)");
            }
        }
        om.close();
    }
}

