/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.FracAnis;
import apps.ModelFit;
import data.OutputManager;
import imaging.ImageHeader;
import java.util.logging.Logger;
import misc.DT;
import misc.LoggedException;
import misc.ScalarImage;
import numerics.Point3D;
import numerics.RealMatrix;
import tools.CL_Initializer;
import tools.FileInput;

public class Reorient {
    private static Logger logger = Logger.getLogger("camino.apps.Reorient");
    private static RealMatrix linear = null;
    private static RealMatrix commonRot = null;
    private static ScalarImage transX = null;
    private static ScalarImage transY = null;
    private static ScalarImage transZ = null;
    private static boolean linearTrans = false;
    private static boolean nonlinearTrans = false;

    public static void main(String[] stringArray) {
        Reorient.initOptions(stringArray);
        OutputManager outputManager = new OutputManager();
        Reorient.initVariables();
        Reorient.execute(outputManager);
        outputManager.close();
    }

    public static void initOptions(String[] stringArray) {
        CL_Initializer.inputModel = "dt";
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initTensorDataSource();
    }

    public static void initVariables() {
        if (CL_Initializer.transformFile == null && CL_Initializer.transformFileX == null) {
            throw new LoggedException("No transformation specified.  Use the -trans option.");
        }
        linear = new RealMatrix(3, 3);
        if (CL_Initializer.transformFile != null && !ImageHeader.imageExists(CL_Initializer.transformFile)) {
            RealMatrix realMatrix = Reorient.readFSL_Affine(CL_Initializer.transformFile);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    Reorient.linear.entries[i][j] = realMatrix.entries[i][j];
                }
            }
            linearTrans = true;
        }
        commonRot = new RealMatrix(3, 3);
        if (linearTrans && CL_Initializer.reorientation.equals("fs")) {
            commonRot = Reorient.getFS_Reorientation(linear).transpose();
        }
        if (CL_Initializer.transformFileX != null) {
            try {
                transX = new ScalarImage(CL_Initializer.transformFileX);
                transY = new ScalarImage(CL_Initializer.transformFileY);
                transZ = new ScalarImage(CL_Initializer.transformFileZ);
                nonlinearTrans = true;
            }
            catch (Exception exception) {
                LoggedException.logExceptionSevere(exception, Thread.currentThread().getName());
                System.exit(1);
            }
        } else if (CL_Initializer.transformFile != null && ImageHeader.imageExists(CL_Initializer.transformFile)) {
            try {
                transX = new ScalarImage(CL_Initializer.transformFile, 0);
                transY = new ScalarImage(CL_Initializer.transformFile, 1);
                transZ = new ScalarImage(CL_Initializer.transformFile, 2);
                nonlinearTrans = true;
            }
            catch (Exception exception) {
                LoggedException.logExceptionSevere(exception, Thread.currentThread().getName());
                System.exit(1);
            }
        }
        if (nonlinearTrans && (CL_Initializer.dataDims[0] == 0 || CL_Initializer.voxelDims[0] == 0.0)) {
            throw new LoggedException("Must specify -datadims and -voxeldims for non-linear transformations.");
        }
    }

    public static void execute(OutputManager outputManager) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (CL_Initializer.data.more()) {
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                DT[] dTArray = FracAnis.getTensorList(dArray, CL_Initializer.inputModel);
                if (dArray[0] >= 0.0 && !ModelFit.isBG(Math.exp(dArray[1]))) {
                    int n4;
                    if (linearTrans) {
                        for (n4 = 0; n4 < dTArray.length; ++n4) {
                            if (CL_Initializer.reorientation.equals("ppd")) {
                                dTArray[n4] = dTArray[n4].ppd(linear);
                                continue;
                            }
                            if (CL_Initializer.reorientation.equals("fs")) {
                                dTArray[n4] = dTArray[n4].iTransform(commonRot);
                                continue;
                            }
                            throw new LoggedException("Unrecognized reorientation strategy: " + CL_Initializer.reorientation);
                        }
                    }
                    if (nonlinearTrans) {
                        for (n4 = 0; n4 < dTArray.length; ++n4) {
                            double d = ((double)n + 0.5) * CL_Initializer.voxelDims[0];
                            double d2 = ((double)n2 + 0.5) * CL_Initializer.voxelDims[1];
                            double d3 = ((double)n3 + 0.5) * CL_Initializer.voxelDims[2];
                            RealMatrix realMatrix = Reorient.getJacobian(transX, transY, transZ, d, d2, d3);
                            RealMatrix realMatrix2 = realMatrix.inverse();
                            if (CL_Initializer.reorientation.equals("ppd")) {
                                dTArray[n4] = dTArray[n4].ppd(realMatrix2);
                                continue;
                            }
                            if (CL_Initializer.reorientation.equals("fs")) {
                                RealMatrix realMatrix3 = Reorient.getFS_Reorientation(realMatrix2).transpose();
                                dTArray[n4] = dTArray[n4].iTransform(realMatrix3);
                                continue;
                            }
                            throw new LoggedException("Unrecognized reorientation strategy: " + CL_Initializer.reorientation);
                        }
                    }
                    Reorient.replaceTensorList(dArray, dTArray, CL_Initializer.inputModel);
                }
                outputManager.output(dArray);
                if (++n == CL_Initializer.dataDims[0]) {
                    n = 0;
                    if (++n2 != CL_Initializer.dataDims[1]) continue;
                    n2 = 0;
                    ++n3;
                    continue;
                }
                if (!nonlinearTrans || n3 != CL_Initializer.dataDims[2]) continue;
                logger.warning("More voxels on input than -datadims specifies.  Probable error.");
            }
            catch (Exception exception) {
                LoggedException.logExceptionSevere(exception, Thread.currentThread().getName());
            }
        }
    }

    public static RealMatrix readFSL_Affine(String string) {
        FileInput fileInput = new FileInput(string);
        RealMatrix realMatrix = new RealMatrix(4, 4);
        for (int i = 0; i < 4; ++i) {
            try {
                String[] stringArray = fileInput.readString().split("\\s+");
                for (int j = 0; j < 4; ++j) {
                    realMatrix.entries[i][j] = Double.parseDouble(stringArray[j]);
                }
                continue;
            }
            catch (Exception exception) {
                throw new LoggedException("Could not parse transformation file: " + string + exception);
            }
        }
        return realMatrix;
    }

    public static RealMatrix getFS_Reorientation(RealMatrix realMatrix) {
        RealMatrix realMatrix2 = realMatrix.product(realMatrix.transpose());
        RealMatrix[] realMatrixArray = realMatrix2.jacobi();
        for (int i = 0; i < realMatrixArray[0].rows(); ++i) {
            if (realMatrixArray[0].entries[i][i] == 0.0) {
                throw new LoggedException("Transformation is singular: " + realMatrix);
            }
            realMatrixArray[0].entries[i][i] = 1.0 / Math.sqrt(realMatrixArray[0].entries[i][i]);
        }
        RealMatrix realMatrix3 = realMatrixArray[1].product(realMatrixArray[0].product(realMatrixArray[1].transpose()));
        return realMatrix3.product(realMatrix);
    }

    public static RealMatrix getJacobian(ScalarImage scalarImage, ScalarImage scalarImage2, ScalarImage scalarImage3, double d, double d2, double d3) {
        Point3D point3D = new Point3D(d, d2, d3);
        double[] dArray = scalarImage.derivAt(point3D);
        double[] dArray2 = scalarImage2.derivAt(point3D);
        double[] dArray3 = scalarImage3.derivAt(point3D);
        RealMatrix realMatrix = new RealMatrix(3, 3);
        int n = 0;
        while (n < 3) {
            realMatrix.entries[0][n] = dArray[n];
            realMatrix.entries[1][n] = dArray2[n];
            realMatrix.entries[2][n] = dArray3[n];
            double[] dArray4 = realMatrix.entries[n];
            int n2 = n++;
            dArray4[n2] = dArray4[n2] + 1.0;
        }
        return realMatrix;
    }

    public static void replaceTensorList(double[] dArray, DT[] dTArray, String string) {
        if (string.equals("dt")) {
            double[] dArray2 = dTArray[0].getComponents();
            for (int i = 0; i < 6; ++i) {
                dArray[i + 2] = dArray2[i];
            }
        } else if (string.equals("twotensor")) {
            double[] dArray3 = dTArray[0].getComponents();
            for (int i = 0; i < 6; ++i) {
                dArray[i + 4] = dArray3[i];
            }
            double[] dArray4 = dTArray[1].getComponents();
            for (int i = 0; i < 6; ++i) {
                dArray[i + 11] = dArray4[i];
            }
        } else if (string.equals("threetensor")) {
            double[] dArray5 = dTArray[0].getComponents();
            for (int i = 0; i < 6; ++i) {
                dArray[i + 4] = dArray5[i];
            }
            double[] dArray6 = dTArray[1].getComponents();
            for (int i = 0; i < 6; ++i) {
                dArray[i + 11] = dArray6[i];
            }
            double[] dArray7 = dTArray[2].getComponents();
            for (int i = 0; i < 6; ++i) {
                dArray[i + 18] = dArray7[i];
            }
        } else if (string.equals("multitensor")) {
            for (int i = 0; i < dTArray.length; ++i) {
                double[] dArray8 = dTArray[i].getComponents();
                for (int j = 0; j < 6; ++j) {
                    dArray[4 + 7 * i + j] = dArray8[j];
                }
            }
        } else {
            throw new LoggedException("Cannot extract tensors from model: " + string);
        }
    }
}

