/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import data.VoxelOrderDataSource;
import java.util.logging.Logger;
import misc.DT;
import misc.LoggedException;
import numerics.PolynomialFunction;
import numerics.Rotations;
import numerics.Vector3D;
import tools.CL_Initializer;
import tractography.LookupTable;
import tractography.OutsideLUTRangeException;

public class PICoPDFs {
    private static int paramsPerPD = 0;
    private static Logger logger = Logger.getLogger("apps/PICoPDFs");
    public static boolean flipX = false;
    public static boolean flipY = false;
    public static boolean flipZ = false;
    private static OutputManager om;

    public static void mapSFData(VoxelOrderDataSource voxelOrderDataSource, String string, boolean bl, String[] stringArray) {
        boolean bl2 = string.equals("watson");
        boolean bl3 = string.equals("bingham");
        boolean bl4 = string.equals("acg");
        if (!(bl2 || bl3 || bl4)) {
            throw new LoggedException("Unrecognized PDF: " + string);
        }
        paramsPerPD = bl2 ? 1 : (bl3 ? 2 : 3);
        PolynomialFunction[][] polynomialFunctionArrayArray = new PolynomialFunction[CL_Initializer.numPDsIO][];
        for (int i = 0; i < CL_Initializer.numPDsIO; ++i) {
            if (stringArray[i] == null) {
                throw new LoggedException("Number of LUTs must be " + CL_Initializer.numPDsIO + ", the maximum number of PDs in each voxel");
            }
            polynomialFunctionArrayArray[i] = PolynomialFunction.readFunctions(stringArray[i]);
        }
        while (voxelOrderDataSource.more()) {
            int n;
            double[] dArray = voxelOrderDataSource.nextVoxel();
            double[][] dArray2 = new double[CL_Initializer.numPDsIO][paramsPerPD];
            double[][] dArray3 = new double[CL_Initializer.numPDsIO][9];
            double[] dArray4 = new double[CL_Initializer.numPDsIO];
            int n2 = 0;
            n2 = (int)dArray[2];
            if (n2 > CL_Initializer.numPDsIO) {
                n2 = CL_Initializer.numPDsIO;
            }
            if (dArray[0] < 0.0) {
                n2 = 0;
            }
            for (n = 0; n < n2; ++n) {
                double d;
                double d2;
                Vector3D vector3D;
                Vector3D vector3D2;
                Vector3D vector3D3 = new Vector3D(dArray[6 + n * 8], dArray[7 + n * 8], dArray[8 + n * 8]);
                if (flipX) {
                    vector3D3 = new Vector3D(-vector3D3.x, vector3D3.y, vector3D3.z);
                }
                if (flipY) {
                    vector3D3 = new Vector3D(vector3D3.x, -vector3D3.y, vector3D3.z);
                }
                if (flipZ) {
                    vector3D3 = new Vector3D(vector3D3.x, vector3D3.y, -vector3D3.z);
                }
                double d3 = dArray[10 + n * 8];
                double d4 = dArray[11 + n * 8];
                double d5 = dArray[12 + n * 8];
                double d6 = dArray[13 + n * 8];
                double d7 = Math.sqrt(4.0 * d4 * d5 + (d3 - d6) * (d3 - d6));
                double d8 = 0.5 * (d3 + d6 + d7);
                double d9 = 0.5 * (d3 + d6 - d7);
                double d10 = dArray[4];
                if (!(Math.abs(d8) > 0.0 && Math.abs(d9) > 0.0 && d10 > 0.0)) {
                    dArray3[n][0] = 1.0;
                    dArray3[n][1] = 0.0;
                    dArray3[n][2] = 0.0;
                    dArray3[n][3] = 0.0;
                    dArray3[n][4] = 1.0;
                    dArray3[n][5] = 0.0;
                    dArray3[n][6] = 0.0;
                    dArray3[n][7] = 0.0;
                    dArray3[n][8] = 1.0;
                    continue;
                }
                if (vector3D3.y * vector3D3.y + vector3D3.x * vector3D3.x == 0.0) {
                    vector3D2 = new Vector3D(0.0, -1.0, 0.0);
                    vector3D = new Vector3D(-1.0, 0.0, 0.0);
                } else {
                    vector3D2 = new Vector3D(vector3D3.y, -1.0 * vector3D3.x, 0.0).normalized();
                    vector3D = new Vector3D(vector3D3.x * vector3D3.z * -1.0, vector3D3.y * vector3D3.z * -1.0, vector3D3.x * vector3D3.x + vector3D3.y * vector3D3.y).normalized();
                }
                double d11 = 1.0;
                double d12 = 0.0;
                if (d4 != 0.0) {
                    d11 = 1.0;
                    d12 = (d8 - d3) / d4;
                }
                double d13 = 0.0;
                double d14 = 1.0;
                if (d9 - d6 != 0.0) {
                    d13 = 1.0;
                    d14 = d5 / (d9 - d6);
                }
                Vector3D vector3D4 = vector3D2.scaled(d11).plus(vector3D.scaled(d12));
                Vector3D vector3D5 = vector3D2.scaled(d13).plus(vector3D.scaled(d14));
                vector3D4 = vector3D4.normalized();
                vector3D5 = vector3D5.normalized();
                if (Math.abs(d8) > Math.abs(d9)) {
                    Vector3D vector3D6 = vector3D4;
                    vector3D4 = vector3D5;
                    vector3D5 = vector3D6;
                    double d15 = d8;
                    d8 = d9;
                    d9 = d15;
                }
                dArray3[n][0] = vector3D3.x;
                dArray3[n][1] = vector3D3.y;
                dArray3[n][2] = vector3D3.z;
                dArray3[n][3] = vector3D4.x;
                dArray3[n][4] = vector3D4.y;
                dArray3[n][5] = vector3D4.z;
                dArray3[n][6] = vector3D5.x;
                dArray3[n][7] = vector3D5.y;
                dArray3[n][8] = vector3D5.z;
                if (bl2) {
                    d2 = (Math.abs(d8) + Math.abs(d9)) / d10;
                    if (bl) {
                        d2 = Math.log(d2);
                        dArray2[n][0] = polynomialFunctionArrayArray[n][0].evaluate(new double[]{d2});
                    } else {
                        dArray2[n][0] = polynomialFunctionArrayArray[n][0].evaluate(new double[]{d2});
                    }
                    if (!(dArray2[n][0] > 100000.0)) continue;
                    logger.warning("kappa out of range, value: " + dArray2[n][0] + ".  Setting to 1E5");
                    dArray2[n][0] = 100000.0;
                    continue;
                }
                if (bl3) {
                    d2 = Math.abs(d9) / d10;
                    d = Math.abs(d8) / d10;
                    if (bl) {
                        d2 = Math.log(d2);
                        d = Math.log(d);
                    }
                    dArray2[n][0] = -1.0 * Math.exp(polynomialFunctionArrayArray[n][0].evaluate(new double[]{d2, d}));
                    dArray2[n][1] = -1.0 * Math.exp(polynomialFunctionArrayArray[n][1].evaluate(new double[]{d2, d}));
                    if (Math.abs(dArray2[n][0]) < Math.abs(dArray2[n][1])) {
                        dArray2[n][0] = dArray2[n][1];
                    }
                    if (Double.isNaN(dArray2[n][0]) || Double.isNaN(dArray2[n][1])) {
                        logger.warning("NaN kappa detected, setting concentration parameters to zero");
                        logger.info("NaN kappa detected. PD index == " + n + "\nfx == " + d2 + "\nfy == " + d + "\n log == " + bl + "\nfunctions[i][0] == " + polynomialFunctionArrayArray[n][0].evaluate(new double[]{d2, d}) + "\nfunctions[i][1] == " + polynomialFunctionArrayArray[n][1].evaluate(new double[]{d2, d}));
                        dArray2[n][0] = 0.0;
                        dArray2[n][1] = 0.0;
                    }
                    if (dArray2[n][0] > 0.0) {
                        dArray2[n][0] = 0.0;
                    } else if (!(dArray2[n][0] < -100000.0)) {
                        logger.warning("kappa1 out of range, value: " + dArray2[n][0] + ".  Setting to -1E5");
                        dArray2[n][0] = -100000.0;
                    }
                    if (dArray2[n][1] > 0.0) {
                        dArray2[n][1] = 0.0;
                    } else if (dArray2[n][1] < -100000.0) {
                        logger.warning("kappa2 out of range, value: " + dArray2[n][0] + ".  Setting to -1E5");
                        dArray2[n][1] = -100000.0;
                    }
                    if (!(Math.abs(dArray2[n][0]) < Math.abs(dArray2[n][1]))) continue;
                    dArray2[n][0] = dArray2[n][1];
                    continue;
                }
                d2 = Math.abs(d9) / d10;
                d = Math.abs(d8) / d10;
                if (bl) {
                    d2 = Math.log(d2);
                    d = Math.log(d);
                    dArray2[n][0] = Math.exp(polynomialFunctionArrayArray[n][0].evaluate(new double[]{d2, d}));
                    dArray2[n][1] = Math.exp(polynomialFunctionArrayArray[n][1].evaluate(new double[]{d2, d}));
                    continue;
                }
                dArray2[n][0] = polynomialFunctionArrayArray[n][0].evaluate(new double[]{d2, d});
                dArray2[n][1] = polynomialFunctionArrayArray[n][1].evaluate(new double[]{d2, d});
                dArray2[n][2] = 1.0;
            }
            om.output(new double[]{n2});
            for (n = 0; n < CL_Initializer.numPDsIO; ++n) {
                if (n2 == 0) {
                    om.output(new double[]{0.0});
                } else {
                    om.output(new double[]{1.0 / (double)n2});
                }
                om.output(dArray3[n]);
                om.output(dArray2[n]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void mapDTData(VoxelOrderDataSource voxelOrderDataSource, LookupTable[] lookupTableArray) {
        while (voxelOrderDataSource.more()) {
            int n;
            double[] dArray = voxelOrderDataSource.nextVoxel();
            double[][] dArray2 = new double[CL_Initializer.numPDsIO][paramsPerPD];
            double[][] dArray3 = new double[CL_Initializer.numPDsIO][9];
            double[] dArray4 = new double[CL_Initializer.numPDsIO];
            double d = 0.0;
            if (!(dArray[0] < 0.0)) {
                double d2;
                if (dArray.length == 8) {
                    d = 1.0;
                    dArray4[0] = 1.0;
                    n = 0;
                    for (int i = 0; i < 6; ++i) {
                        if (!Double.isNaN(dArray[2 + i])) continue;
                        n = 1;
                    }
                    if (n != 0) {
                        d = 0.0;
                    } else {
                        DT dT = new DT(dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7]);
                        boolean bl = false;
                        if (lookupTableArray[0].yMin() == lookupTableArray[0].yMax()) {
                            bl = true;
                        }
                        double[][] dArray5 = dT.sortedEigenSystem();
                        for (int i = 0; i < 3; ++i) {
                            dArray3[0][3 * i + 0] = dArray5[1][i];
                            dArray3[0][3 * i + 1] = dArray5[2][i];
                            dArray3[0][3 * i + 2] = dArray5[3][i];
                        }
                        d2 = dArray5[0][0] / dArray5[0][2];
                        double d3 = dArray5[0][1] / dArray5[0][2];
                        if (!(Double.isNaN(d2) || Double.isInfinite(d2) || Double.isNaN(d3) || Double.isInfinite(d3))) {
                            if (bl) {
                                double d4 = dT.fa();
                                if (d4 >= 0.0 && d4 < 1.0) {
                                    try {
                                        dArray2[0] = lookupTableArray[0].getValues(d4, true, true);
                                    }
                                    catch (OutsideLUTRangeException outsideLUTRangeException) {
                                        throw new LoggedException("Got LUT range exception with clamping on: " + outsideLUTRangeException);
                                    }
                                }
                            } else {
                                try {
                                    dArray2[0] = lookupTableArray[0].getValues(d2, d3, true, true);
                                }
                                catch (OutsideLUTRangeException outsideLUTRangeException) {
                                    throw new LoggedException("Got LUT range exception with clamping on: " + outsideLUTRangeException);
                                }
                            }
                        }
                    }
                } else if (dArray.length == 17) {
                    d = dArray[2];
                    if (d != 0.0) {
                        if (d == 1.0) {
                            DT dT = new DT(dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9]);
                            double[][] dArray6 = dT.sortedEigenSystem();
                            for (int i = 0; i < 3; ++i) {
                                dArray3[0][3 * i + 0] = dArray6[1][i];
                                dArray3[0][3 * i + 1] = dArray6[2][i];
                                dArray3[0][3 * i + 2] = dArray6[3][i];
                            }
                            dArray4[0] = dArray[3];
                            dArray4[1] = dArray[10];
                            double d5 = dArray6[0][0] / dArray6[0][2];
                            d2 = dArray6[0][1] / dArray6[0][2];
                            if (!(Double.isNaN(d5) || Double.isInfinite(d5) || Double.isNaN(d2) || Double.isInfinite(d2))) {
                                try {
                                    dArray2[0] = lookupTableArray[0].getValues(d5, d2, true, true);
                                }
                                catch (OutsideLUTRangeException outsideLUTRangeException) {
                                    throw new LoggedException("Got LUT range exception with clamping on: " + outsideLUTRangeException);
                                }
                            }
                        } else {
                            if (d != 2.0) throw new LoggedException("Invalid number of PDs, " + d + ", in voxel");
                            DT dT = new DT(dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9]);
                            DT dT2 = new DT(dArray[11], dArray[12], dArray[13], dArray[14], dArray[15], dArray[16]);
                            double d6 = dT.fa();
                            d2 = dT2.fa();
                            double[][] dArray7 = dT.sortedEigenSystem();
                            double[][] dArray8 = dT2.sortedEigenSystem();
                            dArray4[0] = dArray[3];
                            dArray4[1] = dArray[10];
                            Vector3D[] vector3DArray = new Vector3D[3];
                            Vector3D[] vector3DArray2 = new Vector3D[3];
                            vector3DArray[0] = new Vector3D(dArray7[1][0], dArray7[2][0], dArray7[3][0]);
                            vector3DArray2[0] = new Vector3D(dArray8[1][0], dArray8[2][0], dArray8[3][0]);
                            double d7 = Math.abs(vector3DArray[0].dot(vector3DArray2[0]));
                            double d8 = Math.acos(d7);
                            if (d7 > 0.9999) {
                                vector3DArray[1] = new Vector3D(dArray7[1][1], dArray7[2][1], dArray7[3][1]);
                                vector3DArray2[1] = new Vector3D(dArray8[1][1], dArray8[2][1], dArray8[3][1]);
                                vector3DArray[2] = new Vector3D(dArray7[1][2], dArray7[2][2], dArray7[3][2]);
                                vector3DArray2[2] = new Vector3D(dArray8[1][2], dArray8[2][2], dArray8[3][2]);
                            } else {
                                vector3DArray[2] = vector3DArray[0].cross(vector3DArray2[0]).normalized();
                                vector3DArray2[2] = vector3DArray[2];
                                vector3DArray[1] = Rotations.rotateVector(vector3DArray[0], vector3DArray[2], 1.5707963267948966);
                                vector3DArray2[1] = Rotations.rotateVector(vector3DArray2[0], vector3DArray2[2], 1.5707963267948966);
                            }
                            if (!(d6 < 0.0 || d2 < 0.0 || d6 > 1.0 || d2 > 1.0 || Double.isNaN(d6) || Double.isInfinite(d6) || Double.isNaN(d2) || Double.isInfinite(d2) || Double.isNaN(d8) || Double.isInfinite(d8))) {
                                try {
                                    double[] dArray9 = lookupTableArray[1].getValues(d6, d2, d8, true, true);
                                    for (int i = 0; i < 2; ++i) {
                                        for (int j = 0; j < paramsPerPD; ++j) {
                                            dArray2[i][j] = dArray9[i * paramsPerPD + j];
                                        }
                                    }
                                }
                                catch (OutsideLUTRangeException outsideLUTRangeException) {
                                    throw new LoggedException("Got LUT range exception with clamping on: " + outsideLUTRangeException);
                                }
                            }
                            for (int i = 0; i < 3; ++i) {
                                dArray3[0][3 * i + 0] = vector3DArray[i].x;
                                dArray3[0][3 * i + 1] = vector3DArray[i].y;
                                dArray3[0][3 * i + 2] = vector3DArray[i].z;
                                dArray3[1][3 * i + 0] = vector3DArray2[i].x;
                                dArray3[1][3 * i + 1] = vector3DArray2[i].y;
                                dArray3[1][3 * i + 2] = vector3DArray2[i].z;
                            }
                        }
                    }
                } else {
                    if (dArray.length != 24) throw new LoggedException("Got unknown data with " + dArray.length + " values per voxel");
                    throw new LoggedException("Three tensor PICo is not available.");
                }
            }
            om.output(new double[]{d});
            for (n = 0; n < CL_Initializer.numPDsIO; ++n) {
                om.output(new double[]{dArray4[n]});
                om.output(dArray3[n]);
                om.output(dArray2[n]);
            }
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        om = new OutputManager();
        String[] stringArray2 = new String[10];
        String string = "bingham";
        boolean bl = true;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].equals("-luts")) {
                n = 0;
                while (n + n2 + 1 < stringArray.length && !stringArray[n + n2 + 1].startsWith("-")) {
                    stringArray2[n] = stringArray[n2 + n + 1];
                    ++n;
                }
                CL_Initializer.markAsParsed(n2, n + 1);
                continue;
            }
            if (stringArray[n2].equals("-flipx")) {
                flipX = true;
                CL_Initializer.markAsParsed(n2);
                continue;
            }
            if (stringArray[n2].equals("-flipy")) {
                flipY = true;
                CL_Initializer.markAsParsed(n2);
                continue;
            }
            if (stringArray[n2].equals("-flipz")) {
                flipZ = true;
                CL_Initializer.markAsParsed(n2);
                continue;
            }
            if (stringArray[n2].equals("-pdf")) {
                string = stringArray[n2 + 1];
                CL_Initializer.markAsParsed(n2, 2);
                continue;
            }
            if (!stringArray[n2].equals("-directmap")) continue;
            bl = false;
            CL_Initializer.markAsParsed(n2);
        }
        CL_Initializer.checkParsing(stringArray);
        n2 = 0;
        n = 1;
        if (CL_Initializer.inputModel == null) {
            throw new LoggedException("This program requires an input model. Specify one with the -inputmodel option");
        }
        if (CL_Initializer.inputModel.equals("pds")) {
            n2 = 6 + 8 * CL_Initializer.numPDsIO;
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, n2, CL_Initializer.inputDataType);
            PICoPDFs.mapSFData(voxelOrderDataSource, string, bl, stringArray2);
        } else {
            if (CL_Initializer.inputModel.equals("dt")) {
                n2 = 8;
            } else if (CL_Initializer.inputModel.equals("multitensor")) {
                n2 = 17;
                n = 2;
                if (CL_Initializer.maxTensorComponents > 2) {
                    throw new LoggedException("Attempted to use unsupported tensor input model with " + CL_Initializer.maxTensorComponents + " components");
                }
            } else {
                throw new LoggedException("Unsupported input model " + CL_Initializer.inputModel);
            }
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, n2, CL_Initializer.inputDataType);
            LookupTable[] lookupTableArray = new LookupTable[n];
            lookupTableArray[0] = LookupTable.readLUT(stringArray2[0]);
            paramsPerPD = lookupTableArray[0].valuesPerPosition();
            for (int i = 1; i < lookupTableArray.length; ++i) {
                lookupTableArray[i] = LookupTable.readLUT(stringArray2[i]);
                if (lookupTableArray[i].valuesPerPosition() == (i + 1) * paramsPerPD) continue;
                throw new LoggedException("LUTs must be the same PDF type for all data");
            }
            PICoPDFs.mapDTData(voxelOrderDataSource, lookupTableArray);
        }
        om.close();
    }
}

