/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.BallSticksOrientationViewer;
import apps.NavPanel;
import apps.PICoPDF_OrientationViewer;
import apps.RGB_ScalarImage;
import apps.SchemePanel;
import apps.SphFuncPeaksOrientationViewer;
import apps.TensorOrientationViewer;
import data.VoxelOrderDataSource;
import imaging.ImageHeader;
import imaging.Scheme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileFilter;
import misc.LoggedException;
import numerics.Vector3D;
import tools.CL_Initializer;

public abstract class PD_OrientationViewer
extends JPanel {
    private static Logger logger = Logger.getLogger("camino.apps.PD_OrientationViewer");
    private JFrame frame;
    private JPanel sliceSelectionPanel;
    private NavPanel navPanel;
    private SchemePanel schemePanel;
    private JList sliceList;
    private BufferedImage zoomedSlice;
    public static final int XY = 100;
    public static final int XZ = 200;
    public static final int YZ = 300;
    public static final int NO_FLIP = 0;
    public static final int FLIP_X = 1;
    public static final int FLIP_Y = 2;
    public static final int FLIP_Z = 3;
    private int[] flipDirs = new int[]{1, 1, 1};
    private int[] currentXYZ_Order = Scheme.gradXYZ;
    private boolean isFlippedDir = false;
    private boolean isSwappedDirs = false;
    protected boolean showVectors = true;
    protected int sliceOrientation = -1;
    protected int currentSliceIndex = 0;
    protected double[][][] scalarVol = null;
    protected double[][][] red = null;
    protected double[][][] green = null;
    protected double[][][] blue = null;
    protected Vector3D[][][][] vectors;
    protected int xSize;
    protected int ySize;
    protected int zSize;
    protected int preferredZoomedExtent = 30;
    protected double normScalarThresh;
    protected final RGB_ScalarImage image;
    protected final MouseWheelListener wheelListener;

    protected PD_OrientationViewer(RGB_ScalarImage rGB_ScalarImage, double d) {
        this.image = rGB_ScalarImage;
        this.vectors = rGB_ScalarImage.vectors;
        this.scalarVol = rGB_ScalarImage.scalarVol;
        this.normScalarThresh = d < rGB_ScalarImage.minScalarValue ? -1.0 : (d > rGB_ScalarImage.maxScalarValue ? 1.0 : (d - rGB_ScalarImage.minScalarValue) / (rGB_ScalarImage.maxScalarValue - rGB_ScalarImage.minScalarValue));
        this.xSize = this.image.xDataDim;
        this.ySize = this.image.yDataDim;
        this.zSize = this.image.zDataDim;
        this.sliceOrientation = 100;
        if (this.preferredZoomedExtent % 2 > 0) {
            --this.preferredZoomedExtent;
        }
        if (this.preferredZoomedExtent < 2) {
            this.preferredZoomedExtent = 2;
        }
        this.vectors = this.image.vectors;
        this.wheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = mouseWheelEvent.getWheelRotation();
                int n2 = PD_OrientationViewer.this.sliceList.getSelectedIndex() + n;
                int n3 = PD_OrientationViewer.this.sliceList.getModel().getSize() - 1;
                if (n2 < 0) {
                    n2 = 0;
                } else if (n2 > n3) {
                    n2 = n3;
                }
                PD_OrientationViewer.this.sliceList.setSelectedIndex(n2);
                PD_OrientationViewer.this.sliceList.ensureIndexIsVisible(n2);
            }
        };
        this.addMouseWheelListener(this.wheelListener);
        this.navPanel = new NavPanel(this);
        this.schemePanel = new SchemePanel(this);
    }

    protected String getText(int n, int n2) {
        double d;
        Dimension dimension = this.getSize();
        int[] nArray = this.navPanel.getZoomedRegion();
        double d2 = dimension.getWidth() / ((double)(nArray[1] - nArray[0]) + 1.0);
        if (d2 < (d = dimension.getHeight() / ((double)(nArray[3] - nArray[2]) + 1.0))) {
            d = d2;
        } else {
            d2 = d;
        }
        int n3 = 0;
        int n4 = 0;
        n3 = (int)((double)n / d2);
        n4 = (int)((dimension.getHeight() - (double)n2) / d);
        int n5 = nArray[0];
        int n6 = nArray[1];
        int n7 = nArray[2];
        int n8 = nArray[3];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        switch (this.sliceOrientation) {
            case 100: {
                n9 = n5 + n3;
                n10 = n7 + n4;
                n11 = this.currentSliceIndex;
                break;
            }
            case 200: {
                n9 = n5 + n3;
                n10 = this.currentSliceIndex;
                n11 = n7 + n4;
                break;
            }
            case 300: {
                n9 = this.currentSliceIndex;
                n10 = n5 + n3;
                n11 = n7 + n4;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised plane index " + this.sliceOrientation);
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        if (n9 < 0 || n9 >= this.xSize || n10 < 0 || n10 >= this.ySize || n11 < 0 || n11 >= this.zSize) {
            return "\n";
        }
        if (this.vectors[n9][n10][n11].length == 1) {
            return decimalFormat.format(this.vectors[n9][n10][n11][0].x) + " " + decimalFormat.format(this.vectors[n9][n10][n11][0].y) + " " + decimalFormat.format(this.vectors[n9][n10][n11][0].z) + " (" + decimalFormat.format(this.scalarVol[n9][n10][n11]) + ")\n";
        }
        if (this.vectors[n9][n10][n11].length >= 2) {
            return decimalFormat.format(this.vectors[n9][n10][n11][0].x) + " " + decimalFormat.format(this.vectors[n9][n10][n11][0].y) + " " + decimalFormat.format(this.vectors[n9][n10][n11][0].z) + " (" + decimalFormat.format(this.scalarVol[n9][n10][n11]) + ")\n" + decimalFormat.format(this.vectors[n9][n10][n11][1].x) + " " + decimalFormat.format(this.vectors[n9][n10][n11][1].y) + " " + decimalFormat.format(this.vectors[n9][n10][n11][1].z);
        }
        return "\n";
    }

    public void writeRGB() {
        Object object;
        String string = "";
        JFileChooser jFileChooser = new JFileChooser();
        FileFilter fileFilter = this.getFileFilter("Meta IO (*.mha)", "mha");
        FileFilter fileFilter2 = this.getFileFilter("VTK (*.vtk)", "vtk");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.addChoosableFileFilter(fileFilter2);
        jFileChooser.setFileFilter(fileFilter);
        try {
            object = new File(new File(".").getCanonicalPath());
            jFileChooser.setCurrentDirectory((File)object);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        object = null;
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            object = jFileChooser.getCurrentDirectory().toString().startsWith("/") ? jFileChooser.getCurrentDirectory() + "/" + jFileChooser.getSelectedFile().getName() : jFileChooser.getCurrentDirectory() + "\\" + jFileChooser.getSelectedFile().getName();
            try {
                FileFilter fileFilter3 = jFileChooser.getFileFilter();
                if (fileFilter3 == fileFilter) {
                    if (!((String)object).endsWith(".mha")) {
                        object = (String)object + ".mha";
                    }
                } else if (fileFilter3 == fileFilter2) {
                    if (!((String)object).endsWith(".vtk")) {
                        object = (String)object + ".vtk";
                    }
                } else {
                    throw new LoggedException("Unknown file filter");
                }
                this.image.writeImage((String)object);
            }
            catch (IOException iOException) {
                logger.warning("Could not write file (exception follows)");
                LoggedException.logExceptionWarning(iOException, Thread.currentThread().getName());
            }
        }
    }

    public void writeScheme() {
        Object object;
        CL_Initializer.initImagingScheme();
        Scheme scheme = CL_Initializer.imPars;
        scheme.gradOrder(this.currentXYZ_Order);
        if (this.flipDirs[0] == -1) {
            scheme.flipX();
        } else if (this.flipDirs[1] == -1) {
            scheme.flipY();
        } else if (this.flipDirs[2] == -1) {
            scheme.flipZ();
        }
        String string = "";
        JFileChooser jFileChooser = new JFileChooser();
        FileFilter fileFilter = this.getFileFilter("Scheme file (*.scheme)", "scheme");
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.setFileFilter(fileFilter);
        try {
            object = new File(new File(".").getCanonicalPath());
            jFileChooser.setCurrentDirectory((File)object);
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        object = null;
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            object = jFileChooser.getCurrentDirectory().toString().startsWith("/") ? jFileChooser.getCurrentDirectory() + "/" + jFileChooser.getSelectedFile().getName() : jFileChooser.getCurrentDirectory() + "\\" + jFileChooser.getSelectedFile().getName();
            try {
                FileFilter fileFilter2 = jFileChooser.getFileFilter();
                if (!jFileChooser.getSelectedFile().getName().contains(".")) {
                    object = (String)object + ".scheme";
                }
                FileWriter fileWriter = new FileWriter((String)object);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(scheme.toString());
                bufferedWriter.close();
                this.isFlippedDir = false;
                this.isSwappedDirs = false;
                this.flipDirs[0] = 1;
                this.flipDirs[1] = 1;
                this.flipDirs[2] = 1;
                this.currentXYZ_Order = Scheme.gradXYZ;
                this.schemePanel.resetButtons();
                CL_Initializer.schemeFile = object;
                CL_Initializer.initImagingScheme();
                logger.info("Saved scheme file (Note that pds/dt eigs have not been updated.  You must recalculate these using the updated schemefile).");
            }
            catch (IOException iOException) {
                logger.warning("Could not write file (exception follows)");
                LoggedException.logExceptionWarning(iOException, Thread.currentThread().getName());
            }
        }
    }

    private FileFilter getFileFilter(final String string, final String string2) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith("." + string2) || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return string;
            }
        };
    }

    protected void display() {
        this.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                PD_OrientationViewer.this.navPanel.setText(PD_OrientationViewer.this.getText(n, n2));
            }
        });
        this.navPanel.resetZoomPosition();
        this.frame = new JFrame("PD Orientation Viewer");
        this.frame.setDefaultCloseOperation(3);
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (PD_OrientationViewer.this.isFlippedDir || PD_OrientationViewer.this.isSwappedDirs) {
                    Object[] objectArray = new Object[]{"Yes", "No"};
                    int n = JOptionPane.showOptionDialog(PD_OrientationViewer.this.frame, "Schemefile has not been saved.  Save now?", "Save scheme file?", 0, 3, null, objectArray, objectArray[0]);
                    if (n == 0) {
                        PD_OrientationViewer.this.writeScheme();
                    }
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            public void windowLostFocus(WindowEvent windowEvent) {
            }

            public void windowStateChanged(WindowEvent windowEvent) {
            }
        });
        this.sliceOrientation = 100;
        this.initSliceSelectionPanel();
        this.navPanel.setSlice();
        this.setZoomedSlice();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (CL_Initializer.schemeFile != null) {
            jPanel.add(this.schemePanel);
        }
        jPanel.add(this.navPanel);
        this.frame.getContentPane().add((Component)this, "Center");
        this.frame.getContentPane().add((Component)this.sliceSelectionPanel, "East");
        this.frame.getContentPane().add((Component)jPanel, "North");
        this.frame.pack();
        this.frame.setSize(700, 700);
        this.frame.setVisible(true);
    }

    public void updateDisplay() {
        this.navPanel.setSlice();
        this.setZoomedSlice();
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        CL_Initializer.inputDataType = "double";
        CL_Initializer.maxTensorComponents = 1;
        CL_Initializer.numPDsIO = -1;
        CL_Initializer.inputModel = "dteig";
        CL_Initializer.CL_init(stringArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        String string = null;
        boolean bl = true;
        String string2 = "bingham";
        int n5 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-scalarthresh")) {
                d4 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-scalarrange")) {
                d5 = Double.parseDouble(stringArray[i + 1]);
                d6 = Double.parseDouble(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i, 3);
            }
            if (stringArray[i].equals("-scalarfile")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-norgb")) {
                bl = false;
                CL_Initializer.markAsParsed(i);
            }
            if (stringArray[i].equals("-e1")) {
                n5 = 0;
                CL_Initializer.markAsParsed(i);
            }
            if (stringArray[i].equals("-e2")) {
                n5 = 1;
                CL_Initializer.markAsParsed(i);
            }
            if (stringArray[i].equals("-e3")) {
                n5 = 2;
                CL_Initializer.markAsParsed(i);
            }
            if (!stringArray[i].equals("-pdf")) continue;
            string2 = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        if (CL_Initializer.maxTensorComponents > 2 && CL_Initializer.inputModel.equals("dteig") || CL_Initializer.numPDsIO > 2) {
            logger.info("This program displays a maximum of 2 PDs per voxel. Display shows the first two PDs in each voxel.");
        }
        if (CL_Initializer.numPDsIO < 0) {
            CL_Initializer.numPDsIO = CL_Initializer.inputModel.equals("pds") ? 3 : 1;
        }
        n2 = CL_Initializer.dataDims[0];
        n3 = CL_Initializer.dataDims[1];
        n4 = CL_Initializer.dataDims[2];
        d = CL_Initializer.voxelDims[0];
        d2 = CL_Initializer.voxelDims[1];
        d3 = CL_Initializer.voxelDims[2];
        double[][][] dArray = null;
        if (string != null) {
            object = null;
            if (ImageHeader.imageExists(string)) {
                ImageHeader imageHeader = null;
                try {
                    imageHeader = ImageHeader.readHeader(string);
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
                int[] nArray = new int[3];
                double[] dArray2 = new double[3];
                ImageHeader.checkDims(string, nArray, dArray2);
                n2 = nArray[0];
                n3 = nArray[1];
                n4 = nArray[2];
                d = Math.abs(dArray2[0]);
                d2 = Math.abs(dArray2[1]);
                d3 = Math.abs(dArray2[2]);
                object = imageHeader.getImageDataSource();
            } else {
                object = new VoxelOrderDataSource(string, 1, CL_Initializer.inputDataType);
            }
            dArray = new double[n2][n3][n2];
            for (n = 0; n < n4; ++n) {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        dArray[j][i][n] = object.nextVoxel()[0];
                    }
                }
            }
        }
        object = null;
        if (CL_Initializer.inputModel.equals("dteig")) {
            if (n2 <= 0 || n3 <= 0 || n4 <= 0) {
                throw new LoggedException("Cannot create image without data dimensions");
            }
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 12 * CL_Initializer.maxTensorComponents, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromTensorEigenSys(voxelOrderDataSource, new int[]{n2, n3, n4}, new double[]{d, d2, d3}, dArray, d5, d6, n5);
        } else if (CL_Initializer.inputModel.equals("pds")) {
            if (n2 <= 0 || n3 <= 0 || n4 <= 0) {
                throw new LoggedException("Cannot create image without data dimensions");
            }
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 6 + 8 * CL_Initializer.numPDsIO, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromSphFuncPDs(voxelOrderDataSource, new int[]{n2, n3, n4}, new double[]{d, d2, d3}, dArray, d5, d6);
        } else if (CL_Initializer.inputModel.equals("pico")) {
            if (n2 <= 0 || n3 <= 0 || n4 <= 0) {
                throw new LoggedException("Cannot create image without data dimensions");
            }
            n = 1;
            if (string2.equals("bingham")) {
                n = 2;
            }
            if (string2.equals("acg")) {
                n = 3;
            }
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 1 + (10 + n) * CL_Initializer.numPDsIO, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromPICoPDFs(voxelOrderDataSource, CL_Initializer.numPDsIO, n, new int[]{n2, n3, n4}, new double[]{d, d2, d3}, dArray, d5, d6, n5);
        } else if (CL_Initializer.inputModel.equals("ballstick")) {
            if (n2 <= 0 || n3 <= 0 || n4 <= 0) {
                throw new LoggedException("Cannot create image without data dimensions");
            }
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 7, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromBallStick(voxelOrderDataSource, new int[]{n2, n3, n4}, new double[]{d, d2, d3}, dArray, d5, d6);
        } else {
            throw new LoggedException("Unrecognized input model " + CL_Initializer.inputModel);
        }
        if (bl) {
            ((RGB_ScalarImage)object).setRGB_Gamma(1.0);
        } else {
            ((RGB_ScalarImage)object).setRGB_Gamma(0.0);
        }
        if (CL_Initializer.inputModel.equals("dteig")) {
            TensorOrientationViewer tensorOrientationViewer = new TensorOrientationViewer((RGB_ScalarImage)object, d4);
        } else if (CL_Initializer.inputModel.equals("pds")) {
            SphFuncPeaksOrientationViewer sphFuncPeaksOrientationViewer = new SphFuncPeaksOrientationViewer((RGB_ScalarImage)object, d4);
        } else if (CL_Initializer.inputModel.equals("pico")) {
            PICoPDF_OrientationViewer pICoPDF_OrientationViewer = new PICoPDF_OrientationViewer((RGB_ScalarImage)object, d4);
        } else if (CL_Initializer.inputModel.equals("ballstick")) {
            BallSticksOrientationViewer ballSticksOrientationViewer = new BallSticksOrientationViewer((RGB_ScalarImage)object, d4);
        }
    }

    public void setSliceOrientation(int n) {
        this.sliceOrientation = n;
        this.navPanel.resetZoomPosition();
        this.setSliceListModel();
        this.repaint();
    }

    public void swapDirs(int[] nArray) {
        this.isSwappedDirs = nArray != Scheme.gradXYZ;
        if (this.currentXYZ_Order != Scheme.gradXYZ) {
            this.revertGrads(this.currentXYZ_Order);
        }
        this.reorderGrads(nArray);
        this.currentXYZ_Order = nArray;
        if (this.flipDirs[0] == -1) {
            this.schemePanel.updateFlipButtons(1);
        } else if (this.flipDirs[1] == -1) {
            this.schemePanel.updateFlipButtons(2);
        } else if (this.flipDirs[2] == -1) {
            this.schemePanel.updateFlipButtons(3);
        }
        this.image.calculateRGB();
        this.setSliceListModel();
        this.updateDisplay();
        this.repaint();
    }

    private void reorderGrads(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        double[] dArray = new double[3];
        for (n3 = 0; n3 < this.image.xDataDim; ++n3) {
            for (n2 = 0; n2 < this.image.yDataDim; ++n2) {
                for (n = 0; n < this.image.zDataDim; ++n) {
                    n4 = this.image.vectors[n3][n2][n].length;
                    for (int i = 0; i < n4; ++i) {
                        dArray[0] = this.image.vectors[n3][n2][n][i].x;
                        dArray[1] = this.image.vectors[n3][n2][n][i].y;
                        dArray[2] = this.image.vectors[n3][n2][n][i].z;
                        this.image.vectors[n3][n2][n][i] = new Vector3D(dArray[nArray[0]], dArray[nArray[1]], dArray[nArray[2]]);
                    }
                }
            }
        }
        n3 = this.flipDirs[0];
        n2 = this.flipDirs[1];
        n = this.flipDirs[2];
        this.flipDirs[nArray[0]] = n3;
        this.flipDirs[nArray[1]] = n2;
        this.flipDirs[nArray[2]] = n;
    }

    private void revertGrads(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        double[] dArray = new double[3];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int[] nArray2 = new int[3];
        for (n3 = 0; n3 < 3; ++n3) {
            if (nArray[n3] == 0) {
                nArray2[0] = n3;
                continue;
            }
            if (nArray[n3] == 1) {
                nArray2[1] = n3;
                continue;
            }
            if (nArray[n3] != 2) continue;
            nArray2[2] = n3;
        }
        for (n3 = 0; n3 < this.image.xDataDim; ++n3) {
            for (n2 = 0; n2 < this.image.yDataDim; ++n2) {
                for (n = 0; n < this.image.zDataDim; ++n) {
                    n4 = this.image.vectors[n3][n2][n].length;
                    for (int i = 0; i < n4; ++i) {
                        dArray[0] = this.image.vectors[n3][n2][n][i].x;
                        dArray[1] = this.image.vectors[n3][n2][n][i].y;
                        dArray[2] = this.image.vectors[n3][n2][n][i].z;
                        this.image.vectors[n3][n2][n][i] = new Vector3D(dArray[nArray2[0]], dArray[nArray2[1]], dArray[nArray2[2]]);
                    }
                }
            }
        }
        n3 = 0;
        n2 = 0;
        n = 0;
        n3 = this.flipDirs[nArray[0]];
        n2 = this.flipDirs[nArray[1]];
        n = this.flipDirs[nArray[2]];
        this.flipDirs[0] = n3;
        this.flipDirs[1] = n2;
        this.flipDirs[2] = n;
    }

    public void setFlip(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                this.flipDirs[0] = -1 * this.flipDirs[0];
                this.isFlippedDir = true;
                break;
            }
            case 2: {
                this.flipDirs[1] = -1 * this.flipDirs[1];
                this.isFlippedDir = true;
                break;
            }
            case 3: {
                this.flipDirs[2] = -1 * this.flipDirs[2];
                this.isFlippedDir = true;
                break;
            }
            case 0: {
                this.isFlippedDir = false;
            }
        }
        for (int i = 0; i < this.image.xDataDim; ++i) {
            for (int j = 0; j < this.image.yDataDim; ++j) {
                for (int k = 0; k < this.image.zDataDim; ++k) {
                    n2 = this.image.vectors[i][j][k].length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        double d = (double)this.flipDirs[0] * this.image.vectors[i][j][k][i2].x;
                        double d2 = (double)this.flipDirs[1] * this.image.vectors[i][j][k][i2].y;
                        double d3 = (double)this.flipDirs[2] * this.image.vectors[i][j][k][i2].z;
                        this.image.vectors[i][j][k][i2] = new Vector3D(d, d2, d3);
                    }
                }
            }
        }
        this.flipDirs[0] = 1;
        this.flipDirs[1] = 1;
        this.flipDirs[2] = 1;
        switch (n) {
            case 1: {
                this.flipDirs[0] = -1 * this.flipDirs[0];
                break;
            }
            case 2: {
                this.flipDirs[1] = -1 * this.flipDirs[1];
                break;
            }
            case 3: {
                this.flipDirs[2] = -1 * this.flipDirs[2];
                break;
            }
        }
        this.image.calculateRGB();
        this.repaint();
    }

    private void initSliceSelectionPanel() {
        this.sliceList = new JList();
        this.sliceSelectionPanel = new JPanel(new BorderLayout());
        this.setSliceListModel();
        this.currentSliceIndex = this.sliceList.getSelectedIndex();
        this.sliceList.setBackground(Color.white);
        this.sliceList.setFixedCellWidth(22);
        this.sliceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (PD_OrientationViewer.this.sliceList.getSelectedIndex() > -1) {
                    PD_OrientationViewer.this.currentSliceIndex = PD_OrientationViewer.this.sliceList.getSelectedIndex();
                    PD_OrientationViewer.this.navPanel.setSlice();
                    PD_OrientationViewer.this.setZoomedSlice();
                }
            }
        });
        this.sliceList.setSelectionMode(0);
        this.sliceList.setPrototypeCellValue("10000");
        JScrollPane jScrollPane = new JScrollPane(this.sliceList);
        this.sliceSelectionPanel.add(jScrollPane);
    }

    protected void setSliceListModel() {
        DefaultListModel<Integer> defaultListModel = new DefaultListModel<Integer>();
        int n = 0;
        switch (this.sliceOrientation) {
            case 100: {
                n = this.zSize;
                break;
            }
            case 200: {
                n = this.ySize;
                break;
            }
            case 300: {
                n = this.xSize;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised plane index " + this.sliceOrientation);
            }
        }
        for (int i = 0; i < n; ++i) {
            defaultListModel.addElement(new Integer(i));
        }
        this.sliceList.setModel(defaultListModel);
        this.sliceList.setSelectedIndex(n / 2);
        this.sliceList.ensureIndexIsVisible(n / 2);
    }

    public void setZoomedSlice() {
        int n = this.currentSliceIndex;
        int[] nArray = this.navPanel.getZoomedRegion();
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = n3 - n2 + 1;
        int n7 = n5 - n4 + 1;
        this.zoomedSlice = new BufferedImage(n6, n7, 1);
        switch (this.sliceOrientation) {
            case 100: {
                for (int i = 0; i < n6; ++i) {
                    for (int j = 0; j < n7; ++j) {
                        this.zoomedSlice.setRGB(i, n7 - j - 1, this.image.rgbIndex(n2 + i, n4 + j, n));
                    }
                }
                break;
            }
            case 200: {
                for (int i = 0; i < n6; ++i) {
                    for (int j = 0; j < n7; ++j) {
                        this.zoomedSlice.setRGB(i, n7 - j - 1, this.image.rgbIndex(n2 + i, n, n4 + j));
                    }
                }
                break;
            }
            case 300: {
                for (int i = 0; i < n6; ++i) {
                    for (int j = 0; j < n7; ++j) {
                        this.zoomedSlice.setRGB(i, n7 - j - 1, this.image.rgbIndex(n, n2 + i, n4 + j));
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised plane index " + this.sliceOrientation);
            }
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        double d = dimension.getWidth() / (double)this.zoomedSlice.getWidth();
        double d2 = dimension.getHeight() / (double)this.zoomedSlice.getHeight();
        if (d < d2) {
            d2 = d;
        } else {
            d = d2;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.scale(d, d2);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.drawImage((Image)this.zoomedSlice, 0, 0, this);
        graphics2D.scale(1.0 / d, 1.0 / d2);
        double d3 = d;
        int[] nArray = this.navPanel.getZoomedRegion();
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        if (this.showVectors) {
            Color color = Color.red;
            Color color2 = Color.blue;
            if (this.image.rgbGamma() > 0.0) {
                color = Color.white;
                color2 = Color.white;
            }
            graphics2D.setColor(color);
            int n5 = n2 - n + 1;
            int n6 = n4 - n3 + 1;
            for (int i = 0; i < n5; ++i) {
                block6: for (int j = 0; j < n6; ++j) {
                    int n7 = (int)(d3 / 2.0 + (double)i * d3);
                    int n8 = (int)(d3 / 2.0 + (double)j * d3);
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    double d4 = d3;
                    Vector3D vector3D = null;
                    switch (this.sliceOrientation) {
                        case 100: {
                            if (!(this.image.normScalarVol[i + n][n4 - j][this.currentSliceIndex] > this.normScalarThresh)) continue block6;
                            vector3D = this.vectors[i + n][n4 - j][this.currentSliceIndex][0];
                            n9 = n7 - (int)(d4 * vector3D.x / 2.0);
                            n10 = n8 + (int)(d4 * vector3D.y / 2.0);
                            n11 = n7 + (int)(d4 * vector3D.x / 2.0);
                            n12 = n8 - (int)(d4 * vector3D.y / 2.0);
                            graphics2D.drawLine(n9, n10, n11, n12);
                            if (this.vectors[i + n][n4 - j][this.currentSliceIndex].length != 2 || !((vector3D = this.vectors[i + n][n4 - j][this.currentSliceIndex][1]).mod() > 0.0)) continue block6;
                            graphics2D.setColor(color2);
                            n9 = n7 - (int)(d4 * vector3D.x / 2.0);
                            n10 = n8 + (int)(d4 * vector3D.y / 2.0);
                            n11 = n7 + (int)(d4 * vector3D.x / 2.0);
                            n12 = n8 - (int)(d4 * vector3D.y / 2.0);
                            graphics2D.drawLine(n9, n10, n11, n12);
                            graphics2D.setColor(color);
                            continue block6;
                        }
                        case 200: {
                            if (!(this.image.normScalarVol[i + n][this.currentSliceIndex][n4 - j] > this.normScalarThresh)) continue block6;
                            vector3D = this.vectors[i + n][this.currentSliceIndex][n4 - j][0];
                            n9 = n7 - (int)(d4 * vector3D.x / 2.0);
                            n10 = n8 + (int)(d4 * vector3D.z / 2.0);
                            n11 = n7 + (int)(d4 * vector3D.x / 2.0);
                            n12 = n8 - (int)(d4 * vector3D.z / 2.0);
                            graphics2D.drawLine(n9, n10, n11, n12);
                            if (this.vectors[i + n][this.currentSliceIndex][n4 - j].length != 2 || !((vector3D = this.vectors[i + n][this.currentSliceIndex][n4 - j][1]).mod() > 0.0)) continue block6;
                            graphics2D.setColor(color2);
                            n9 = n7 - (int)(d4 * vector3D.x / 2.0);
                            n10 = n8 + (int)(d4 * vector3D.z / 2.0);
                            n11 = n7 + (int)(d4 * vector3D.x / 2.0);
                            n12 = n8 - (int)(d4 * vector3D.z / 2.0);
                            graphics2D.drawLine(n9, n10, n11, n12);
                            graphics2D.setColor(color);
                            continue block6;
                        }
                        case 300: {
                            if (!(this.image.normScalarVol[this.currentSliceIndex][i + n][n4 - j] > this.normScalarThresh)) continue block6;
                            vector3D = this.vectors[this.currentSliceIndex][i + n][n4 - j][0];
                            n9 = n7 - (int)(d4 * vector3D.y / 2.0);
                            n10 = n8 + (int)(d4 * vector3D.z / 2.0);
                            n11 = n7 + (int)(d4 * vector3D.y / 2.0);
                            n12 = n8 - (int)(d4 * vector3D.z / 2.0);
                            graphics2D.drawLine(n9, n10, n11, n12);
                            if (this.vectors[this.currentSliceIndex][i + n][n4 - j].length != 2 || !((vector3D = this.vectors[this.currentSliceIndex][i + n][n4 - j][1]).mod() > 0.0)) continue block6;
                            graphics2D.setColor(color2);
                            n9 = n7 - (int)(d4 * vector3D.y / 2.0);
                            n10 = n8 + (int)(d4 * vector3D.z / 2.0);
                            n11 = n7 + (int)(d4 * vector3D.y / 2.0);
                            n12 = n8 - (int)(d4 * vector3D.z / 2.0);
                            graphics2D.drawLine(n9, n10, n11, n12);
                            graphics2D.setColor(color);
                            continue block6;
                        }
                        default: {
                            throw new IllegalStateException("Unrecognised plane index " + this.sliceOrientation);
                        }
                    }
                }
            }
        }
    }
}

