/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.PointSetToScheme;
import data.OutputManager;
import java.io.IOException;
import java.util.Random;
import misc.LoggedException;
import misc.OrderedAcqMinimizer;
import misc.OrderedAcqWeightedMinimizer;
import optimizers.SimulatedAnnealingOptimizer;
import tools.CL_Initializer;
import tools.FileInput;
import tools.FileOutput;

public class OrderElectrostaticPoints {
    public static void main(String[] stringArray) {
        String[] stringArray2;
        Object object;
        CL_Initializer.CL_init(stringArray);
        int n = 0;
        long l = System.currentTimeMillis();
        double d = -1.0;
        double d2 = 1.0E-7;
        int n2 = 1000;
        boolean bl = false;
        boolean bl2 = false;
        double[][] dArray = null;
        String string = "OrderElectrostaticPoints";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-numpoints")) {
                n = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-seed")) {
                l = Long.parseLong(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-coolingfactor")) {
                d2 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-trialsbetweencooling")) {
                n2 = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-temperature")) {
                d = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-savestate")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-resume")) {
                bl = true;
                object = new FileInput(stringArray[i + 1]);
                stringArray2 = ((FileInput)object).readString().split("\\s");
                n = Integer.parseInt(stringArray2[0]);
                if (d == -1.0) {
                    d = Double.parseDouble(stringArray2[1]);
                }
                dArray = new double[n][3];
                for (int j = 0; j < n; ++j) {
                    String[] stringArray3 = ((FileInput)object).readString().split("\\s");
                    dArray[j][0] = Double.parseDouble(stringArray3[0]);
                    dArray[j][1] = Double.parseDouble(stringArray3[1]);
                    dArray[j][2] = Double.parseDouble(stringArray3[2]);
                }
                ((FileInput)object).close();
                CL_Initializer.markAsParsed(i, 2);
            }
            if (!stringArray[i].equals("-randominit")) continue;
            bl2 = true;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
        if (n == 0) {
            bl = true;
            try {
                dArray = PointSetToScheme.normalizePoints(PointSetToScheme.readPoints(CL_Initializer.inputFile));
                n = dArray.length;
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        Random random = new Random(l);
        object = null;
        if (bl) {
            object = new OrderedAcqWeightedMinimizer(dArray, d2, n2, string, random);
            if (bl2) {
                ((OrderedAcqMinimizer)object).initializeRandom();
            }
        } else {
            object = new OrderedAcqWeightedMinimizer(n, d2, n2, string, random);
        }
        if (d < 0.0) {
            ((SimulatedAnnealingOptimizer)object).setTemperature(((SimulatedAnnealingOptimizer)object).calibratedTemp(0.7));
        } else {
            ((SimulatedAnnealingOptimizer)object).setTemperature(d);
        }
        ((SimulatedAnnealingOptimizer)object).minimize();
        if (OutputManager.outputFile == null) {
            System.out.print(((OrderedAcqWeightedMinimizer)object).lowestEnergyState());
        } else {
            stringArray2 = new FileOutput(OutputManager.outputFile);
            stringArray2.writeString(((OrderedAcqWeightedMinimizer)object).lowestEnergyState());
            stringArray2.close();
        }
    }
}

