/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.InversionStats;
import inverters.ModelIndex;
import java.util.Arrays;
import numerics.RealMatrix;
import tools.CL_Initializer;

public class MultiFibreReconStats
extends InversionStats {
    public static void main(String[] stringArray) {
        MultiFibreReconStats multiFibreReconStats = new MultiFibreReconStats(stringArray);
    }

    protected MultiFibreReconStats(String[] stringArray) {
        super(stringArray);
    }

    @Override
    protected boolean successfulInversion(double[] dArray, int n) {
        return (int)dArray[3] == 1 && dArray[2] >= (double)n;
    }

    @Override
    protected int getNumParams(ModelIndex modelIndex) {
        return 6 + 8 * CL_Initializer.numPDsIO;
    }

    @Override
    protected int getNumProperties(ModelIndex modelIndex) {
        return this.getNumParams(modelIndex);
    }

    @Override
    protected double[] getProperties(double[] dArray, ModelIndex modelIndex) {
        return dArray;
    }

    @Override
    protected double[] computeStats(double[][] dArray, ModelIndex modelIndex) {
        int n = 6;
        int n2 = 8;
        this.orderComponentsByDirection(dArray, CL_Initializer.numPDsIO, n2, n);
        this.orderPeaksByMeanStrength(dArray, CL_Initializer.numPDsIO, n2, n);
        double[] dArray2 = MultiFibreReconStats.meanSTDMaxAndMin(dArray, 4);
        double[] dArray3 = MultiFibreReconStats.meanSTDMaxAndMin(dArray, 5);
        double[] dArray4 = new double[4 + CL_Initializer.numPDsIO * 12];
        dArray4[0] = dArray2[0];
        dArray4[1] = dArray2[1];
        dArray4[2] = dArray3[0];
        dArray4[3] = dArray3[1];
        for (int i = 0; i < CL_Initializer.numPDsIO; ++i) {
            int n3 = i * n2 + n;
            double[] dArray5 = MultiFibreReconStats.oneDirectionStats(dArray, n3);
            for (int j = 0; j < dArray5.length; ++j) {
                dArray4[4 + i * 12 + j] = dArray5[j];
            }
            double[] dArray6 = MultiFibreReconStats.meanSTDMaxAndMin(dArray, n + i * n2 + 3);
            double[][] dArray7 = this.getHessianEigenVals(dArray, n + i * n2 + 4);
            double[] dArray8 = MultiFibreReconStats.meanSTDMaxAndMin(dArray7, 0);
            double[] dArray9 = MultiFibreReconStats.meanSTDMaxAndMin(dArray7, 1);
            dArray4[4 + i * 12 + 6] = dArray6[0];
            dArray4[4 + i * 12 + 6 + 1] = dArray6[1];
            dArray4[4 + i * 12 + 6 + 2] = dArray8[0];
            dArray4[4 + i * 12 + 6 + 3] = dArray8[1];
            dArray4[4 + i * 12 + 6 + 4] = dArray9[0];
            dArray4[4 + i * 12 + 6 + 5] = dArray9[1];
        }
        return dArray4;
    }

    public void orderPeaksByMeanStrength(double[][] dArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (dArray.length == 0) {
            return;
        }
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            n5 = i * n2 + n3 + 3;
            for (n4 = 0; n4 < dArray.length; ++n4) {
                int n6 = i;
                dArray2[n6] = dArray2[n6] + dArray[n4][n5];
            }
            int n7 = i;
            dArray2[n7] = dArray2[n7] / (double)dArray.length;
            dArray3[i] = dArray2[i];
        }
        Arrays.sort(dArray3);
        double[][] dArray4 = new double[dArray.length][dArray[0].length];
        for (n5 = 0; n5 < dArray.length; ++n5) {
            for (n4 = 0; n4 < dArray[0].length; ++n4) {
                dArray4[n5][n4] = dArray[n5][n4];
            }
        }
        for (n5 = 0; n5 < n; ++n5) {
            int n8;
            n4 = 0;
            for (n8 = 0; n8 < n; ++n8) {
                if (dArray2[n8] != dArray3[n - n5 - 1]) continue;
                n4 = n8;
            }
            if (n4 == n5) continue;
            for (n8 = 0; n8 < dArray.length; ++n8) {
                for (int i = 0; i < n2; ++i) {
                    dArray[n8][n5 * n2 + n3 + i] = dArray4[n8][n4 * n2 + n3 + i];
                }
            }
        }
    }

    public double[][] getHessianEigenVals(double[][] dArray, int n) {
        double[][] dArray2 = new double[dArray.length][2];
        for (int i = 0; i < dArray.length; ++i) {
            RealMatrix realMatrix = new RealMatrix(2, 2);
            realMatrix.entries[0][0] = dArray[i][n];
            realMatrix.entries[0][1] = dArray[i][n + 1];
            realMatrix.entries[1][0] = dArray[i][n + 2];
            realMatrix.entries[1][1] = dArray[i][n + 3];
            RealMatrix[] realMatrixArray = realMatrix.jacobi();
            dArray2[i][0] = realMatrixArray[0].entries[0][0];
            dArray2[i][1] = realMatrixArray[0].entries[1][1];
        }
        return dArray2;
    }
}

