/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import data.VoxelOrderDataSource;
import java.io.DataOutputStream;
import java.util.logging.Logger;
import numerics.SphericalHarmonics;
import tools.CL_Initializer;

public class ImportSH_Coeffs {
    private static Logger logger = Logger.getLogger("camino.apps.ImportSH_Coeffs");
    private static int maxOrder = 8;
    private static String inputDataType = "float";
    private static String outputDataType = "double";
    private static String inputFile = null;
    private static DataOutputStream out = new DataOutputStream(System.out);
    private static final int TOURNIER = 1;
    private static int coeffSource = 1;
    private static OutputManager om;

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-source")) continue;
            if (stringArray[i + 1].equalsIgnoreCase("tournier")) {
                coeffSource = 1;
            } else {
                logger.warning("-source value: " + stringArray[i + 1] + " not recognized.  Defaulting to \"tournier\" conversion");
                coeffSource = 1;
            }
            CL_Initializer.markAsParsed(i, 2);
        }
        maxOrder = CL_Initializer.maxOrder;
        inputDataType = CL_Initializer.inputDataType;
        om = new OutputManager();
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(inputFile, SphericalHarmonics.evenFuncsUpTo(maxOrder), inputDataType);
        if (coeffSource == 1) {
            ImportSH_Coeffs.tournierConversion(voxelOrderDataSource);
        }
        om.close();
    }

    private static void tournierConversion(VoxelOrderDataSource voxelOrderDataSource) {
        while (voxelOrderDataSource.more()) {
            try {
                double[] dArray = voxelOrderDataSource.nextVoxel();
                double[] dArray2 = new double[dArray.length + 2];
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                int n = 2;
                for (int i = 0; i <= maxOrder; i += 2) {
                    dArray2[n] = dArray[n - 2 + i];
                    for (int j = 1; j <= i; ++j) {
                        dArray2[n + 2 * j - 1] = dArray[n - 2 + i + j];
                        dArray2[n + 2 * j] = -dArray[n - 2 + i - j];
                    }
                    n += 2 * i + 1;
                }
                om.output(dArray2);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }
}

