/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.DataSource;
import data.ExternalDataSource;
import data.OutputManager;
import imaging.ImageHeader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class ImageToVoxel {
    private static Logger logger = Logger.getLogger("camino.apps.ImageToVoxel");
    private static OutputManager om;

    public static void main(String[] stringArray) {
        int n;
        CL_Initializer.inputDataType = "float";
        OutputManager.outputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        om = new OutputManager();
        String string = null;
        String string2 = null;
        String string3 = "";
        boolean bl = false;
        if (CL_Initializer.inputFile != null) {
            if (ImageHeader.imageExists(CL_Initializer.inputFile)) {
                string = CL_Initializer.inputFile;
            } else {
                string2 = CL_Initializer.inputFile;
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-4dimage") || stringArray[n].equals("-4dimageroot")) {
                string = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-imagelist")) {
                string2 = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-imageprefix")) {
                string3 = stringArray[n + 1];
                CL_Initializer.markAsParsed(n, 2);
                bl = true;
            }
            if (!stringArray[n].equals("-ignorespmscale")) continue;
            logger.warning("Option -ignorespmscale is deprecated. Scaling is applied. Modify the header to alter scaling");
            CL_Initializer.markAsParsed(n);
        }
        CL_Initializer.checkParsing(stringArray);
        if (string != null) {
            ImageHeader imageHeader = null;
            try {
                imageHeader = ImageHeader.readHeader(string);
            }
            catch (IOException iOException) {
                throw new LoggedException("Cannot read image matching " + string);
            }
            DataSource dataSource = imageHeader.getImageDataSource();
            while (dataSource.more()) {
                om.output(dataSource.nextVoxel());
            }
            om.close();
        } else {
            String string4;
            int n2;
            if (!bl && (n2 = string2.lastIndexOf(string4 = File.separator)) > -1) {
                string3 = string2.substring(0, n2 + 1);
            }
            ExternalDataSource.FILEBUFFERSIZE = n = 0x400000;
            ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
            DataSource[] dataSourceArray = null;
            int n3 = 0;
            try {
                Object object;
                Scanner scanner = new Scanner(new File(string2));
                scanner.useDelimiter("\r\n|\n");
                while (scanner.hasNext()) {
                    object = string3.concat(scanner.next().trim());
                    arrayList.add(ImageHeader.readHeader((String)object).getImageDataSource());
                    ++n3;
                }
                scanner.close();
                dataSourceArray = new DataSource[n3];
                arrayList.toArray(dataSourceArray);
                while (dataSourceArray[0].more()) {
                    object = new double[n3];
                    for (int i = 0; i < n3; ++i) {
                        object[i] = dataSourceArray[i].nextVoxel()[0];
                    }
                    om.output((double[])object);
                }
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        om.close();
    }
}

