/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import imaging.Scheme;
import inverters.ModelIndex;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import misc.LoggedException;
import numerics.MTRandom;
import tools.CL_Initializer;
import tractography.DT_LookupTableGenerator;
import tractography.OneTensorLUTGenerator;
import tractography.TwoTensorLUTGenerator;

public final class GenerateDTLUT {
    public static void main(String[] stringArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 2000;
        long l = System.currentTimeMillis();
        double d4 = 0.5;
        double d5 = 0.0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (stringArray.length == 0) {
            System.exit(0);
        }
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.initImagingScheme();
        double d6 = CL_Initializer.SNR;
        if (d6 == -1.0) {
            throw new LoggedException("Cannot generate LUT without valid SNR");
        }
        double d7 = 2.0999999999999998E-9;
        ModelIndex modelIndex = CL_Initializer.inversionIndices[0];
        Scheme scheme = CL_Initializer.imPars;
        String string = "";
        boolean bl5 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-lrange")) {
                d = Double.parseDouble(stringArray[i + 1]);
                d2 = Double.parseDouble(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i, 3);
                continue;
            }
            if (stringArray[i].equals("-frange")) {
                d = Double.parseDouble(stringArray[i + 1]);
                d2 = Double.parseDouble(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i, 3);
                continue;
            }
            if (stringArray[i].equals("-step")) {
                d3 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-trace")) {
                d7 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-seed")) {
                l = Long.parseLong(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-samples")) {
                n = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-watson")) {
                bl = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-bingham")) {
                bl2 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-acg")) {
                bl3 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-prop")) {
                d4 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-cross")) {
                d5 = Math.PI / 180 * Double.parseDouble(stringArray[i + 1]);
                n2 = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (!stringArray[i].equals("-outputroot")) continue;
            string = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        if (d5 > 0.0 || modelIndex.numDTs == 2) {
            bl4 = true;
            if (d5 == 0.0) {
                throw new LoggedException("Attempting to create two-tensor LUT with zero degree crossing angle");
            }
            if (modelIndex.numDTs < 2) {
                throw new LoggedException("Attempting to create two-tensor LUT with single tensor inversion.");
            }
        }
        if (d == 0.0 && d2 == 0.0) {
            if (bl4) {
                d = 0.3;
                d2 = 0.94;
            } else {
                d = 1.0;
                d2 = 10.0;
            }
        }
        if (d3 == 0.0) {
            d3 = d2 < 1.0 ? 0.02 : 0.2;
        }
        if (d2 < 1.0 && modelIndex.numDTs == 1) {
            bl5 = false;
        }
        if (!(bl || bl2 || bl3)) {
            bl2 = true;
        }
        if ((d - d2) / d3 - (double)((int)((d - d2) / d3)) > 1.0E-8) {
            throw new LoggedException("LUT range must divide into a whole number of steps");
        }
        if (d > d2) {
            throw new LoggedException("Illegal range specified: max < min");
        }
        if (bl4) {
            if (d < 0.0 || d2 > 1.0) {
                throw new LoggedException("FA range must be between 0 and 1");
            }
        } else if (!bl5) {
            if (d < 0.0 || d2 > 1.0) {
                throw new LoggedException("FA range must be between 0 and 1");
            }
        } else if (d < 1.0) {
            throw new LoggedException("min(L1 / L3) must not be less than 1");
        }
        MTRandom mTRandom = new MTRandom(l);
        DT_LookupTableGenerator dT_LookupTableGenerator = null;
        dT_LookupTableGenerator = bl4 ? new TwoTensorLUTGenerator(scheme, d6, d7, d4, d5, mTRandom) : new OneTensorLUTGenerator(scheme, d6, d7, mTRandom);
        double[][][][] dArray = ((DT_LookupTableGenerator)dT_LookupTableGenerator).generateLUT(d, d2, d3, n, modelIndex, bl, bl2, bl3);
        String string2 = "_snr" + (int)d6 + "_" + (Object)((Object)modelIndex);
        if (n2 > 0) {
            string2 = string2 + "_" + n2;
        }
        boolean bl6 = (!bl || !bl2) && (bl || bl2) ^ bl3;
        try {
            double[] dArray2 = new double[]{d, d2, d, d2};
            double[] dArray3 = new double[]{d3, d3};
            if (!bl5) {
                dArray2 = new double[]{0.0, 0.0, d, d2};
                dArray3 = new double[]{0.0, d3};
            }
            if (bl6) {
                OutputManager outputManager = new OutputManager();
                DataOutputStream dataOutputStream = outputManager.getOutputStream();
                if (bl) {
                    GenerateDTLUT.writeBinaryOutput(dArray[0], dArray2, dArray3, dataOutputStream);
                }
                if (bl2) {
                    GenerateDTLUT.writeBinaryOutput(dArray[1], dArray2, dArray3, dataOutputStream);
                }
                if (bl3) {
                    GenerateDTLUT.writeBinaryOutput(dArray[2], dArray2, dArray3, dataOutputStream);
                }
                outputManager.close();
            } else {
                DataOutputStream dataOutputStream;
                FileOutputStream fileOutputStream;
                if (bl) {
                    fileOutputStream = new FileOutputStream(string + "watson" + string2);
                    dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x100000));
                    GenerateDTLUT.writeBinaryOutput(dArray[0], dArray2, dArray3, dataOutputStream);
                    dataOutputStream.close();
                }
                if (bl2) {
                    fileOutputStream = new FileOutputStream(string + "bingham" + string2);
                    dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x100000));
                    GenerateDTLUT.writeBinaryOutput(dArray[1], dArray2, dArray3, dataOutputStream);
                    dataOutputStream.close();
                }
                if (bl3) {
                    fileOutputStream = new FileOutputStream(string + "acg" + string2);
                    dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x100000));
                    GenerateDTLUT.writeBinaryOutput(dArray[2], dArray2, dArray3, dataOutputStream);
                    dataOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new LoggedException("I/O error while writing LUT");
        }
    }

    private static void writeBinaryOutput(double[][][] dArray, double[] dArray2, double[] dArray3, DataOutputStream dataOutputStream) {
        try {
            int n = dArray[0][0].length;
            dataOutputStream.writeDouble(0.0);
            dataOutputStream.writeDouble(0.0);
            dataOutputStream.writeDouble(dArray2[0]);
            dataOutputStream.writeDouble(dArray2[1]);
            dataOutputStream.writeDouble(dArray2[2]);
            dataOutputStream.writeDouble(dArray2[3]);
            dataOutputStream.writeDouble(0.0);
            dataOutputStream.writeDouble(dArray3[0]);
            dataOutputStream.writeDouble(dArray3[1]);
            dataOutputStream.writeDouble(n);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    for (int k = 0; k < dArray.length; ++k) {
                        dataOutputStream.writeDouble(dArray[k][j][i]);
                    }
                }
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            throw new LoggedException("I/O error while writing LUT");
        }
    }
}

