/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.PointSetToScheme;
import data.OutputManager;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Logger;
import misc.LoggedException;
import misc.OrderedAcqMinimizer;
import misc.OrderedAcqSingleSubsetMinimizer;
import misc.OrderedAcqSubsetMinimizer;
import optimizers.SimulatedAnnealingOptimizer;
import tools.CL_Initializer;
import tools.FileInput;
import tools.FileOutput;

public class ElectrostaticSubsets {
    private static Logger logger = Logger.getLogger("camino.apps.ElectrostaticSubsets");

    public static void main(String[] stringArray) {
        int n;
        int n2;
        Object object;
        if (stringArray.length == 0) {
            System.exit(0);
        }
        CL_Initializer.CL_init(stringArray);
        int n3 = 0;
        int n4 = 0;
        int[] nArray = null;
        long l = System.currentTimeMillis();
        double d = -1.0;
        double d2 = 1.0E-7;
        int n5 = 1000;
        boolean bl = false;
        boolean bl2 = false;
        double[][] dArray = null;
        String string = "ElectrostaticSubsets";
        boolean bl3 = false;
        int n6 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-numpoints")) {
                n3 = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-singlesubset")) {
                bl3 = true;
                n6 = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-numsubsets")) {
                n4 = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-pointspersubset")) {
                object = new int[1000];
                n2 = 0;
                while (i + n2 + 1 < stringArray.length && !stringArray[i + 1 + n2].startsWith("-")) {
                    object[n2] = Integer.parseInt(stringArray[i + n2 + 1]);
                    ++n2;
                }
                nArray = new int[n2];
                n4 = n2;
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = (int)object[n];
                }
                CL_Initializer.markAsParsed(i, n4 + 1);
            }
            if (stringArray[i].equals("-seed")) {
                l = Long.parseLong(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-coolingfactor")) {
                d2 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-trialsbetweencooling")) {
                n5 = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-temperature")) {
                d = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-savestate")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-resume")) {
                bl = true;
                object = new FileInput(stringArray[i + 1]);
                String[] stringArray2 = ((FileInput)object).readString().split("\\s");
                n3 = Integer.parseInt(stringArray2[0]);
                n4 = Integer.parseInt(stringArray2[1]);
                nArray = new int[n4];
                for (n = 0; n < n4; ++n) {
                    nArray[n] = Integer.parseInt(stringArray2[n + 2]);
                }
                if (d == -1.0) {
                    d = Double.parseDouble(stringArray2[2 + n4]);
                }
                dArray = new double[n3][3];
                for (n = 0; n < n3; ++n) {
                    String[] stringArray3 = ((FileInput)object).readString().split("\\s");
                    dArray[n][0] = Double.parseDouble(stringArray3[0]);
                    dArray[n][1] = Double.parseDouble(stringArray3[1]);
                    dArray[n][2] = Double.parseDouble(stringArray3[2]);
                }
                ((FileInput)object).close();
                CL_Initializer.markAsParsed(i, 2);
            }
            if (!stringArray[i].equals("-randominit")) continue;
            bl2 = true;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
        if (bl3 && n4 > 0) {
            logger.warning("Single subset specified, but user also passed -numsubsets or -pointspersubset args.");
        }
        if (n3 == 0) {
            bl = true;
            try {
                dArray = PointSetToScheme.normalizePoints(PointSetToScheme.readPoints(CL_Initializer.inputFile));
                n3 = dArray.length;
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        Random random = new Random(l);
        object = null;
        if (bl3) {
            if (bl) {
                object = new OrderedAcqSingleSubsetMinimizer(dArray, n6, d2, n5, string, random);
                if (bl2) {
                    ((OrderedAcqMinimizer)object).initializeRandom();
                }
            } else {
                object = new OrderedAcqSingleSubsetMinimizer(n3, n6, d2, n5, string, random);
            }
        } else {
            if (nArray == null) {
                if (n3 % n4 != 0) {
                    throw new IllegalArgumentException("Can't divide " + n3 + " pairs equally into " + n4 + "subsets");
                }
                nArray = new int[n4];
                for (n2 = 0; n2 < n4; ++n2) {
                    nArray[n2] = n3 / n4;
                }
            }
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                n2 += nArray[n];
            }
            if (n2 != n3) {
                throw new LoggedException("Specified subsets require " + n2 + " points but there are " + n3 + " points");
            }
            if (bl) {
                object = new OrderedAcqSubsetMinimizer(dArray, nArray, d2, n5, string, random);
                if (bl2) {
                    ((OrderedAcqMinimizer)object).initializeRandom();
                }
            } else {
                object = new OrderedAcqSubsetMinimizer(n3, nArray, d2, n5, string, random);
            }
        }
        if (d < 0.0) {
            ((SimulatedAnnealingOptimizer)object).setTemperature(((SimulatedAnnealingOptimizer)object).calibratedTemp(0.7));
        } else {
            ((SimulatedAnnealingOptimizer)object).setTemperature(d);
        }
        ((SimulatedAnnealingOptimizer)object).minimize();
        if (OutputManager.outputFile == null) {
            System.out.print(((SimulatedAnnealingOptimizer)object).lowestEnergyState());
        } else {
            FileOutput fileOutput = new FileOutput(OutputManager.outputFile);
            fileOutput.writeString(((SimulatedAnnealingOptimizer)object).lowestEnergyState());
            fileOutput.close();
        }
    }
}

