/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.DataSource;
import data.OutputManager;
import data.VoxelOrderDataSource;
import imaging.ImageHeader;
import java.io.IOException;
import misc.LoggedException;
import tools.CL_Initializer;

public class DT_ToCamino {
    public static void main(String[] stringArray) {
        Object object;
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.initMaskSource();
        OutputManager outputManager = new OutputManager();
        DataSource dataSource = null;
        DataSource dataSource2 = null;
        String string = null;
        boolean bl = false;
        double d = 1.0;
        double d2 = 0.0;
        boolean bl2 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-s0")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-lns0")) {
                string = stringArray[i + 1];
                bl = true;
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-scaleslope")) {
                d = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-scaleinter")) {
                d2 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-uppertriangular")) {
                bl2 = true;
                CL_Initializer.markAsParsed(i);
            }
            if (!stringArray[i].equals("-lowertriangular")) continue;
            bl2 = false;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
        try {
            object = ImageHeader.readHeader(CL_Initializer.inputFile);
            dataSource = ((ImageHeader)object).getImageDataSource();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        if (string != null) {
            if (ImageHeader.imageExists(string)) {
                try {
                    object = ImageHeader.readHeader(string);
                    dataSource2 = ((ImageHeader)object).getImageDataSource();
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            } else {
                dataSource2 = new VoxelOrderDataSource(string, 1, CL_Initializer.inputDataType);
            }
        }
        while (dataSource.more()) {
            object = dataSource.nextVoxel();
            double[] dArray = new double[8];
            if (CL_Initializer.bgMask != null) {
                double d3 = dArray[0] = CL_Initializer.bgMask.nextVoxel()[0] == 0.0 ? -1.0 : 0.0;
            }
            if (dArray[0] >= 0.0) {
                if (bl2) {
                    dArray[2] = (double)(object[0] * d + d2);
                    dArray[3] = (double)(object[1] * d + d2);
                    dArray[4] = (double)(object[2] * d + d2);
                    dArray[5] = (double)(object[3] * d + d2);
                    dArray[6] = (double)(object[4] * d + d2);
                    dArray[7] = (double)(object[5] * d + d2);
                } else {
                    dArray[2] = (double)(object[0] * d + d2);
                    dArray[3] = (double)(object[1] * d + d2);
                    dArray[4] = (double)(object[3] * d + d2);
                    dArray[5] = (double)(object[2] * d + d2);
                    dArray[6] = (double)(object[4] * d + d2);
                    dArray[7] = (double)(object[5] * d + d2);
                }
            }
            if (dataSource2 != null) {
                double d4 = 0.0;
                if (bl) {
                    d4 = dataSource2.nextVoxel()[0];
                } else {
                    double d5 = dataSource2.nextVoxel()[0];
                    if (d5 > 0.0) {
                        d4 = Math.log(d5);
                    }
                }
                if (dArray[0] >= 0.0) {
                    dArray[1] = d4;
                }
            }
            outputManager.output(dArray);
        }
        outputManager.close();
    }
}

