/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.FracAnis;
import apps.ModelFit;
import data.OutputManager;
import java.util.logging.Logger;
import misc.DT;
import misc.LoggedException;
import tools.CL_Initializer;

public class DT_EigenSystem {
    private static Logger logger = Logger.getLogger("camino.apps.DT_EigenSystem");
    private static OutputManager om;

    public static void main(String[] stringArray) {
        CL_Initializer.inputModel = new String("dt");
        CL_Initializer.inputDataType = new String("double");
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initTensorDataSource();
        om = new OutputManager();
        while (CL_Initializer.data.more()) {
            double[] dArray = CL_Initializer.data.nextVoxel();
            DT[] dTArray = FracAnis.getTensorList(dArray, CL_Initializer.inputModel);
            if (dArray[0] >= 0.0 && !ModelFit.isBG(Math.exp(dArray[1]))) {
                for (int i = 0; i < dTArray.length; ++i) {
                    double[] dArray2;
                    try {
                        double[][] dArray3 = dTArray[i].sortedEigenSystem();
                        dArray2 = new double[12];
                        for (int j = 0; j < 3; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                dArray2[4 * j + k] = dArray3[k][j];
                            }
                        }
                        om.output(dArray2);
                        continue;
                    }
                    catch (Exception exception) {
                        LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
                        dArray2 = new double[12];
                        om.output(dArray2);
                    }
                }
                continue;
            }
            om.output(new double[dTArray.length * 12]);
        }
        om.close();
    }
}

