/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Control;
import JSci.instruments.Image;
import JSci.instruments.ImageFilterAdapter;
import JSci.instruments.Player;
import JSci.instruments.ROIAdapter;
import JSci.instruments.TestImageSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TwoROI
extends ROIAdapter
implements Control {
    private Rectangle template = new Rectangle(0, 0, -2, -2);
    private Rectangle search = new Rectangle(0, 0, -2, -2);
    private int factor = 1;
    private boolean useFactor = true;
    private static final int LW = 3;
    private int state;
    private int iX;
    private int iY;
    private Component comp = null;
    JPanel ccomp = null;

    public void setComponent(Component component) {
        if (this.comp != null) {
            this.comp.removeMouseListener(this);
            this.comp.removeMouseMotionListener(this);
        }
        this.comp = component;
        if (this.comp != null) {
            this.comp.addMouseListener(this);
            this.comp.addMouseMotionListener(this);
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.GREEN);
        graphics2D.draw(this.search);
        graphics2D.setPaint(Color.MAGENTA);
        graphics2D.draw(this.template);
    }

    public void setUseFactor(boolean bl) {
        this.useFactor = bl;
        if (this.useFactor) {
            this.search.setFrame(this.template.getMinX() - (double)this.factor * this.template.getWidth(), this.template.getMinY() - (double)this.factor * this.template.getHeight(), (double)(2 * this.factor + 1) * this.template.getWidth(), (double)(2 * this.factor + 1) * this.template.getHeight());
        }
        if (this.comp != null) {
            this.comp.repaint();
        }
    }

    public void setFactor(int n) {
        this.factor = n;
        if (this.useFactor) {
            this.search.setFrame(this.template.getMinX() - (double)this.factor * this.template.getWidth(), this.template.getMinY() - (double)this.factor * this.template.getHeight(), (double)(2 * this.factor + 1) * this.template.getWidth(), (double)(2 * this.factor + 1) * this.template.getHeight());
        }
        if (this.comp != null) {
            this.comp.repaint();
        }
    }

    public Shape getShape() {
        return (Rectangle)this.template.clone();
    }

    public Rectangle getOuterRectangle() {
        return (Rectangle)this.search.clone();
    }

    public static void main(String[] stringArray) {
        final TwoROI twoROI = new TwoROI();
        Player player = new Player();
        TestImageSource testImageSource = new TestImageSource();
        ImageFilterAdapter imageFilterAdapter = new ImageFilterAdapter(){

            public void filter(Image image) {
            }

            public Component getFilterControlComponent() {
                return ((TwoROI)twoROI).getControlComponent();
            }
        };
        testImageSource.setSink(imageFilterAdapter);
        imageFilterAdapter.setSink(player);
        player.addROI(twoROI);
        player.start();
    }

    public Component getControlComponent() {
        if (this.ccomp != null) {
            return this.ccomp;
        }
        this.ccomp = new JPanel();
        this.ccomp.setLayout(new BorderLayout());
        final JCheckBox jCheckBox = new JCheckBox("Modify search area", false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TwoROI.this.setUseFactor(!jCheckBox.isSelected());
            }
        });
        final JSlider jSlider = new JSlider(1, 5, 1);
        this.setFactor(1);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TwoROI.this.setFactor(jSlider.getValue());
            }
        });
        this.ccomp.add("North", jCheckBox);
        this.ccomp.add("South", jSlider);
        return this.ccomp;
    }

    private int region(Point2D point2D) {
        if (point2D.getX() >= this.template.getMinX() - 3.0 && point2D.getX() <= this.template.getMaxX() + 3.0 && point2D.getY() >= this.template.getMinY() - 3.0 && point2D.getY() <= this.template.getMaxY() + 3.0) {
            if (point2D.getX() <= this.template.getMinX()) {
                if (point2D.getY() <= this.template.getMinY()) {
                    return 10;
                }
                if (point2D.getY() < this.template.getMaxY()) {
                    return 17;
                }
                return 16;
            }
            if (point2D.getX() < this.template.getMaxX()) {
                if (point2D.getY() <= this.template.getMinY()) {
                    return 11;
                }
                if (point2D.getY() < this.template.getMaxY()) {
                    return 1;
                }
                return 15;
            }
            if (point2D.getY() <= this.template.getMinY()) {
                return 12;
            }
            if (point2D.getY() < this.template.getMaxY()) {
                return 13;
            }
            return 14;
        }
        if (this.useFactor) {
            if (this.search.contains(point2D)) {
                return 1;
            }
            return 0;
        }
        if (point2D.getX() >= this.search.getMinX() - 3.0 && point2D.getX() <= this.search.getMaxX() + 3.0 && point2D.getY() >= this.search.getMinY() - 3.0 && point2D.getY() <= this.search.getMaxY() + 3.0) {
            if (point2D.getX() <= this.search.getMinX()) {
                if (point2D.getY() <= this.search.getMinY()) {
                    return 2;
                }
                if (point2D.getY() < this.search.getMaxY()) {
                    return 9;
                }
                return 8;
            }
            if (point2D.getX() < this.search.getMaxX()) {
                if (point2D.getY() <= this.search.getMinY()) {
                    return 3;
                }
                if (point2D.getY() < this.search.getMaxY()) {
                    return 1;
                }
                return 7;
            }
            if (point2D.getY() <= this.search.getMinY()) {
                return 4;
            }
            if (point2D.getY() < this.search.getMaxY()) {
                return 5;
            }
            return 6;
        }
        return 0;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.state = this.region(mouseEvent.getPoint());
        this.iX = mouseEvent.getX();
        this.iY = mouseEvent.getY();
        if (this.state == 0) {
            this.template.setFrame(this.iX, this.iY, 0.0, 0.0);
            this.search.setFrame(this.iX, this.iY, 0.0, 0.0);
        }
        if (this.comp != null) {
            this.comp.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.state = 0;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        switch (this.region(mouseEvent.getPoint())) {
            case 0: {
                this.comp.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case 1: {
                this.comp.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case 2: {
                this.comp.setCursor(Cursor.getPredefinedCursor(5));
                break;
            }
            case 3: {
                this.comp.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case 4: {
                this.comp.setCursor(Cursor.getPredefinedCursor(4));
                break;
            }
            case 5: {
                this.comp.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 6: {
                this.comp.setCursor(Cursor.getPredefinedCursor(5));
                break;
            }
            case 7: {
                this.comp.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case 8: {
                this.comp.setCursor(Cursor.getPredefinedCursor(4));
                break;
            }
            case 9: {
                this.comp.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 10: {
                this.comp.setCursor(Cursor.getPredefinedCursor(5));
                break;
            }
            case 11: {
                this.comp.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case 12: {
                this.comp.setCursor(Cursor.getPredefinedCursor(4));
                break;
            }
            case 13: {
                this.comp.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 14: {
                this.comp.setCursor(Cursor.getPredefinedCursor(5));
                break;
            }
            case 15: {
                this.comp.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case 16: {
                this.comp.setCursor(Cursor.getPredefinedCursor(4));
                break;
            }
            case 17: {
                this.comp.setCursor(Cursor.getPredefinedCursor(11));
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.useFactor) {
            switch (this.state) {
                case 0: {
                    n4 = this.iX < mouseEvent.getX() ? this.iX : mouseEvent.getX();
                    n3 = this.iY < mouseEvent.getY() ? this.iY : mouseEvent.getY();
                    n2 = this.iX - mouseEvent.getX();
                    if (n2 < 0) {
                        n2 = -n2;
                    }
                    if ((n = this.iY - mouseEvent.getY()) < 0) {
                        n = -n;
                    }
                    this.template.setFrame(n4, n3, n2, n);
                    break;
                }
                case 1: {
                    this.template.setFrame(this.template.getMinX() + (double)mouseEvent.getX() - (double)this.iX, this.template.getMinY() + (double)mouseEvent.getY() - (double)this.iY, this.template.getWidth(), this.template.getHeight());
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 10: {
                    n2 = mouseEvent.getX() - this.iX;
                    n = mouseEvent.getY() - this.iY;
                    if (this.template.getMinX() + (double)n2 > this.template.getMaxX()) {
                        n2 = (int)(this.template.getMaxX() - this.template.getMinX());
                    }
                    if (this.template.getMinY() + (double)n > this.template.getMaxY()) {
                        n = (int)(this.template.getMaxY() - this.template.getMinY());
                    }
                    this.template.setFrame(this.template.getMinX() + (double)n2, this.template.getMinY() + (double)n, this.template.getWidth() - (double)n2, this.template.getHeight() - (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 11: {
                    n = mouseEvent.getY() - this.iY;
                    if (this.template.getMinY() + (double)n > this.template.getMaxY()) {
                        n = (int)(this.template.getMaxY() - this.template.getMinY());
                    }
                    this.template.setFrame(this.template.getMinX(), this.template.getMinY() + (double)n, this.template.getWidth(), this.template.getHeight() - (double)n);
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 12: {
                    n2 = mouseEvent.getX() - this.iX;
                    n = mouseEvent.getY() - this.iY;
                    if (this.template.getMaxX() + (double)n2 < this.template.getMinX()) {
                        n2 = (int)(this.template.getMinX() - this.template.getMaxX());
                    }
                    if (this.template.getMinY() + (double)n > this.template.getMaxY()) {
                        n = (int)(this.template.getMaxY() - this.template.getMinY());
                    }
                    this.template.setFrame(this.template.getMinX(), this.template.getMinY() + (double)n, this.template.getWidth() + (double)n2, this.template.getHeight() - (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 13: {
                    n2 = mouseEvent.getX() - this.iX;
                    if (this.template.getMaxX() + (double)n2 < this.template.getMinX()) {
                        n2 = (int)(this.template.getMinX() - this.template.getMaxX());
                    }
                    this.template.setFrame(this.template.getMinX(), this.template.getMinY(), this.template.getWidth() + (double)n2, this.template.getHeight());
                    this.iX = mouseEvent.getX();
                    break;
                }
                case 14: {
                    n2 = mouseEvent.getX() - this.iX;
                    n = mouseEvent.getY() - this.iY;
                    if (this.template.getMaxX() + (double)n2 < this.template.getMinX()) {
                        n2 = (int)(this.template.getMinX() - this.template.getMaxX());
                    }
                    if (this.template.getMaxY() + (double)n < this.template.getMinY()) {
                        n = (int)(this.template.getMinY() - this.template.getMaxY());
                    }
                    this.template.setFrame(this.template.getMinX(), this.template.getMinY(), this.template.getWidth() + (double)n2, this.template.getHeight() + (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 15: {
                    n = mouseEvent.getY() - this.iY;
                    if (this.template.getMaxY() + (double)n < this.template.getMinY()) {
                        n = (int)(this.template.getMinY() - this.template.getMaxY());
                    }
                    this.template.setFrame(this.template.getMinX(), this.template.getMinY(), this.template.getWidth(), this.template.getHeight() + (double)n);
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 16: {
                    n = mouseEvent.getY() - this.iY;
                    n2 = mouseEvent.getX() - this.iX;
                    if (this.template.getMinX() + (double)n2 > this.template.getMaxX()) {
                        n2 = (int)(this.template.getMaxX() - this.template.getMinX());
                    }
                    if (this.template.getMaxY() + (double)n < this.template.getMinY()) {
                        n = (int)(this.template.getMinY() - this.template.getMaxY());
                    }
                    this.template.setFrame(this.template.getMinX() + (double)n2, this.template.getMinY(), this.template.getWidth() - (double)n2, this.template.getHeight() + (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 17: {
                    n2 = mouseEvent.getX() - this.iX;
                    if (this.template.getMinX() + (double)n2 > this.template.getMaxX()) {
                        n2 = (int)(this.template.getMaxX() - this.template.getMinX());
                    }
                    this.template.setFrame(this.template.getMinX() + (double)n2, this.template.getMinY(), this.template.getWidth() - (double)n2, this.template.getHeight());
                    this.iX = mouseEvent.getX();
                }
            }
        }
        if (!this.useFactor) {
            switch (this.state) {
                case 0: {
                    n4 = this.iX < mouseEvent.getX() ? this.iX : mouseEvent.getX();
                    n3 = this.iY < mouseEvent.getY() ? this.iY : mouseEvent.getY();
                    n2 = this.iX - mouseEvent.getX();
                    if (n2 < 0) {
                        n2 = -n2;
                    }
                    if ((n = this.iY - mouseEvent.getY()) < 0) {
                        n = -n;
                    }
                    this.template.setFrame(n4, n3, n2, n);
                    this.search.setFrame(n4 - this.factor * n2, n3 - this.factor * n, (2 * this.factor + 1) * n2, (2 * this.factor + 1) * n);
                    break;
                }
                case 1: {
                    this.template.setFrame(this.template.getMinX() + (double)mouseEvent.getX() - (double)this.iX, this.template.getMinY() + (double)mouseEvent.getY() - (double)this.iY, this.template.getWidth(), this.template.getHeight());
                    this.search.setFrame(this.search.getMinX() + (double)mouseEvent.getX() - (double)this.iX, this.search.getMinY() + (double)mouseEvent.getY() - (double)this.iY, this.search.getWidth(), this.search.getHeight());
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 2: {
                    n2 = mouseEvent.getX() - this.iX;
                    n = mouseEvent.getY() - this.iY;
                    if (this.search.getMinX() + (double)n2 > this.template.getMinX()) {
                        n2 = (int)(this.template.getMinX() - this.search.getMinX());
                    }
                    if (this.search.getMinY() + (double)n > this.template.getMinY()) {
                        n = (int)(this.template.getMinY() - this.search.getMinY());
                    }
                    this.search.setFrame(this.search.getMinX() + (double)n2, this.search.getMinY() + (double)n, this.search.getWidth() - (double)n2, this.search.getHeight() - (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 3: {
                    n = mouseEvent.getY() - this.iY;
                    if (this.search.getMinY() + (double)n > this.template.getMinY()) {
                        n = (int)(this.template.getMinY() - this.search.getMinY());
                    }
                    this.search.setFrame(this.search.getMinX(), this.search.getMinY() + (double)n, this.search.getWidth(), this.search.getHeight() - (double)n);
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 4: {
                    n2 = mouseEvent.getX() - this.iX;
                    n = mouseEvent.getY() - this.iY;
                    if (this.search.getMinY() + (double)n > this.template.getMinY()) {
                        n = (int)(this.template.getMinY() - this.search.getMinY());
                    }
                    if (this.search.getMaxX() + (double)n2 < this.template.getMaxX()) {
                        n2 = (int)(this.template.getMaxX() - this.search.getMaxX());
                    }
                    this.search.setFrame(this.search.getMinX(), this.search.getMinY() + (double)n, this.search.getWidth() + (double)n2, this.search.getHeight() - (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 5: {
                    n2 = mouseEvent.getX() - this.iX;
                    if (this.search.getMaxX() + (double)n2 < this.template.getMaxX()) {
                        n2 = (int)(this.template.getMaxX() - this.search.getMaxX());
                    }
                    this.search.setFrame(this.search.getMinX(), this.search.getMinY(), this.search.getWidth() + (double)n2, this.search.getHeight());
                    this.iX = mouseEvent.getX();
                    break;
                }
                case 6: {
                    n2 = mouseEvent.getX() - this.iX;
                    n = mouseEvent.getY() - this.iY;
                    if (this.search.getMaxX() + (double)n2 < this.template.getMaxX()) {
                        n2 = (int)(this.template.getMaxX() - this.search.getMaxX());
                    }
                    if (this.search.getMaxY() + (double)n < this.template.getMaxY()) {
                        n = (int)(this.template.getMaxY() - this.search.getMaxY());
                    }
                    this.search.setFrame(this.search.getMinX(), this.search.getMinY(), this.search.getWidth() + (double)n2, this.search.getHeight() + (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 7: {
                    n = mouseEvent.getY() - this.iY;
                    if (this.search.getMaxY() + (double)n < this.template.getMaxY()) {
                        n = (int)(this.template.getMaxY() - this.search.getMaxY());
                    }
                    this.search.setFrame(this.search.getMinX(), this.search.getMinY(), this.search.getWidth(), this.search.getHeight() + (double)n);
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 8: {
                    n = mouseEvent.getY() - this.iY;
                    n2 = mouseEvent.getX() - this.iX;
                    if (this.search.getMaxY() + (double)n < this.template.getMaxY()) {
                        n = (int)(this.template.getMaxY() - this.search.getMaxY());
                    }
                    if (this.search.getMinX() + (double)n2 > this.template.getMinX()) {
                        n2 = (int)(this.template.getMinX() - this.search.getMinX());
                    }
                    this.search.setFrame(this.search.getMinX() + (double)n2, this.search.getMinY(), this.search.getWidth() - (double)n2, this.search.getHeight() + (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 9: {
                    n2 = mouseEvent.getX() - this.iX;
                    if (this.search.getMinX() + (double)n2 > this.template.getMinX()) {
                        n2 = (int)(this.template.getMinX() - this.search.getMinX());
                    }
                    this.search.setFrame(this.search.getMinX() + (double)n2, this.search.getMinY(), this.search.getWidth() - (double)n2, this.search.getHeight());
                    this.iX = mouseEvent.getX();
                    break;
                }
                case 10: {
                    n2 = mouseEvent.getX() - this.iX;
                    n = mouseEvent.getY() - this.iY;
                    if (this.template.getMinX() + (double)n2 > this.template.getMaxX()) {
                        n2 = (int)(this.template.getMaxX() - this.template.getMinX());
                    }
                    if (this.template.getMinX() + (double)n2 < this.search.getMinX()) {
                        n2 = (int)(this.search.getMinX() - this.template.getMinX());
                    }
                    if (this.template.getMinY() + (double)n > this.template.getMaxY()) {
                        n = (int)(this.template.getMaxY() - this.template.getMinY());
                    }
                    if (this.template.getMinY() + (double)n < this.search.getMinY()) {
                        n = (int)(this.search.getMinY() - this.template.getMinY());
                    }
                    this.template.setFrame(this.template.getMinX() + (double)n2, this.template.getMinY() + (double)n, this.template.getWidth() - (double)n2, this.template.getHeight() - (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 11: {
                    n = mouseEvent.getY() - this.iY;
                    if (this.template.getMinY() + (double)n > this.template.getMaxY()) {
                        n = (int)(this.template.getMaxY() - this.template.getMinY());
                    }
                    if (this.template.getMinY() + (double)n < this.search.getMinY()) {
                        n = (int)(this.search.getMinY() - this.template.getMinY());
                    }
                    this.template.setFrame(this.template.getMinX(), this.template.getMinY() + (double)n, this.template.getWidth(), this.template.getHeight() - (double)n);
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 12: {
                    n2 = mouseEvent.getX() - this.iX;
                    n = mouseEvent.getY() - this.iY;
                    if (this.template.getMaxX() + (double)n2 < this.template.getMinX()) {
                        n2 = (int)(this.template.getMinX() - this.template.getMaxX());
                    }
                    if (this.template.getMaxX() + (double)n2 > this.search.getMaxX()) {
                        n2 = (int)(this.search.getMaxX() - this.template.getMaxX());
                    }
                    if (this.template.getMinY() + (double)n > this.template.getMaxY()) {
                        n = (int)(this.template.getMaxY() - this.template.getMinY());
                    }
                    if (this.template.getMinY() + (double)n < this.search.getMinY()) {
                        n = (int)(this.search.getMinY() - this.template.getMinY());
                    }
                    this.template.setFrame(this.template.getMinX(), this.template.getMinY() + (double)n, this.template.getWidth() + (double)n2, this.template.getHeight() - (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 13: {
                    n2 = mouseEvent.getX() - this.iX;
                    if (this.template.getMaxX() + (double)n2 < this.template.getMinX()) {
                        n2 = (int)(this.template.getMinX() - this.template.getMaxX());
                    }
                    if (this.template.getMaxX() + (double)n2 > this.search.getMaxX()) {
                        n2 = (int)(this.search.getMaxX() - this.template.getMaxX());
                    }
                    this.template.setFrame(this.template.getMinX(), this.template.getMinY(), this.template.getWidth() + (double)n2, this.template.getHeight());
                    this.iX = mouseEvent.getX();
                    break;
                }
                case 14: {
                    n2 = mouseEvent.getX() - this.iX;
                    n = mouseEvent.getY() - this.iY;
                    if (this.template.getMaxX() + (double)n2 < this.template.getMinX()) {
                        n2 = (int)(this.template.getMinX() - this.template.getMaxX());
                    }
                    if (this.template.getMaxX() + (double)n2 > this.search.getMaxX()) {
                        n2 = (int)(this.search.getMaxX() - this.template.getMaxX());
                    }
                    if (this.template.getMaxY() + (double)n < this.template.getMinY()) {
                        n = (int)(this.template.getMinY() - this.template.getMaxY());
                    }
                    if (this.template.getMaxY() + (double)n > this.search.getMaxY()) {
                        n = (int)(this.search.getMaxY() - this.template.getMaxY());
                    }
                    this.template.setFrame(this.template.getMinX(), this.template.getMinY(), this.template.getWidth() + (double)n2, this.template.getHeight() + (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 15: {
                    n = mouseEvent.getY() - this.iY;
                    if (this.template.getMaxY() + (double)n < this.template.getMinY()) {
                        n = (int)(this.template.getMinY() - this.template.getMaxY());
                    }
                    if (this.template.getMaxY() + (double)n > this.search.getMaxY()) {
                        n = (int)(this.search.getMaxY() - this.template.getMaxY());
                    }
                    this.template.setFrame(this.template.getMinX(), this.template.getMinY(), this.template.getWidth(), this.template.getHeight() + (double)n);
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 16: {
                    n = mouseEvent.getY() - this.iY;
                    n2 = mouseEvent.getX() - this.iX;
                    if (this.template.getMinX() + (double)n2 > this.template.getMaxX()) {
                        n2 = (int)(this.template.getMaxX() - this.template.getMinX());
                    }
                    if (this.template.getMinX() + (double)n2 < this.search.getMinX()) {
                        n2 = (int)(this.search.getMinX() - this.template.getMinX());
                    }
                    if (this.template.getMaxY() + (double)n < this.template.getMinY()) {
                        n = (int)(this.template.getMinY() - this.template.getMaxY());
                    }
                    if (this.template.getMaxY() + (double)n > this.search.getMaxY()) {
                        n = (int)(this.search.getMaxY() - this.template.getMaxY());
                    }
                    this.template.setFrame(this.template.getMinX() + (double)n2, this.template.getMinY(), this.template.getWidth() - (double)n2, this.template.getHeight() + (double)n);
                    this.iX = mouseEvent.getX();
                    this.iY = mouseEvent.getY();
                    break;
                }
                case 17: {
                    n2 = mouseEvent.getX() - this.iX;
                    if (this.template.getMinX() + (double)n2 > this.template.getMaxX()) {
                        n2 = (int)(this.template.getMaxX() - this.template.getMinX());
                    }
                    if (this.template.getMinX() + (double)n2 < this.search.getMinX()) {
                        n2 = (int)(this.search.getMinX() - this.template.getMinX());
                    }
                    this.template.setFrame(this.template.getMinX() + (double)n2, this.template.getMinY(), this.template.getWidth() - (double)n2, this.template.getHeight());
                    this.iX = mouseEvent.getX();
                }
            }
        }
        if (this.useFactor) {
            this.search.setFrame(this.template.getMinX() - (double)this.factor * this.template.getWidth(), this.template.getMinY() - (double)this.factor * this.template.getHeight(), (double)(2 * this.factor + 1) * this.template.getWidth(), (double)(2 * this.factor + 1) * this.template.getHeight());
        }
        if (this.comp != null) {
            this.comp.repaint();
        }
    }
}

