/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Image;
import JSci.instruments.ImageSink;
import JSci.instruments.ImageSource;
import JSci.instruments.Overlay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TestImageSource
implements ImageSource,
Runnable {
    Dimension dim = new Dimension(130, 97);
    private ImageSink sink;

    public TestImageSource() {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public void setSink(ImageSink imageSink) {
        if (this.sink != imageSink) {
            this.sink = imageSink;
            this.sink.setSource(this);
        }
    }

    public void run() {
        int n = 0;
        while (true) {
            final int n2 = n++;
            final long l = System.currentTimeMillis();
            final byte[] byArray = new byte[this.getWidth() * this.getHeight()];
            final Dimension dimension = new Dimension(this.getWidth(), this.getHeight());
            for (int i = 0; i < this.getWidth(); ++i) {
                for (int j = 0; j < this.getHeight(); ++j) {
                    byArray[i + j * this.getWidth()] = (byte)((i + n2) % 256);
                }
            }
            Image image = new Image(){

                public byte[] getData() {
                    return byArray;
                }

                public Dimension getSize() {
                    return dimension;
                }

                public long getTimeStamp() {
                    return l;
                }
            };
            image.addOverlay(new Overlay(){

                public void paint(Graphics graphics) {
                    graphics.setColor(Color.MAGENTA);
                    ((Graphics2D)graphics).draw(new Rectangle(30 + n2 % 10, 34, 40, 40));
                }
            });
            if (this.sink != null) {
                this.sink.receive(image);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public int getWidth() {
        return this.dim.width;
    }

    public int getHeight() {
        return this.dim.height;
    }

    public Dimension getSize() {
        return this.dim;
    }

    public Component getControlComponent() {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Test"));
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "source");
        jPanel.setBorder(titledBorder);
        return jPanel;
    }
}

