#ifndef PBARDEFS_INCLUDED
#define PBARDEFS_INCLUDED


/* ZSS: New 256-color maps.
   Each new color map is added with 
   a call to PBAR_define_bigmap in pbar.c
*/

/* Color map for The Eickhoff and Zilles 
   Cytoarchitectonic data AllAreas_v12
   
  see matlab/MakeCytoArchColMaps.m
*/
static char CYTOARCH_ROI_256_CMD[] = {  
      "CytoArch_ROI_i256 "
      "#84392e #018f67 #776b1b #01d9d4 #9f35b8 "
      "#f7d202 #2100cf #d494f6 #bbfa2d #fd2d74 "
      "#90c648 #c4516e #fe28fd #a83d26 #4fda69 "
      "#40fcf8 #c4589f #27abf3 #610051 #49f8c0 "
      "#ad185d #68f88d #d80491 #d92918 #2b649d "
      "#65bbea #772e83 #fed039 #0591b2 #ed2b3e "
      "#67a84b #cb7941 #7a2eb0 #39af94 #57fa28 "
      "#fb7dfd #a46b42 #13e94c #4b70f0 #c8cf33 "
      "#02e79a #fcae11 #96d7fb #42358b #0009fd "
      "#ff2bcf #9d9909 #173472 #fe7c31 #3780c8 "
      "#1041fe #f0d260 #a19349 #45ff8a #fd9376 "
      "#cf3fcc #c3c866 #059489 #3cfe59 #ff0091 "
      "#fbb3a1 #c8f104 #d92a70 #86ef42 #7b02ea "
      "#fde693 #b408b2 #1b52d4 #f687cd #8257b9 "
      "#88100b #fa03cb #e85783 #045602 #7d97fa "
      "#8cfe76 #1608a9 #fdff01 #ff56b9 #0d359a "
      "#b41335 #7b07ab #3dc0c5 #feab3d #6fc9af "
      "#0afdf9 #b9f760 #4cc50f #c067fe #fffb5f "
      "#df7e05 #ba00de #3d954b #c636f6 #05b7c2 "
      "#ac3d02 #0d7e3d #534fb4 #ac7119 #ab0a85 "
      "#0667a5 #17b80f #494be9 #860b3b #85c323 "
      "#6ddedd #3d888c #d5956d #378307 #390872 "
      "#8463ff #24f0c6 #d1b100 #02fc73 #90ffa8 "
      "#01c6fc #fd1017 #4407f2 #9b4450 #03b24b "
      "#a0428e #02bf89 #4d96ff #79490c #461ab6 "
      "#43d344 #b06dc9 #df4e04 #83d16f #04f025 "
      "#a2fee4 #e80153 #ffa6f8 #96f718 #5e83c0 "
      "#eb02f9 #bf0005 #cfa736 #0a7fdf #f685a0 "
      "#000a7a #e12ba0 #046372 #d1eb91 #740377 "
      "#39d6fc #708e1f #acb0fd #fd52fa #01840a "
      "#0626d6 #5c0a08 #e3f92f #49ff00 #3ed78e "
      "#872cde #df5146 #b3b3b3 #b1b1b1 #afafaf "
      "#aeaeae #acacac #ababab #a9a9a9 #a8a8a8 "
      "#a6a6a6 #a4a4a4 #a3a3a3 #a1a1a1 #a0a0a0 "
      "#9e9e9e #9d9d9d #9b9b9b #9a9a9a #989898 "
      "#969696 #959595 #939393 #929292 #909090 "
      "#8f8f8f #8d8d8d #8b8b8b #8a8a8a #888888 "
      "#878787 #858585 #848484 #828282 #818181 "
      "#7f7f7f #7d7d7d #7c7c7c #7a7a7a #797979 "
      "#777777 #767676 #747474 #727272 #717171 "
      "#6f6f6f #6e6e6e #6c6c6c #6b6b6b #696969 "
      "#686868 #666666 #646464 #636363 #616161 "
      "#606060 #5e5e5e #5d5d5d #5b5b5b #5a5a5a "
      "#585858 #565656 #555555 #535353 #525252 "
      "#505050 #4f4f4f #4d4d4d #4b4b4b #4a4a4a "
      "#484848 #474747 #454545 #444444 #424242 "
      "#414141 #3f3f3f #3d3d3d #3c3c3c #3a3a3a "
      "#393939 #373737 #363636 #343434 #323232 "
      "#313131 #2f2f2f #2e2e2e #2c2c2c #2b2b2b "
      "#292929 #282828 #262626 #242424 #232323 "
      "#212121 #202020 #1e1e1e #1d1d1d #1b1b1b "
      "#1a1a1a "
};
static char CYTOARCH_ROI_256_GAP_CMD[] = {  
      "CytoArch_ROI_i256_gap "
      "#84392e #018f67 #776b1b #01d9d4 #9f35b8 "
      "#f7d202 #2100cf #d494f6 #bbfa2d #fd2d74 "
      "#90c648 #c4516e #fe28fd #a83d26 #4fda69 "
      "#40fcf8 #c4589f #27abf3 #610051 #49f8c0 "
      "#ad185d #68f88d #d80491 #d92918 #2b649d "
      "#65bbea #772e83 #fed039 #0591b2 #ed2b3e "
      "#67a84b #cb7941 #7a2eb0 #39af94 #57fa28 "
      "#fb7dfd #a46b42 #13e94c #4b70f0 #c8cf33 "
      "#02e79a #fcae11 #96d7fb #42358b #0009fd "
      "#ff2bcf #9d9909 #173472 #fe7c31 #3780c8 "
      "#1041fe #f0d260 #a19349 #45ff8a #fd9376 "
      "#cf3fcc #c3c866 #059489 #3cfe59 #ff0091 "
      "#fbb3a1 #c8f104 #d92a70 #86ef42 #7b02ea "
      "#fde693 #b408b2 #1b52d4 #f687cd #8257b9 "
      "#88100b #fa03cb #e85783 #045602 #7d97fa "
      "#8cfe76 #1608a9 #fdff01 #ff56b9 #0d359a "
      "#b41335 #7b07ab #3dc0c5 #feab3d #6fc9af "
      "#0afdf9 #b9f760 #4cc50f #c067fe #fffb5f "
      "#df7e05 #ba00de #3d954b #c636f6 #05b7c2 "
      "#ac3d02 #0d7e3d #534fb4 #ac7119 #ab0a85 "
      "#0667a5 #17b80f #494be9 #860b3b #85c323 "
      "#6ddedd #3d888c #d5956d #378307 #390872 "
      "#8463ff #24f0c6 #d1b100 #02fc73 #90ffa8 "
      "#01c6fc #fd1017 #4407f2 #9b4450 #03b24b "
      "#a0428e #02bf89 #4d96ff #79490c #461ab6 "
      "#43d344 #b06dc9 #df4e04 #83d16f #04f025 "
      "#a2fee4 #e80153 #ffa6f8 #96f718 #5e83c0 "
      "#eb02f9 #bf0005 #cfa736 #0a7fdf #f685a0 "
      "#000a7a #e12ba0 #046372 #d1eb91 #740377 "
      "#39d6fc #708e1f #acb0fd #fd52fa #01840a "
      "#0626d6 #5c0a08 #e3f92f #49ff00 #3ed78e "
      "#872cde #df5146 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 #000000 #000000 #000000 #000000 "
      "#000000 "
};
/* While we're at it, some maps for ROI drawing 
   see matlab/MakeROIColMaps.m
*/
static char ROI_256_CMD[] = {  
      "ROI_i256 "
      "#41a2b0 #0a32b6 #df70f8 #78f525 #d80475 "
      "#cf7c23 #fbb060 #5df345 #fc3820 #d97d98 "
      "#15b76c #fd8b14 #83b6ed #a544fa #adbd02 "
      "#8f0459 #90e18d #d90ad8 #56146f #59dffb "
      "#3f07d3 #fe2e95 #ac1f0a #01c12c #8ee1d6 "
      "#6bfa67 #2adb1f #4e29fb #dd0203 #086420 "
      "#de53fc #47b5f6 #7f2261 #7e9601 #a748db "
      "#21dfa7 #68a8c5 #02f804 #d05024 #d8fd74 "
      "#0007ce #fb7576 #07d66a #69022b #02f8cd "
      "#650acc #f80372 #be3b45 #fdb37f #3ea0cd "
      "#ff5a57 #e0f450 #a69229 #2504fb #6ecf91 "
      "#8a04cc #2d7dfd #22ffa1 #0660f7 #256401 "
      "#450195 #c9d009 #2b822b #7a33fd #c77461 "
      "#25b548 #adec88 #c235a1 #67f4ab #d305b5 "
      "#4ba51a #9f1cff #60b56c #045650 #ef60da "
      "#622ad6 #6efee7 #c101ff #fd8654 #a6c21f "
      "#28d66d #ff5c04 #3029da #82cc03 #8c89d9 "
      "#f35624 #65cf44 #090355 #b18ff1 #dc0327 "
      "#8564dd #20ef02 #04a4f0 #515e02 #3041ad "
      "#30fb2a #d283ce #6df405 #3cad6e #84392e "
      "#018f67 #776b1b #01d9d4 #9f35b8 #f7d202 "
      "#2100cf #d494f6 #bbfa2d #fd2d74 #90c648 "
      "#c4516e #fe28fd #a83d26 #4fda69 #40fcf8 "
      "#c4589f #27abf3 #610051 #49f8c0 #ad185d "
      "#68f88d #d80491 #d92918 #2b649d #65bbea "
      "#772e83 #fed039 #0591b2 #ed2b3e #67a84b "
      "#cb7941 #7a2eb0 #39af94 #57fa28 #fb7dfd "
      "#a46b42 #13e94c #4b70f0 #c8cf33 #02e79a "
      "#fcae11 #96d7fb #42358b #0009fd #ff2bcf "
      "#9d9909 #173472 #fe7c31 #3780c8 #1041fe "
      "#f0d260 #a19349 #45ff8a #fd9376 #cf3fcc "
      "#c3c866 #059489 #3cfe59 #ff0091 #fbb3a1 "
      "#c8f104 #d92a70 #86ef42 #7b02ea #fde693 "
      "#b408b2 #1b52d4 #f687cd #8257b9 #88100b "
      "#fa03cb #e85783 #045602 #7d97fa #8cfe76 "
      "#1608a9 #fdff01 #ff56b9 #0d359a #b41335 "
      "#7b07ab #3dc0c5 #feab3d #6fc9af #0afdf9 "
      "#b9f760 #4cc50f #c067fe #fffb5f #df7e05 "
      "#ba00de #3d954b #c636f6 #05b7c2 #ac3d02 "
      "#0d7e3d #534fb4 #ac7119 #ab0a85 #0667a5 "
      "#17b80f #494be9 #860b3b #85c323 #6ddedd "
      "#3d888c #d5956d #378307 #390872 #8463ff "
      "#24f0c6 #d1b100 #02fc73 #90ffa8 #01c6fc "
      "#fd1017 #4407f2 #9b4450 #03b24b #a0428e "
      "#02bf89 #4d96ff #79490c #461ab6 #43d344 "
      "#b06dc9 #df4e04 #83d16f #04f025 #a2fee4 "
      "#e80153 #ffa6f8 #96f718 #5e83c0 #eb02f9 "
      "#bf0005 #cfa736 #0a7fdf #f685a0 #000a7a "
      "#e12ba0 #046372 #d1eb91 #740377 #39d6fc "
      "#708e1f #acb0fd #fd52fa #01840a #0626d6 "
      "#5c0a08 #e3f92f #49ff00 #3ed78e #872cde "
      "#df5146 "
};

static char ROI_128_CMD[] = {  
      "ROI_i128 "
      "#ed2b3e #67a84b #cb7941 #7a2eb0 #39af94 "
      "#57fa28 #fb7dfd #a46b42 #13e94c #4b70f0 "
      "#c8cf33 #02e79a #fcae11 #96d7fb #42358b "
      "#0009fd #ff2bcf #9d9909 #173472 #fe7c31 "
      "#3780c8 #1041fe #f0d260 #a19349 #45ff8a "
      "#fd9376 #cf3fcc #c3c866 #059489 #3cfe59 "
      "#ff0091 #fbb3a1 #c8f104 #d92a70 #86ef42 "
      "#7b02ea #fde693 #b408b2 #1b52d4 #f687cd "
      "#8257b9 #88100b #fa03cb #e85783 #045602 "
      "#7d97fa #8cfe76 #1608a9 #fdff01 #ff56b9 "
      "#0d359a #b41335 #7b07ab #3dc0c5 #feab3d "
      "#6fc9af #0afdf9 #b9f760 #4cc50f #c067fe "
      "#fffb5f #df7e05 #ba00de #3d954b #c636f6 "
      "#05b7c2 #ac3d02 #0d7e3d #534fb4 #ac7119 "
      "#ab0a85 #0667a5 #17b80f #494be9 #860b3b "
      "#85c323 #6ddedd #3d888c #d5956d #378307 "
      "#390872 #8463ff #24f0c6 #d1b100 #02fc73 "
      "#90ffa8 #01c6fc #fd1017 #4407f2 #9b4450 "
      "#03b24b #a0428e #02bf89 #4d96ff #79490c "
      "#461ab6 #43d344 #b06dc9 #df4e04 #83d16f "
      "#04f025 #a2fee4 #e80153 #ffa6f8 #96f718 "
      "#5e83c0 #eb02f9 #bf0005 #cfa736 #0a7fdf "
      "#f685a0 #000a7a #e12ba0 #046372 #d1eb91 "
      "#740377 #39d6fc #708e1f #acb0fd #fd52fa "
      "#01840a #0626d6 #5c0a08 #e3f92f #49ff00 "
      "#3ed78e #872cde #df5146 "
};
static char ROI_128_256_CMD[] = {  
      "ROI_i128 "
      "#ed2b3e #ed2b3e #67a84b #67a84b #cb7941 "
      "#cb7941 #7a2eb0 #7a2eb0 #39af94 #39af94 "
      "#57fa28 #57fa28 #fb7dfd #fb7dfd #a46b42 "
      "#a46b42 #13e94c #13e94c #4b70f0 #4b70f0 "
      "#c8cf33 #c8cf33 #02e79a #02e79a #fcae11 "
      "#fcae11 #96d7fb #96d7fb #42358b #42358b "
      "#0009fd #0009fd #ff2bcf #ff2bcf #9d9909 "
      "#9d9909 #173472 #173472 #fe7c31 #fe7c31 "
      "#3780c8 #3780c8 #1041fe #1041fe #f0d260 "
      "#f0d260 #a19349 #a19349 #45ff8a #45ff8a "
      "#fd9376 #fd9376 #cf3fcc #cf3fcc #c3c866 "
      "#c3c866 #059489 #059489 #3cfe59 #3cfe59 "
      "#ff0091 #ff0091 #fbb3a1 #fbb3a1 #c8f104 "
      "#c8f104 #d92a70 #d92a70 #86ef42 #86ef42 "
      "#7b02ea #7b02ea #fde693 #fde693 #b408b2 "
      "#b408b2 #1b52d4 #1b52d4 #f687cd #f687cd "
      "#8257b9 #8257b9 #88100b #88100b #fa03cb "
      "#fa03cb #e85783 #e85783 #045602 #045602 "
      "#7d97fa #7d97fa #8cfe76 #8cfe76 #1608a9 "
      "#1608a9 #fdff01 #fdff01 #ff56b9 #ff56b9 "
      "#0d359a #0d359a #b41335 #b41335 #7b07ab "
      "#7b07ab #3dc0c5 #3dc0c5 #feab3d #feab3d "
      "#6fc9af #6fc9af #0afdf9 #0afdf9 #b9f760 "
      "#b9f760 #4cc50f #4cc50f #c067fe #c067fe "
      "#fffb5f #fffb5f #df7e05 #df7e05 #ba00de "
      "#ba00de #3d954b #3d954b #c636f6 #c636f6 "
      "#05b7c2 #05b7c2 #ac3d02 #ac3d02 #0d7e3d "
      "#0d7e3d #534fb4 #534fb4 #ac7119 #ac7119 "
      "#ab0a85 #ab0a85 #0667a5 #0667a5 #17b80f "
      "#17b80f #494be9 #494be9 #860b3b #860b3b "
      "#85c323 #85c323 #6ddedd #6ddedd #3d888c "
      "#3d888c #d5956d #d5956d #378307 #378307 "
      "#390872 #390872 #8463ff #8463ff #24f0c6 "
      "#24f0c6 #d1b100 #d1b100 #02fc73 #02fc73 "
      "#90ffa8 #90ffa8 #01c6fc #01c6fc #fd1017 "
      "#fd1017 #4407f2 #4407f2 #9b4450 #9b4450 "
      "#03b24b #03b24b #a0428e #a0428e #02bf89 "
      "#02bf89 #4d96ff #4d96ff #79490c #79490c "
      "#461ab6 #461ab6 #43d344 #43d344 #b06dc9 "
      "#b06dc9 #df4e04 #df4e04 #83d16f #83d16f "
      "#04f025 #04f025 #a2fee4 #a2fee4 #e80153 "
      "#e80153 #ffa6f8 #ffa6f8 #96f718 #96f718 "
      "#5e83c0 #5e83c0 #eb02f9 #eb02f9 #bf0005 "
      "#bf0005 #cfa736 #cfa736 #0a7fdf #0a7fdf "
      "#f685a0 #f685a0 #000a7a #000a7a #e12ba0 "
      "#e12ba0 #046372 #046372 #d1eb91 #d1eb91 "
      "#740377 #740377 #39d6fc #39d6fc #708e1f "
      "#708e1f #acb0fd #acb0fd #fd52fa #fd52fa "
      "#01840a #01840a #0626d6 #0626d6 #5c0a08 "
      "#5c0a08 #e3f92f #e3f92f #49ff00 #49ff00 "
      "#3ed78e #3ed78e #872cde #872cde #df5146 "
      "#df5146 "
};

static char ROI_64_CMD[] = {  
      "ROI_i64 "
      "#c636f6 #05b7c2 #ac3d02 #0d7e3d #534fb4 "
      "#ac7119 #ab0a85 #0667a5 #17b80f #494be9 "
      "#860b3b #85c323 #6ddedd #3d888c #d5956d "
      "#378307 #390872 #8463ff #24f0c6 #d1b100 "
      "#02fc73 #90ffa8 #01c6fc #fd1017 #4407f2 "
      "#9b4450 #03b24b #a0428e #02bf89 #4d96ff "
      "#79490c #461ab6 #43d344 #b06dc9 #df4e04 "
      "#83d16f #04f025 #a2fee4 #e80153 #ffa6f8 "
      "#96f718 #5e83c0 #eb02f9 #bf0005 #cfa736 "
      "#0a7fdf #f685a0 #000a7a #e12ba0 #046372 "
      "#d1eb91 #740377 #39d6fc #708e1f #acb0fd "
      "#fd52fa #01840a #0626d6 #5c0a08 #e3f92f "
      "#49ff00 #3ed78e #872cde #df5146 "
};
static char ROI_64_256_CMD[] = {  
      "ROI_i64 "
      "#c636f6 #c636f6 #c636f6 #c636f6 #05b7c2 "
      "#05b7c2 #05b7c2 #05b7c2 #ac3d02 #ac3d02 "
      "#ac3d02 #ac3d02 #0d7e3d #0d7e3d #0d7e3d "
      "#0d7e3d #534fb4 #534fb4 #534fb4 #534fb4 "
      "#ac7119 #ac7119 #ac7119 #ac7119 #ab0a85 "
      "#ab0a85 #ab0a85 #ab0a85 #0667a5 #0667a5 "
      "#0667a5 #0667a5 #17b80f #17b80f #17b80f "
      "#17b80f #494be9 #494be9 #494be9 #494be9 "
      "#860b3b #860b3b #860b3b #860b3b #85c323 "
      "#85c323 #85c323 #85c323 #6ddedd #6ddedd "
      "#6ddedd #6ddedd #3d888c #3d888c #3d888c "
      "#3d888c #d5956d #d5956d #d5956d #d5956d "
      "#378307 #378307 #378307 #378307 #390872 "
      "#390872 #390872 #390872 #8463ff #8463ff "
      "#8463ff #8463ff #24f0c6 #24f0c6 #24f0c6 "
      "#24f0c6 #d1b100 #d1b100 #d1b100 #d1b100 "
      "#02fc73 #02fc73 #02fc73 #02fc73 #90ffa8 "
      "#90ffa8 #90ffa8 #90ffa8 #01c6fc #01c6fc "
      "#01c6fc #01c6fc #fd1017 #fd1017 #fd1017 "
      "#fd1017 #4407f2 #4407f2 #4407f2 #4407f2 "
      "#9b4450 #9b4450 #9b4450 #9b4450 #03b24b "
      "#03b24b #03b24b #03b24b #a0428e #a0428e "
      "#a0428e #a0428e #02bf89 #02bf89 #02bf89 "
      "#02bf89 #4d96ff #4d96ff #4d96ff #4d96ff "
      "#79490c #79490c #79490c #79490c #461ab6 "
      "#461ab6 #461ab6 #461ab6 #43d344 #43d344 "
      "#43d344 #43d344 #b06dc9 #b06dc9 #b06dc9 "
      "#b06dc9 #df4e04 #df4e04 #df4e04 #df4e04 "
      "#83d16f #83d16f #83d16f #83d16f #04f025 "
      "#04f025 #04f025 #04f025 #a2fee4 #a2fee4 "
      "#a2fee4 #a2fee4 #e80153 #e80153 #e80153 "
      "#e80153 #ffa6f8 #ffa6f8 #ffa6f8 #ffa6f8 "
      "#96f718 #96f718 #96f718 #96f718 #5e83c0 "
      "#5e83c0 #5e83c0 #5e83c0 #eb02f9 #eb02f9 "
      "#eb02f9 #eb02f9 #bf0005 #bf0005 #bf0005 "
      "#bf0005 #cfa736 #cfa736 #cfa736 #cfa736 "
      "#0a7fdf #0a7fdf #0a7fdf #0a7fdf #f685a0 "
      "#f685a0 #f685a0 #f685a0 #000a7a #000a7a "
      "#000a7a #000a7a #e12ba0 #e12ba0 #e12ba0 "
      "#e12ba0 #046372 #046372 #046372 #046372 "
      "#d1eb91 #d1eb91 #d1eb91 #d1eb91 #740377 "
      "#740377 #740377 #740377 #39d6fc #39d6fc "
      "#39d6fc #39d6fc #708e1f #708e1f #708e1f "
      "#708e1f #acb0fd #acb0fd #acb0fd #acb0fd "
      "#fd52fa #fd52fa #fd52fa #fd52fa #01840a "
      "#01840a #01840a #01840a #0626d6 #0626d6 "
      "#0626d6 #0626d6 #5c0a08 #5c0a08 #5c0a08 "
      "#5c0a08 #e3f92f #e3f92f #e3f92f #e3f92f "
      "#49ff00 #49ff00 #49ff00 #49ff00 #3ed78e "
      "#3ed78e #3ed78e #3ed78e #872cde #872cde "
      "#872cde #872cde #df5146 #df5146 #df5146 "
      "#df5146 "
};

static char ROI_32_CMD[] = {  
      "ROI_i32 "
      "#43d344 #b06dc9 #df4e04 #83d16f #04f025 "
      "#a2fee4 #e80153 #ffa6f8 #96f718 #5e83c0 "
      "#eb02f9 #bf0005 #cfa736 #0a7fdf #f685a0 "
      "#000a7a #e12ba0 #046372 #d1eb91 #740377 "
      "#39d6fc #708e1f #acb0fd #fd52fa #01840a "
      "#0626d6 #5c0a08 #e3f92f #49ff00 #3ed78e "
      "#872cde #df5146 "
};

static char ROI_32_256_CMD[] = {  
      "ROI_i32 "
      "#43d344 #43d344 #43d344 #43d344 #43d344 "
      "#43d344 #43d344 #43d344 #b06dc9 #b06dc9 "
      "#b06dc9 #b06dc9 #b06dc9 #b06dc9 #b06dc9 "
      "#b06dc9 #df4e04 #df4e04 #df4e04 #df4e04 "
      "#df4e04 #df4e04 #df4e04 #df4e04 #83d16f "
      "#83d16f #83d16f #83d16f #83d16f #83d16f "
      "#83d16f #83d16f #04f025 #04f025 #04f025 "
      "#04f025 #04f025 #04f025 #04f025 #04f025 "
      "#a2fee4 #a2fee4 #a2fee4 #a2fee4 #a2fee4 "
      "#a2fee4 #a2fee4 #a2fee4 #e80153 #e80153 "
      "#e80153 #e80153 #e80153 #e80153 #e80153 "
      "#e80153 #ffa6f8 #ffa6f8 #ffa6f8 #ffa6f8 "
      "#ffa6f8 #ffa6f8 #ffa6f8 #ffa6f8 #96f718 "
      "#96f718 #96f718 #96f718 #96f718 #96f718 "
      "#96f718 #96f718 #5e83c0 #5e83c0 #5e83c0 "
      "#5e83c0 #5e83c0 #5e83c0 #5e83c0 #5e83c0 "
      "#eb02f9 #eb02f9 #eb02f9 #eb02f9 #eb02f9 "
      "#eb02f9 #eb02f9 #eb02f9 #bf0005 #bf0005 "
      "#bf0005 #bf0005 #bf0005 #bf0005 #bf0005 "
      "#bf0005 #cfa736 #cfa736 #cfa736 #cfa736 "
      "#cfa736 #cfa736 #cfa736 #cfa736 #0a7fdf "
      "#0a7fdf #0a7fdf #0a7fdf #0a7fdf #0a7fdf "
      "#0a7fdf #0a7fdf #f685a0 #f685a0 #f685a0 "
      "#f685a0 #f685a0 #f685a0 #f685a0 #f685a0 "
      "#000a7a #000a7a #000a7a #000a7a #000a7a "
      "#000a7a #000a7a #000a7a #e12ba0 #e12ba0 "
      "#e12ba0 #e12ba0 #e12ba0 #e12ba0 #e12ba0 "
      "#e12ba0 #046372 #046372 #046372 #046372 "
      "#046372 #046372 #046372 #046372 #d1eb91 "
      "#d1eb91 #d1eb91 #d1eb91 #d1eb91 #d1eb91 "
      "#d1eb91 #d1eb91 #740377 #740377 #740377 "
      "#740377 #740377 #740377 #740377 #740377 "
      "#39d6fc #39d6fc #39d6fc #39d6fc #39d6fc "
      "#39d6fc #39d6fc #39d6fc #708e1f #708e1f "
      "#708e1f #708e1f #708e1f #708e1f #708e1f "
      "#708e1f #acb0fd #acb0fd #acb0fd #acb0fd "
      "#acb0fd #acb0fd #acb0fd #acb0fd #fd52fa "
      "#fd52fa #fd52fa #fd52fa #fd52fa #fd52fa "
      "#fd52fa #fd52fa #01840a #01840a #01840a "
      "#01840a #01840a #01840a #01840a #01840a "
      "#0626d6 #0626d6 #0626d6 #0626d6 #0626d6 "
      "#0626d6 #0626d6 #0626d6 #5c0a08 #5c0a08 "
      "#5c0a08 #5c0a08 #5c0a08 #5c0a08 #5c0a08 "
      "#5c0a08 #e3f92f #e3f92f #e3f92f #e3f92f "
      "#e3f92f #e3f92f #e3f92f #e3f92f #49ff00 "
      "#49ff00 #49ff00 #49ff00 #49ff00 #49ff00 "
      "#49ff00 #49ff00 #3ed78e #3ed78e #3ed78e "
      "#3ed78e #3ed78e #3ed78e #3ed78e #3ed78e "
      "#872cde #872cde #872cde #872cde #872cde "
      "#872cde #872cde #872cde #df5146 #df5146 "
      "#df5146 #df5146 #df5146 #df5146 #df5146 "
      "#df5146 "
};

/* Some maps for color blindness
Thanks to Vince Hradil who created them
based on http://bsp.pdx.edu/Publications/2006/SPM_McNames.pdf
*/
static char CB_CS_35[] = {  
      "cb_spiral35  "
      "#c776ee #c776ee #c776ee #be75f1 "
      "#be75f1 #b574f5 #b574f5 #ac75f8 "
      "#ac75f8 #a276fb #a276fb #9878fd "
      "#9878fd #9878fd #8d7bfe #8d7bfe "
      "#837eff #837eff #7983ff #7983ff "
      "#6f88fe #6f88fe #658efc #658efc "
      "#658efc #5b94f9 #5b94f9 #529bf5 "
      "#529bf5 #4aa2f0 #4aa2f0 #42aaea "
      "#42aaea #3bb2e3 #3bb2e3 #3bb2e3 "
      "#34badb #34badb #2fc2d3 #2fc2d3 "
      "#2bcac9 #2bcac9 #27d2be #27d2be "
      "#25dab3 #25dab3 #24e1a7 #24e1a7 "
      "#24e1a7 #24e79a #24e79a #26ed8d "
      "#26ed8d #28f27f #28f27f #2cf672 "
      "#2cf672 #31f964 #31f964 #31f964 "
      "#37fa56 #37fa56 #3ffa49 #3ffa49 "
      "#47f83d #47f83d #50f431 #50f431 "
      "#5aef27 #5aef27 #5aef27 #64e81e "
      "#64e81e #6de016 #6de016 #77d70f "
      "#77d70f #80cd0a #80cd0a #89c306 "
      "#89c306 #89c306 #91b803 #91b803 "
      "#98ac01 #98ac01 #9fa000 #9fa000 "
      "#a49401 #a49401 #a98802 #a98802 "
      "#ad7c04 #ad7c04 #ad7c04 #b07007 "
      "#b07007 #b2640b #b2640b #b35810 "
      "#b35810 #b24d15 #b24d15 #b1431a "
      "#b1431a #b1431a #af3920 #af3920 "
      "#ac3026 #ac3026 #a8282c #a8282c "
      "#a42033 #a42033 #9e1939 #9e1939 "
      "#9e1939 #98133f #98133f #910e45 "
      "#910e45 #8a0a4a #8a0a4a #830650 "
      "#830650 #7b0354 #7b0354 #7b0354 "
}; 

static char CB_CS[] = {  
      "cb_spiral "
      "#ffffff #fdfffc #fafff9 #f8fff5 "
      "#f6fff1 #f5feed #f4fde9 #f4fce4 "
      "#f4fbe0 #f4f9db #f4f6d7 #f5f4d3 "
      "#f6f0cf #f7edcc #f9e8c9 #fae4c6 "
      "#fbdfc4 #fdd9c2 #fed4c0 #ffcec0 "
      "#ffc7bf #ffc1bf #ffbac0 #ffb3c2 "
      "#fdacc4 #fca6c6 #f99fc9 #f799cc "
      "#f393d0 #ef8dd4 #ea88d8 #e483dc "
      "#de7fe0 #d77be5 #cf78e9 #c776ee "
      "#be75f1 #b574f5 #ac75f8 #a276fb "
      "#9878fd #8d7bfe #837eff #7983ff "
      "#6f88fe #658efc #5b94f9 #529bf5 "
      "#4aa2f0 #42aaea #3bb2e3 #34badb "
      "#2fc2d3 #2bcac9 #27d2be #25dab3 "
      "#24e1a7 #24e79a #26ed8d #28f27f "
      "#2cf672 #31f964 #37fa56 #3ffa49 "
      "#47f83d #50f431 #5aef27 #64e81e "
      "#6de016 #77d70f #80cd0a #89c306 "
      "#91b803 #98ac01 #9fa000 #a49401 "
      "#a98802 #ad7c04 #b07007 #b2640b "
      "#b35810 #b24d15 #b1431a #af3920 "
      "#ac3026 #a8282c #a42033 #9e1939 "
      "#98133f #910e45 #8a0a4a #830650 "
      "#7b0354 #720158 #6a005c #62005f "
      "#590061 #510163 #480264 #400464 "
      "#390663 #320862 #2b0a61 #240d5e "
      "#1e105b #191358 #141554 #101850 "
      "#0c1a4b #091c46 #061e41 #041f3c "
      "#022036 #012131 #00212c #002127 "
      "#002022 #001f1d #001d18 #001b14 "
      "#001810 #01160c #011209 #010f07 "
      "#010b04 #010702 #000401 #010101 "
};  /* changed last index to non-zero - not transparent */

/* regular gray from white to black */
static char GRAY_CS[] = {
   "gray_scale "
   "#ffffff #010101 "
};

/* mirrored gray for +/- values */
static char GRAY_CIRCLE_CS[] = {
   "gray_circle "
   "#ffffff #010101 #ffffff "
};
/* mirrored and inverted gray for +/- values */
static char GRAY_INV_CIRCLE_CS[] = {
   "inverted_gray_circle "
   "#010101 #ffffff #010101 "
};

/* amber monochrome from bright orange to black */
static char AMBER_CS[] = {
   "amber_monochrome "
   "#ffbf00 #010100 "
};

/* mirrored amber for +/- values */
static char AMBER_CIRCLE_CS[] = {
   "amber_circle "
   "#ffbf00 #010100 #ffbf00 "
};

/* mirrored and inverted amber for +/- values */
static char AMBER_INV_CIRCLE_CS[] = {
   "inverted_amber_circle "
   "#010100 #ffbf00 #010100 "
};

/* mirrored and inverted amber for +/- values */
static char AMBER_REDTOP_BLUEBOT_CS[] = {
   "amber_redtop_bluebot "
" #ff0000 "
" #febe00 #fdbd00 #fcbd00 #fbbc00 "
" #fabb00 #f9ba00 #f8ba00 #f7b900 "
" #f6b800 #f5b700 #f4b700 #f3b600 "
" #f2b500 #f1b400 #f0b400 #efb300 "
" #eeb200 #edb100 #ecb100 #ebb000 "
" #eaaf00 #e9ae00 #e8ae00 #e7ad00 "
" #e6ac00 #e5ab00 #e4ab00 #e3aa00 "
" #e2a900 #e1a900 #e0a800 #dfa700 "
" #dea600 #dda600 #dca500 #dba400 "
" #daa300 #d9a300 #d8a200 #d7a100 "
" #d6a000 #d5a000 #d49f00 #d39e00 "
" #d29d00 #d19d00 #d09c00 #cf9b00 "
" #ce9a00 #cd9a00 #cc9900 #cb9800 "
" #ca9700 #c99700 #c89600 #c79500 "
" #c69400 #c59400 #c49300 #c39200 "
" #c29200 #c19100 #c09000 #bf8f00 "
" #bf8f00 #be8e00 #bd8d00 #bc8c00 "
" #bb8c00 #ba8b00 #b98a00 #b88900 "
" #b78900 #b68800 #b58700 #b48600 "
" #b38600 #b28500 #b18400 #b08300 "
" #af8300 #ae8200 #ad8100 #ac8000 "
" #ab8000 #aa7f00 #a97e00 #a87e00 "
" #a77d00 #a67c00 #a57b00 #a47b00 "
" #a37a00 #a27900 #a17800 #a07800 "
" #9f7700 #9e7600 #9d7500 #9c7500 "
" #9b7400 #9a7300 #997200 #987200 "
" #977100 #967000 #956f00 #946f00 "
" #936e00 #926d00 #916c00 #906c00 "
" #8f6b00 #8e6a00 #8d6a00 #8c6900 "
" #8b6800 #8a6700 #896700 #886600 "
" #876500 #866400 #856400 #846300 "
" #836200 #826100 #816100 #806000 "
" #7f5f00 #7e5e00 #7d5e00 #7c5d00 "
" #7b5c00 #7a5b00 #795b00 #785a00 "
" #775900 #765800 #755800 #745700 "
" #735600 #725500 #715500 #705400 "
" #6f5300 #6e5300 #6d5200 #6c5100 #6b5000 "
" #6a5000 #694f00 #684e00 #674d00 #664d00 "
" #654c00 #644b00 #634a00 #624a00 #614900 "
" #604800 #5f4700 #5e4700 #5d4600 #5c4500 "
" #5b4400 #5a4400 #594300 #584200 #574100 "
" #564100 #554000 #543f00 #533f00 #523e00 "
" #513d00 #503c00 #4f3c00 #4e3b00 #4d3a00 "
" #4c3900 #4b3900 #4a3800 #493700 #483600 "
" #473600 #463500 #453400 #443300 #433300 "
" #423200 #413100 #403000 #403000 #3f2f00 "
" #3e2e00 #3d2d00 #3c2d00 #3b2c00 #3a2b00 "
" #392b00 #382a00 #372900 #362800 #352800 "
" #342700 #332600 #322500 #312500 #302400 "
" #2f2300 #2e2200 #2d2200 #2c2100 #2b2000 "
" #2a1f00 #291f00 #281e00 #271d00 #261c00 "
" #251c00 #241b00 #231a00 #221900 #211900 "
" #201800 #1f1700 #1e1600 #1d1600 #1c1500 "
" #1b1400 #1a1400 #191300 #181200 #171100 "
" #161100 #151000 #140f00 #130e00 #120e00 "
" #110d00 #100c00 #0f0b00 #0e0b00 #0d0a00 "
" #0c0900 #0b0800 #0a0800 #090700 #080600 "
" #070500 #060500 #050400 #040300 "
" #0000ff "
};

/* green monochrome from bright green to black */
static char GREEN_CS[] = {
   "green_monochrome "
   "#00ff00 #000100 "
};

/* blue monochrome from bright blue to black  - really "azure" */
static char BLUE_CS[] = {
   "blue_monochrome "
   "#007fff #000001 "
};

/* red monochrome from bright red to black */
static char RED_CS[] = {
   "red_monochrome "
   "#ff0000 #010000 "
};

/* amber variant for @AddEdge */
static char ADD_EDGE[] = {                /* generated with: MakeColorMap -fn  */
   "Add_Edge "                            /*    Fiducials_Ncol -ahc Add_Edge   */
   "#00FFFF #66FF00 #00FF00 #660000 "     /*    -flipud  */
   "#FF0000 #FFBF00 #FEBE00 #FDBD00 "     /* with Fiducials_Ncol containing */
   "#FBBD00 #FABC00 #F9BB00 #F8BA00 "     /* 0.4860    0.8913    0.7621   0 */
   "#F7B900 #F5B800 #F4B700 #F3B600 "     /* 0.7   0     0.7   1 */
   "#F2B500 #F0B400 #EFB400 #EEB300 "     /* 0.4514    0.0439    0.0272 2 */
   "#EDB200 #ECB100 #EAB000 #E9AF00 "     /* 0.0093    0.9400    0.5966   3 */
   "#E8AE00 #E7AD00 #E6AC00 #E4AB00 "     /* 0.9810    0.0697    0.0450 4  */
   "#E3AB00 #E2AA00 #E1A900 #DFA800 "     /* 0.13     0.10  0.0   5  */
   "#DEA700 #DDA600 #DCA500 #DBA400 "     /* 0.42     0.32  0     128 */
   "#D9A300 #D8A200 #D7A200 #D6A100 "     /* 1     0.75  0     250 */
   "#D5A000 #D39F00 #D29E00 #D19D00 "     /* 1     0     0     251 */
   "#D09C00 #CF9B00 #CD9A00 #CC9A00 "     /* 0.0   0.0   0.4     252 */
   "#CB9900 #CA9800 #C89700 #C79600 "     /* 0     1     0     253 */
   "#C69500 #C59400 #C49300 #C29200 "     /* 0.4   1     0     254 */
   "#C19100 #C09100 #BF9000 #BE8F00 "     /* 0     1     1     255  */
   "#BC8E00 #BB8D00 #BA8C00 #B98B00 "
   "#B78A00 #B68900 #B58800 #B48800 "
   "#B38700 #B18600 #B08500 #AF8400 "
   "#AE8300 #AD8200 #AB8100 #AA8000 "
   "#A97F00 #A87F00 #A77E00 #A57D00 "
   "#A47C00 #A37B00 #A27A00 #A07900 "
   "#9F7800 #9E7700 #9D7600 #9C7600 "
   "#9A7500 #997400 #987300 #977200 "
   "#967100 #947000 #936F00 #926E00 "
   "#916D00 #8F6D00 #8E6C00 #8D6B00 "
   "#8C6A00 #8B6900 #896800 #886700 "
   "#876600 #866500 #856400 #836400 "
   "#826300 #816200 #806100 #7E6000 "
   "#7D5F00 #7C5E00 #7B5D00 #7A5C00 "
   "#785B00 #775B00 #765A00 #755900 "
   "#745800 #725700 #715600 #705500 "
   "#6F5400 #6E5300 #6C5200 #6B5200 "
   "#6A5100 #6A5100 #695000 #695000 "
   "#684F00 #674F00 #674E00 #664E00 "
   "#664D00 #654D00 #644D00 #644C00 "
   "#634C00 #634B00 #624B00 #614A00 "
   "#614A00 #604900 #604900 #5F4800 "
   "#5E4800 #5E4800 #5D4700 #5D4700 "
   "#5C4600 #5B4600 #5B4500 #5A4500 "
   "#5A4400 #594400 #584300 #584300 "
   "#574300 #574200 #564200 #554100 "
   "#554100 #544000 #544000 #533F00 "
   "#523F00 #523E00 #513E00 #513E00 "
   "#503D00 #4F3D00 #4F3C00 #4E3C00 "
   "#4E3B00 #4D3B00 #4C3A00 #4C3A00 "
   "#4B3900 #4B3900 #4A3900 #493800 "
   "#493800 #483700 #483700 #473600 "
   "#463600 #463500 #453500 #453400 "
   "#443400 #433300 #433300 #423300 "
   "#423200 #413200 #403100 #403100 "
   "#3F3000 #3F3000 #3E2F00 #3D2F00 "
   "#3D2E00 #3C2E00 #3C2E00 #3B2D00 "
   "#3A2D00 #3A2C00 #392C00 #392B00 "
   "#382B00 #372A00 #372A00 #362900 "
   "#362900 #352900 #342800 #342800 "
   "#332700 #332700 #322600 #312600 "
   "#312500 #302500 #302400 #2F2400 "
   "#2E2400 #2E2300 #2D2300 #2D2200 "
   "#2C2200 #2B2100 #2B2100 #2A2000 "
   "#2A2000 #291F00 #281F00 #281F00 "
   "#271E00 #271E00 #261D00 #251D00 "
   "#251C00 #241C00 #241B00 #231B00 "
   "#221A00 #221A00 #211A00 #FA120B "
   "#02F098 #730B07 #B200B2 #7CE3C2 "
};

/* FreeSurfer colormap from 0 to 255
Created from FreeSurferColorLUT.txt 
this way:
MakeColorMap   -fscolut 0 255 \
               -ahc FreeSurfer_255 \
               -flipud > fs_pal.pal
Open fs_pal.pal, remove the zeroth color 
   (all 0 #000000 ) from the bottom
Add _CMD (indicating direct color
mapping needed )to var name and add 
  entry in pbar.c
*/
static char FREESURFER_SEG_255_CMD[]={
   "FreeSurfer_Seg_i255 "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #C596FA #C53AFA #CD3F4E "
   "#00E200 #68FFFF #808080 #FFCC66 "
   "#8020FF #800000 #791188 #CC99CC "
   "#80FF80 #20C8FF #C4A080 #008000 "
   "#8080FF #FF0000 #0000FF #400040 "
   "#FFFF00 #FF8080 #FFCC99 #003280 "
   "#806040 #007E4B #80C4A4 #0064FF "
   "#C4C400 #FFA4A4 #00C4FF #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #EE3B3B #8B795E #EEEED1 "
   "#CDCD00 #FF0000 #E0E0E0 #8B795E "
   "#4682B5 #4682B4 #EFA0DF #34D1E2 "
   "#FFFFFE #DDE244 #8B8B8B #8604A0 "
   "#418714 #418714 #152784 #152784 "
   "#483D8B #FF0000 #EEAEEE #DD27C8 "
   "#EE3B3B #9313AD #1E90FF #228B22 "
   "#1AED39 #85CBE5 #ADFF2F #00008B "
   "#EE0000 #4AFF4A #C8C8C8 #EEEED1 "
   "#CDB38B #FF1493 #7C8CB3 #7C90B2 "
   "#7C8FB2 #7C8EB2 #7C8DB2 #7F8CB2 "
   "#7E8CB2 #7D8CB2 #7C8CB2 #7C8CB3 "
   "#7C90B2 #7C8FB2 #7C8EB2 #7C8DB2 "
   "#7F8CB2 #7E8CB2 #7D8CB2 #7C8CB2 "
   "#8B8B8B #A020F0 #CD0A7D #CD0A7D "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #8B8B8B #8B8B8B #8B8B8B "
   "#8B8B8B #FAFF32 #EAA91E #FFDAB9 "
   "#FFDAB9 #A46CE2 #A46CE2 #A46CE2 "
   "#FF940A #FF940A #C846FF #781286 "
   "#781286 #7A8732 #7A8732 #78BE96 "
   "#7A8732 #4A9B3C #783E2B #4A9B3C "
   "#333287 #7A8732 #87324A #643264 "
   "#00C8DD #A020F0 #87CEEB #A52A2A "
   "#00FF7F #FFA500 #FFA500 #3C3AD2 "
   "#50C462 #67FFFF #DCD814 #0D30FF "
   "#EC0DB0 #7ABADC #00760E #00760E "
   "#E69422 #DCF8A4 #009400 #C43AFA "
   "#781286 #CD3E4E #00E100 #CD3E4E "
   "#7A8732 #4A9B3C #783E2B #4A9B3C "
   "#333287 #7A8732 #87324A #643264 "
   "#00C8C8 #A020F0 #87CEEB #A52A2A "
   "#00FF7F #FFA500 #FFA500 #3C3C3C "
   "#3C3AD2 #3C3AD2 #3C3AD2 #3C3AD2 "
   "#50C462 #67FFFF #DCD814 #779FB0 "
   "#2ACCA4 #CCB68E #0C30FF #EC0DB0 "
   "#7ABADC #00760E #00760E #E69422 "
   "#DCF8A4 #009400 #C43AFA #781286 "
   "#CD3E4E #F5F5F5 #CD3E4E "
};


#endif
