#define MCW_NXY   256
#define MCW_BLACK  -9         /* actually, green */
#define MCW_WHITE  -1         /* actually, white */

static int mcw_im_init = 0 ;  /* initialization flag */

int mcw_load() ;              /* prototype */

short mcw_im[MCW_NXY*MCW_NXY] ;  /* image array */

/*================================================================================*/

/* data and routine to create MCW logo from RLE data, courtesy of Gil Plotkin */

static short mcw_rle[] = {
 4980,8,9,8,228,14,4,13,222,37,217,14,3,25,211,17,3,27,206,21,
 2,30,201,21,4,33,194,25,3,38,186,25,2,2,3,2,5,8,2,24,
 183,21,6,2,3,3,4,7,7,21,182,18,6,5,5,2,2,12,6,18,
 181,16,5,9,9,15,6,15,181,13,5,13,8,18,6,13,180,10,5,17,
 8,20,6,10,180,8,5,21,8,21,7,6,179,6,4,26,8,23,4,6,
 179,38,7,32,179,24,5,9,8,2,7,23,178,20,8,10,2,1,5,5,
 7,20,178,17,6,15,2,2,5,8,6,17,177,14,7,16,4,3,4,11,
 6,14,177,10,8,16,7,3,4,15,6,11,176,7,8,19,8,1,5,17,
 8,7,176,5,7,21,14,22,5,6,175,34,14,33,175,25,6,3,3,2,
 9,3,6,24,175,21,9,4,3,3,7,6,7,22,174,18,6,10,3,3,
 5,12,7,18,174,14,7,13,4,2,1,19,7,15,173,11,8,16,7,23,
 7,11,173,7,9,20,7,25,7,8,173,6,6,24,8,28,5,7,172,38,
 7,39,172,27,4,8,8,5,5,27,172,23,8,9,8,4,10,22,171,20,
 7,15,7,10,7,19,171,17,6,19,2,1,5,13,6,17,170,13,7,22,
 1,3,4,16,7,13,170,10,7,21,5,4,3,20,6,10,169,6,9,24,
 6,2,4,23,7,6,169,38,13,37,168,38,12,38,168,27,6,4,3,3,
 7,5,5,28,168,23,10,4,3,3,5,7,10,23,167,20,9,9,4,2,
 2,16,8,19,167,17,8,14,7,20,8,16,166,13,8,18,7,23,9,12,
 166,10,8,22,7,26,8,9,166,6,8,27,7,28,7,7,165,7,4,32,
 8,40,165,45,6,41,164,29,6,11,6,5,6,29,164,24,11,13,4,5,
 11,24,164,20,10,11,5,3,3,9,12,19,163,16,10,15,7,2,3,15,
 11,14,163,12,10,19,11,21,11,10,162,9,9,23,2,3,6,25,10,7,
 162,6,8,27,2,4,4,31,5,7,161,42,5,48,161,43,5,48,160,44,
 6,46,160,45,6,45,160,46,6,44,159,26,12,11,4,7,12,25,159,22,
 18,11,1,5,19,22,158,18,24,14,24,18,158,14,30,10,30,14,158,10,
 35,8,36,9,204,6,251,4,252,3,794,24,153,47,9,47,169,34,4,49,
 197,14,247,5,1967,9,17,10,221,9,16,8,225,7,16,7,227,6,15,7,
 228,7,14,7,228,7,14,6,5,2,12,3,6,8,12,11,8,7,18,2,
 11,11,113,7,13,7,4,19,3,15,7,11,6,5,3,4,1,1,13,2,
 11,10,114,8,12,7,5,8,5,5,4,7,3,5,8,7,7,4,7,4,
 12,4,13,5,116,8,12,7,7,5,8,3,5,5,7,4,7,5,7,4,
 9,4,11,4,13,5,116,1,1,6,11,2,1,5,7,5,8,3,5,5,
 8,4,6,5,6,4,11,3,10,5,13,5,116,1,2,5,11,2,1,5,
 7,5,9,2,5,5,9,4,5,5,5,5,11,3,10,6,12,5,116,1,
 2,6,10,2,1,5,7,5,17,4,9,5,4,5,5,4,13,2,10,6,
 12,5,116,1,2,6,9,2,2,5,7,5,17,4,10,4,4,5,4,5,
 13,2,9,2,1,4,12,5,116,1,3,6,8,2,2,5,7,5,17,4,
 10,5,3,5,3,6,13,2,9,2,1,5,11,5,116,1,3,6,8,1,
 3,5,7,5,17,4,10,5,3,5,3,5,25,1,2,5,11,5,116,1,
 4,5,7,2,3,5,7,5,5,1,11,4,11,5,2,5,3,5,24,2,
 3,4,11,5,116,1,4,5,7,2,3,5,7,5,5,1,11,4,11,5,2,5,3,5,24,2,3,4,11,5,
 116,1,4,6,6,2,3,5,7,5,4,2,11,4,11,5,2,5,3,5,24,1,4,5,10,5,116,1,4,6,
 5,2,4,5,7,5,4,2,11,4,11,5,2,5,2,6,24,1,5,4,10,5,116,1,5,5,5,2,4,5,
 7,11,11,4,11,5,2,5,2,6,23,2,5,4,10,5,116,1,5,6,4,2,4,5,7,11,11,4,11,5,
 2,5,2,6,23,1,6,5,9,5,116,1,6,5,3,2,5,5,7,5,3,3,11,4,11,5,2,5,2,6,
 23,1,6,5,9,5,116,1,6,6,2,2,5,5,7,5,5,1,11,4,11,5,2,5,2,6,22,2,7,4,
 9,5,116,1,6,6,2,1,6,5,7,5,5,1,11,5,10,5,2,5,2,6,22,14,8,5,116,1,7,5,
 1,2,6,5,7,5,5,1,11,5,10,5,2,5,3,5,22,14,8,5,116,1,7,8,6,5,7,5,17,5,
 10,5,2,5,3,5,15,1,5,2,9,4,8,5,116,1,7,7,7,5,7,5,17,5,10,4,3,5,3,6,
 14,1,5,2,9,5,7,5,116,1,8,6,7,5,7,5,17,5,9,5,3,5,3,6,13,2,5,1,10,5,
 7,5,116,2,7,6,7,5,7,5,17,5,9,5,3,5,4,5,13,2,4,2,10,5,7,5,11,2,103,2,
 7,5,8,5,7,5,11,1,5,5,9,4,4,5,4,5,13,2,4,2,11,5,6,5,11,2,103,2,8,4,
 8,5,7,5,11,1,4,6,8,5,4,5,5,5,11,3,4,2,11,5,6,5,11,2,102,3,8,4,8,5,
 7,5,10,2,4,6,8,4,5,5,5,5,11,3,3,3,11,5,6,5,10,2,103,3,8,3,9,6,6,6,
 9,2,4,6,7,4,6,6,5,5,9,4,3,3,11,6,5,6,8,3,102,5,8,2,8,8,4,8,6,4,
 4,8,3,5,6,8,5,5,6,3,2,2,1,5,9,9,2,9,4,6,99,9,6,1,7,12,1,19,2,16,
 6,11,6,11,4,8,6,31,101,8,14,12,2,18,42,8,1187,3,249,9,5,1,239,7,2,5,1,2,238,5,
 8,5,237,5,10,4,236,5,12,3,235,5,13,3,14,3,84,6,127,5,15,2,10,10,8,10,11,11,11,19,
 9,10,3,1,3,18,99,6,15,2,9,4,4,5,6,9,13,9,13,18,7,5,6,5,4,17,99,6,16,1,
 8,3,8,4,6,7,16,5,17,5,8,3,6,4,9,4,5,6,8,2,98,6,17,1,6,4,10,4,6,5,
 17,5,17,5,8,3,5,4,11,3,6,5,8,2,98,6,24,4,11,4,5,5,17,5,17,5,9,2,4,5,
 12,2,6,5,9,1,98,6,23,4,12,4,6,4,17,5,18,4,9,2,4,4,13,2,6,5,9,1,98,6,
 22,5,13,4,5,4,17,5,18,4,14,5,14,1,6,5,107,6,23,4,14,5,4,4,17,5,18,4,14,5,
 21,5,107,6,22,5,14,5,4,4,17,5,18,4,13,6,21,5,5,1,101,6,22,5,14,5,4,4,17,5,
 18,4,5,2,6,6,21,5,5,1,101,6,22,5,14,6,3,4,17,5,18,4,5,2,6,5,22,5,4,2,
 101,6,21,6,15,5,3,4,17,5,18,4,4,3,6,5,22,5,4,2,101,6,21,6,15,5,3,4,17,5,
 18,4,4,3,6,5,22,5,3,3,101,6,21,5,16,5,3,4,17,5,18,5,1,5,5,6,22,11,101,6,
 21,5,16,5,3,4,17,5,18,11,5,6,22,11,101,6,21,5,16,5,3,4,17,5,18,4,2,5,5,6,
 22,5,3,3,101,6,21,5,16,5,3,4,17,5,18,4,4,3,5,6,22,5,4,2,101,6,19,1,1,5,
 16,5,3,4,18,4,18,4,5,2,5,6,10,10,2,5,4,2,101,7,18,1,1,6,15,5,3,4,18,4,
 18,4,5,1,7,5,10,9,3,5,5,1,102,6,17,2,1,6,14,6,3,4,18,4,18,4,13,5,12,6,
 4,5,108,6,17,2,2,5,14,5,4,4,18,4,18,4,13,5,13,4,5,5,108,6,17,2,2,5,14,5,
 4,4,18,4,18,4,13,6,12,4,5,5,109,6,16,2,2,5,14,5,4,4,12,1,5,4,12,1,5,4,
 14,5,12,4,5,5,11,1,97,6,15,3,3,5,13,4,5,4,12,1,5,4,12,1,5,4,11,1,2,5,
 12,4,5,5,11,1,98,5,15,3,3,5,12,5,5,4,11,2,4,5,11,2,5,4,11,1,3,5,11,4,
 5,5,10,2,98,6,13,4,4,4,12,4,6,4,11,2,4,5,11,2,5,5,9,2,3,5,10,6,4,5,
 10,2,99,6,11,5,5,4,10,4,7,5,9,3,4,5,10,3,4,6,9,2,4,5,9,5,4,6,9,3,
 100,6,9,6,6,4,8,4,7,6,8,4,4,6,8,4,4,7,6,4,5,5,7,4,6,8,6,4,101,6,
 7,3,3,1,7,4,6,4,6,20,2,20,2,19,6,5,4,4,7,19,102,13,15,4,2,4,7,42,2,8,
 6,6,8,9,133,9,20,4,84,3,2496,2,14,5,14,5,32,4,104,6,8,14,6,8,6,1,14,6,5,8,
 8,4,2,3,1,1,8,3,2,4,5,6,9,5,3,3,2,4,2,15,10,6,66,3,4,3,5,15,7,6,
 7,1,7,3,3,6,4,3,4,3,7,3,6,3,6,4,6,3,4,5,10,3,3,2,5,3,4,5,4,5,
 10,3,67,3,7,3,6,3,7,2,7,5,7,3,7,1,5,4,5,2,6,3,4,4,8,3,4,3,8,4,
 4,5,10,1,4,2,6,2,4,5,5,5,10,1,67,3,9,3,5,3,8,1,8,4,7,3,7,1,5,4,
 4,3,7,2,4,3,9,3,4,3,9,4,4,5,9,1,3,3,7,1,5,4,6,5,9,1,66,3,10,3,
 5,3,8,1,8,4,7,3,7,1,5,4,4,3,7,1,4,4,10,2,3,3,11,3,4,5,9,1,3,3,
 7,1,5,4,6,5,9,1,65,4,11,3,4,3,18,3,7,4,5,2,5,4,4,3,12,4,14,4,11,4,
 3,6,8,1,3,3,13,4,6,6,8,1,65,3,12,4,3,3,18,4,5,5,5,1,6,4,4,3,11,4,
 15,4,11,4,3,1,1,5,7,1,3,4,12,4,6,1,1,5,7,1,64,4,12,4,3,3,5,1,12,4,
 5,5,5,1,6,4,4,5,9,4,15,4,11,4,3,1,2,5,6,1,3,5,11,4,6,1,2,5,6,1,
 64,4,12,4,3,3,5,1,12,4,5,5,5,1,6,4,4,6,8,4,14,5,11,5,2,1,2,5,6,1,
 3,7,9,4,6,1,2,5,6,1,64,4,12,4,3,3,4,2,13,3,5,1,1,4,4,1,6,4,5,6,
 7,4,14,5,12,4,2,1,3,5,5,1,4,7,8,4,6,1,3,5,5,1,64,4,12,5,2,3,4,2,
 13,4,3,2,1,4,3,1,7,4,5,8,4,5,14,5,12,4,2,1,4,5,4,1,5,8,6,4,6,1,
 4,5,4,1,63,5,12,5,2,4,2,3,13,4,3,1,3,3,3,1,7,4,6,8,3,5,14,5,12,4,
 2,1,4,5,4,1,6,8,5,4,6,1,4,5,4,1,63,5,12,5,2,9,14,3,3,1,3,3,3,1,
 7,4,8,7,2,5,14,5,12,4,2,1,5,5,3,1,7,8,4,4,6,1,5,5,3,1,63,5,12,5,
 2,3,4,2,14,3,3,1,3,4,2,1,7,4,9,7,1,5,14,5,11,5,2,1,6,5,2,1,9,6,
 4,4,6,1,6,5,2,1,64,4,12,5,2,3,5,1,14,4,1,2,3,4,2,1,7,4,10,6,2,4,
 14,5,11,5,2,1,6,5,2,1,10,5,4,4,6,1,6,6,1,1,64,4,12,4,3,3,5,1,14,4,
 1,1,4,4,1,1,8,4,12,4,2,4,14,5,11,4,3,1,7,5,1,1,11,5,3,4,6,1,7,5,
 1,1,64,4,12,4,3,3,21,5,5,5,8,4,12,5,1,4,12,1,2,4,11,4,3,1,8,6,12,4,
 3,4,6,1,8,6,64,4,12,4,3,3,21,5,5,5,8,4,3,1,9,4,1,5,10,2,2,4,11,4,
 3,1,9,5,3,1,8,4,3,4,6,1,8,6,65,4,10,4,4,3,21,5,5,5,8,4,3,2,8,4,
 2,4,10,2,3,3,11,3,4,1,9,5,3,1,8,4,3,4,6,1,9,5,65,4,10,4,4,3,21,4,
 6,4,9,4,3,2,8,3,3,4,10,2,3,4,9,4,4,1,10,4,3,1,8,4,3,4,6,1,10,4,
 66,3,10,3,5,3,22,3,7,3,9,4,3,3,7,3,4,4,8,3,4,3,9,3,4,2,11,3,3,2,
 7,3,4,4,5,2,10,4,67,3,8,3,6,3,22,3,7,3,9,4,3,3,6,3,6,4,7,3,5,3,
 7,3,5,2,11,3,3,3,6,2,4,5,5,3,10,3,68,3,6,3,6,5,21,2,8,3,8,6,2,4,
 5,2,8,4,4,2,1,2,6,4,4,3,5,5,10,2,3,4,4,3,4,6,3,5,10,2,69,3,4,3,
 6,8,20,1,8,2,8,10,1,8,10,8,12,7,6,6,11,1,6,7,3,16,11,1,70,7,36,1,10159
} ;

int mcw_load()
{
   int ii , nc , ntot , nrle ;
   short mm ;

   if( mcw_im_init ) return 0 ;

   nrle = ntot = 0 ;
   mm   = MCW_BLACK ;

   while( ntot < MCW_NXY * MCW_NXY ){

      nc = mcw_rle[nrle++] ;
      for( ii=0 ; ii < nc ; ii++,ntot++ ) mcw_im[ntot] = mm ;
      if( mm == MCW_WHITE ) mm = MCW_BLACK ;
      else                  mm = MCW_WHITE ;
   }

   mcw_im_init = 1 ;
   return 1 ;

}
