---
myst:
  html_meta:
    keywords: LaTeX et loisirs,jeux d'échecs,partie d'échecs,échiquier
---
# Comment écrire et représenter des parties d'échecs ?

## Du côté de LaTeX

### Avec <ctanpkg:chessboard> et <ctanpkg:xskak>

Le package LaTeX <ctanpkg:chessboard>, développé par Ulrike Fischer, est sans
doute le package d’échec le plus abouti. Il s’utilise le plus souvent avec
<ctanpkg:xskak>, package de la même autrice, qui est une extension de
<ctanpkg:skak> (voir section suivante).

<ctanpkg:chessboard> fournit la commande `\chessboard[<clé=liste de valeurs>]` permettant
de composer des plateaux et des positions d’échec. Il est extrêmement puissant
et permet de personnaliser l’apparence, d’annoter la position, etc. 
On peut construire les positions pièces par pièces ou bien lire le format FEN.
Enfin, si on utilise <ctanpkg:chessboard> conjointement avec <ctanpkg:xskak> 
(voir ci-dessous) on pourra représenter les positions issues d’une partie
décrite avec le format PGN. 

Un exemple valant souvent bien plus qu’un long discours, voilà comment
représenter la dernière position d’une partie décrite à l’aide du format PGN. 
```
\documentclass{article}
\usepackage{xskak}
\usepackage{chessboard}

\begin{document}
\newchessgame
\mainline{1. e4 e5 2. Nf3 Nc6 3. Bb5 a6} % commande fournie par skak
\chessboard
\end{document}
```

Grâce à <ctanpkg:xskak>, on peut aussi écrire, dans le texte courant, les coups. 
Les documentations de ces deux packages sont très fournis, et permettent de
trouver à coup sûr le code pour faire ce que l’on souhaite. 

```
\documentclass{article}
\usepackage{xskak}
\usepackage{chessboard}

\begin{document}
\newchessgame[id=A,white=John White,
black=Jack Black, result=1--0]
\mainline{1.e4 e5 2.Bc4 Nc6 3. Qh5 Nf6 4.Qxf7#}


\newchessgame % a game between A and the board
\mainline{1.e4}

\setchessboard{shortenend=5pt,color=red}%
\chessboard[lastmoveid=A,setfen=\xskakget{nextfen},
pgfstyle=border,color=red,
markfields={\xskakget{moveto},\xskakget{movefrom}},
pgfstyle=straightmove,
markmove=\xskakget{movefrom}-\xskakget{moveto}]
\end{document}
```


### Les pionniers 

#### <ctanpkg:skak> 

L'extension <ctanpkg:skak> a été un pionnier sur la composition des plateaux
d’échec et des positions. Ce package a aussi fourni une fonte d’échecs (qui a été
étendue avec <ctanpkg:skaknew>). 

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a5paper]{geometry}
\usepackage{skak}
\usepackage{babel}

\begin{document}
\begin{itemize}
\item Petit exercice d'entraînement : les blancs jouent et font mat en trois
  coups.  \fenboard{7k/4K1pp/7N/8/8/8/8/B7 w - - 0 1}
  \begin{center}
    \showboard
  \end{center}
  Vous ne voyez pas ? Voici la solution : \mainline{1. Bf6 gxf6 2. Kf8 f5
    3. Nf7\mate}
\item À vous de jouer maintenant !  Voici un autre problème où les blancs font
  mat en trois coups.  \fenboard{7B/8/8/8/8/N7/pp1K4/k7 w - - 0 1}
  \begin{center}
    \showinverseboard
  \end{center}
\end{itemize}
\end{document}
```

#### <ctanpkg:chess>

Une autre extension, <ctanpkg:chess>, est beaucoup plus ancienne et un peu moins
souple, mais permet globalement de faire la même chose que <ctanpkg:skak>

## Avec MetaPost

Depuis 2023, il est possible de dessiner des plateaux d’échecs et des positions
avec [MetaPost](/1_generalites/glossaire/metapost) et le package <ctanpkg:mpchess>. L’apparence des dessins se veut
moderne et largement inspiré de ce que propose l’excellent site web
[lichess.org](https://lichess.org/).

Là encore, ce package offre les outils classiques de représentation des parties
d’échec (format FEN, format PGN, annotations, couleurs, etc.).

Plusieurs ensembles de pièces et style de plateaux sont disponibles. Une fonte
OpenType restreinte aux pièces d’échecs a été créé pour l’occasion (pièces par
défaut).

Pour illustrer l’utilisation de ce package, nous allons l’utiliser avec LuaLaTeX
et le package <ctanpkg:luamplib>.

```
%!TEX engine=lualatex
\documentclass{article}
\usepackage{luamplib}

\begin{document}
\begin{mplibcode} % code MetaPost
input mpchess;
string pgnstr;
pgnstr:="1. e4 e5 2. Bc4 d6 3. Nf3 Bg4 4. Nc3 g6 5. Nxe5 Bxd1";
build_chessboards_from_pgn(pgnstr);
beginfig(0);
set_backboard_width(8cm);
set_white_player("Kermur de Legal");
set_black_player("Saint-Brie");
init_backboard;
draw backboard;
show_last_move(10);
draw_comment("?","d1");
color_square(0.3[green,black])("c4","c3","e5");
color_square(0.3[red,black])("e8");
draw chessboard_step(10);
draw_arrows(0.3[green,black])("e5|-f7","c3-|d5");
draw_arrows(0.3[red,black])("c4--f7");
endfig;
\end{mplibcode}
\end{document}
```
