---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, notes de bas de page, compteur, réinitialisation, 
              réinitialiser
---

# Comment réinitialiser le compteur de note de bas de page à chaque page ?

La solution intuitive revient ici à réinitialiser ce compteur à chaque fois 
que le numéro de page est incrémenté, en utilisant le 
[mécanisme interne](/2_programmation/syntaxe/compteurs/compteurs_maitres_et_esclaves) 
de LaTeX. Hélas, les endroits dans le texte où se produisent ces incrémentations 
sont peu prévisibles et arrivent même rarement en bas de page imprimée. 
Ce qui explique que les solutions naïves changeant le compteur de note 
de bas de page ne marchent souvent que par hasard.

De fait, réinitialiser ce compteur s'avère être une tâche complexe, 
nécessitant généralement des étiquettes. Dans la mesure où ce besoin peut être 
assez courant (par exemple lorsque les marqueurs de note sont des symboles 
souvent en petit nombre), quelques extensions proposent des solutions clé en main.


## Avec les extensions <ctanpkg:perpage> et [zref-perpage](ctanpkg:zref)

Les extensions <ctanpkg:perpage> et [zref-perpage](ctanpkg:zref) proposent 
un mécanisme général pour réinitialiser les compteurs à chaque page.
Elles peuvent donc à l'évidence être utilisées dans le cas présent. 
L'interface est très simple : `\MakePerPage{footnote}` pour <ctanpkg:perpage> 
ou `\zmakeperpage{footnote}` pour [zref-perpage](ctanpkg:zref). 
Si vous souhaitez réinitialiser les compteurs à une valeur autre que 1, 
vous pouvez utiliser : `\MakePerPage[2]{footnote}` pour <ctanpkg:perpage>) 
ou `\zmakeperpage[2]{footnote}` pour [zref-perpage](ctanpkg:zref).

L'extension <ctanpkg:perpage> est compacte tandis que l'extension 
[zref-perpage](ctanpkg:zref), en tant que "module" de l'extension <ctanpkg:zref>, 
est accompagnée des mécanismes de <ctanpkg:zref> pour améliorer 
les commandes `\label`, `\ref` et `\pageref` de LaTeX, ce qui offre 
de nombreuses autres possibilités.

Voici un exemple d'utilisation où on réinitialise la numérotation à la valeur 4 
en début de chaque page.  

``` 
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{perpage}        % Avec perpage
  %\usepackage{zref-perpage}  % Alternative avec zref-perpage

  \MakePerPage[4]{footnote}   % Avec perpage
  %\zmakeperpage[4]{footnote} % Alternative avec zref-perpage

\begin{document}
\section{Le début}
Voici donc que le texte amène à un premier commentaire\footnote{Guère 
utile} puis, de façon inopinée, à un second\footnote{Encore moins 
utile.}.

\newpage % Changement de page pour notre exemple
\section{La fin}
Le lecteur éclairé pourra sans doute se poser des 
questions\footnote{Pertinentes.} sur le texte même de cet exemple.
\end{document}
``` 


## Avec l'extension <ctanpkg:footmisc>

L'extension <ctanpkg:footmisc> propose de nombreux outils pour contrôler 
l'apparence des notes de bas de page et, parmi ces outils, l'option `perpage` 
qui répond à la question. Si vous avez d'autres modifications à faire 
sur les notes de bas de page, cette seule extension pourrait bien répondre 
à tous vos besoins.

Voici l'exemple précédent adapté pour <ctanpkg:footmisc> (avec des compteurs 
débutant à 1 à chaque page) :

``` 
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[perpage]{footmisc}       

\begin{document}
\section{Le début}
Voici donc que le texte amène à un premier commentaire\footnote{Guère 
utile} puis, de façon inopinée, à un second\footnote{Encore moins 
utile.}.

\newpage % Changement de page pour notre exemple
\section{La fin}
Le lecteur éclairé pourra sans doute se poser des 
questions\footnote{Pertinentes.} sur le texte même de cet exemple.
\end{document}
``` 


## Avec l'extension <ctanpkg:footnpag>

L'extension <ctanpkg:footnpag> répond aussi à la demande et ne traite 
d'ailleurs que ce point. Avec la concurrence de <ctanpkg:perpage>, 
il semble de moins en moins utile.

Voici l'exemple précédent adapté pour <ctanpkg:footnpag> (sans restitution, 
dysfonctionnelle sur cette FAQ).

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{footnpag}       

\begin{document}
\section{Le début}
Voici donc que le texte amène à un premier commentaire\footnote{Guère 
utile} puis, de façon inopinée, à un second\footnote{Encore moins 
utile.}.

\newpage % Changement de page pour notre exemple
\section{La fin}
Le lecteur éclairé pourra sans doute se poser des 
questions\footnote{Pertinentes.} sur le texte même de cet exemple.
\end{document}
``` 


## Avec l'extension <ctanpkg:bidi> 

L'extension <ctanpkg:bidi> (à partir de la version 34.4) dispose d'une option 
`perpagefootnote` qui vous permet de réinitialiser le compteur des notes de bas de page. 
Elle ne fonctionne toutefois qu'avec [XeTeX](/1_generalites/glossaire/xetex).

Par ailleurs, cette option n'est pas décrite dans la 
[documentation utilisateur](texdoc:bidi) de l'extension. 

Voici l'exemple adapté pour <ctanpkg:bidi>.

``` 
%!TEX engine=xelatex
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[perpagefootnote=on]{bidi}

\begin{document}
\section{Le début}
Voici donc que le texte amène à un premier commentaire\footnote{Guère 
utile} puis, de façon inopinée, à un second\footnote{Encore moins 
utile.}.

\newpage % Changement de page pour notre exemple
\section{La fin}
Le lecteur éclairé pourra sans doute se poser des 
questions\footnote{Pertinentes.} sur le texte même de cet exemple.
\end{document}
``` 

:::{sources}
[Footnotes numbered "per page"](faquk:FAQ-footnpp)
:::