#!/bin/bash

# To compile latex-via-exemplos

############
# functions
############

# print usage
function usage()
{
  #  if [[ "$#" - gt 1 ]]; then
  #    echo "clear(): Invalid number of argument"
  #    exit;
  #  fi
  echo "Usage:"
  echo "bash $0 <option> <option 2>"
  echo "without option: compile one sided document"
  echo "<option> == oneside: compile two sided document"
  echo "<option> == twoside: compile two sided document"
  echo "<option> == all: compile one sided and two sided documents"
  echo "<option> == auxonly: compile auxiliary files only"
  echo "<option 2> == keepaux: keep generated auxiliar pdf files"
  echo "<option> == usage: display usage only"
}

## clear auxiliar files
## If argument is "true", keep auxiliar pdf files
function clear()
{
  if [[ "$#" -gt 1 ]]; then
    echo "clear(): Invalid number of argument"
    exit;
  fi
  
  local keepaux=$1 # first argument
  if [[ "${keepaux}" != "" && "${keepaux,,}" != "true" && "${keepaux,,}" != "false" ]]; then
    echo "clear(): invalid parameter"
    exit;
  fi
   
  # basic auxiliar files
  rm *.aux
  rm *.bbl
  rm *.blg
  rm *.idx
  rm *.ilg
  rm *.ind
  rm *.log
  rm *.lol
  rm *.out
  rm *.synctex.gz
  rm *.tmp
  rm *.toc

  # more auxiliar files
  rm *.nav
  rm *.snm
  rm *.vrb

  # of beamer (produced by biblatex)
  rm *.bcf
  rm *.run.xml
      
  # of todo notes
  rm *.tdo

  # rm *.csv

  # remove automatic created auxiliar tex and txt files
  rm latex-via-exemplos-tabela.txt
  rm latex-via-exemplos-ans.tex
  rm latex-via-exemplos-twoside-ans.tex

  # rm latex-via-exemplos-*-exercise-body.tex

  # remove auxiliar pdf files
  if [[ "${keepaux,,}" != "true" ]]; then
    rm latex-via-exemplos-fig.pdf
    rm latex-via-exemplos-poster.pdf
    rm latex-via-exemplos-slides.pdf
    rm latex-via-exemplos-certificado.pdf
    rm latex-via-exemplos-cracha.pdf
    rm latex-via-exemplos-folder.pdf
    rm latex-via-exemplos-todonotes.pdf
  fi
} # clear()

#############
# main script
#############

# check parameters
# one parameters (all, twoside, or aux), or none of parameters
if [ "$#" -gt 2 ]; then
  echo "Illegal number of parameters"
  usage
  exit;
fi
  
if [ "$#" -gt 0 ]; then
  optarg="$1"
  optarg="${optarg,,}" # to lower case
  
  # check auxiliar parameter
  if [[ "${optarg}" == "keepaux" ]]; then
    optarg="$2"
    optarg="${optarg,,}" # to lower case  
    keepaux="true" 
  else if [ "$#" -eq 2 ]; then
    keepaux="$2"
    if [ "${keepaux,,}" != "keepaux" ]; then
      echo "Invalid seccond argument '${keepaux}'"
      usage
      exit    
    fi
    keepaux="true"
  fi fi

  # show usage
  if [[ "${optarg}" == "usage"  || "${optarg}" == "help" ]]; then
    usage
    exit
  fi
  
  # checking main parameter
  if [[ "${optarg}" != ""  && "${optarg}" != "oneside"  && "${optarg}" != "twoside" && "${optarg}" != "all" && "${optarg}" != "auxonly" ]]; then
    echo "Invalid option '${optarg}'"
    usage
    exit
  fi
fi

# compile auxiliar files
pdflatex latex-via-exemplos-fig
pdflatex latex-via-exemplos-poster
pdflatex latex-via-exemplos-slides
biber latex-via-exemplos-slides
pdflatex latex-via-exemplos-slides
pdflatex latex-via-exemplos-certificado
pdflatex latex-via-exemplos-cracha
pdflatex latex-via-exemplos-folder
pdflatex latex-via-exemplos-todonotes
pdflatex latex-via-exemplos-todonotes
    
# if auxiliar files only, clear and stop
if [[ "${optarg}" == "auxonly" ]]; then
  # keep auxiliar pdf files
  clear "true"
  exit
fi
    
# compile one sided document
if [[ "${optarg}" == "all" || "${optarg}" == "oneside" || "${optarg}" == "" ]]; then
  lualatex latex-via-exemplos
  bibtex latex-via-exemplos
  makeindex latex-via-exemplos
  lualatex latex-via-exemplos
  lualatex latex-via-exemplos
fi

# compile two sided document
if [[ "${optarg}" == "all" || "${optarg}" == "twosides" ]]; then
  lualatex latex-via-exemplos-twoside
  bibtex latex-via-exemplos-twoside
  makeindex latex-via-exemplos-twoside
  lualatex latex-via-exemplos-twoside
  lualatex latex-via-exemplos-twoside
fi

# clean up
clear $keepaux

#end

