/*
 * Fast index for tag data
 *
 * Copyright (C) 2005--2011  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <tests/test-utils.h>
#include <tagcoll/coll/fast.h>
#include <tagcoll/coll/simple.h>

using namespace std;

namespace tut {
using namespace tagcoll::tests;
using namespace tagcoll::coll;

struct tagcoll_coll_fast_shar {
};
TESTGRP(tagcoll_coll_fast);

template<> template<>
void to::test<1>()
{
	Fast<string, string> coll;

	output_test_collection(inserter(coll));
	test_readonly_collection(coll);
}

template<> template<>
void to::test<2>()
{
	Fast<string, string> coll;

	test_collection(coll);
}

template<> template<>
void to::test<3>()
{
	Fast<string, string> coll;
	output_test_collection(inserter(coll));
	
	set<string> impls = coll.getTagsImplying(string("tomato"));
#if 0
	for (set<string>::const_iterator i = impls.begin();
			i != impls.end(); ++i)
		cerr << *i << endl;
#endif
	ensure_equals(impls.size(), 2u);
	ensure_contains(impls, string("mozzarella"));
	ensure_contains(impls, string("mushrooms"));
}

template<> template<>
void to::test<4>()
{
	std::string minusgarlic(
			"margherita: tomato, mozzarella\n"
			"funghi: tomato, mozzarella, mushrooms\n"
			"rosmarino: rosemerry\n"
			"marinara: tomato\n"
			);
	std::string minustomato(
			"margherita: mozzarella\n"
			"funghi: mozzarella, mushrooms\n"
			"rosmarino: rosemerry\n"
			);
	Simple<string, string> result;

	Fast<string, string> coll;
	output_test_collection(inserter(coll));

	coll.removeTag("garlic");
	parseCollection(minusgarlic, inserter(result));
	ensure_coll_equals(result, coll);

	coll.removeTag("tomato");
	result.clear();
	parseCollection(minustomato, inserter(result));
	ensure_coll_equals(result, coll);
}

template<> template<>
void to::test<5>()
{
	Fast<string, string> coll;
	output_test_collection(inserter(coll));

	set<string> ts;
	ts.insert("tomato"); ts.insert("mozzarella");

	set<string> items = coll.getItemsHavingTags(ts);
	ensure_equals(items.size(), 2u);
	ensure_contains(items, string("margherita"));
	ensure_contains(items, string("funghi"));

	items = coll.getItemsExactMatch(ts);
	ensure_equals(items.size(), 1u);
	ensure_contains(items, string("margherita"));
}

template<> template<>
void to::test<6>()
{
	Fast<string, string> coll;
	output_test_collection(inserter(coll));

	size_t card;
	string tag = coll.findTagWithMaxCardinality(card);
	ensure_equals(card, 3u);
	ensure_equals(tag, "tomato");
}

template<> template<>
void to::test<7>()
{
	std::string target(
			"margherita: tomato\n"
			"funghi: tomato\n"
			"marinara: tomato\n"
			);
	Simple<string, string> result;

	Fast<string, string> coll;
	output_test_collection(inserter(coll));

	coll.removeTagsWithCardinalityLessThan(3);

	parseCollection(target, inserter(result));
	ensure_coll_equals(result, coll);
}

}

#include <tagcoll/tests/test-utils.tcc>
#include <tagcoll/coll/simple.tcc>
#include <tagcoll/coll/fast.tcc>
#include <tagcoll/patch.tcc>

// vim:set ts=4 sw=4:
