# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.monitor import MonitorManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-monitor
# USAGE
    python create_or_update_guest_diagnostic_settings.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = MonitorManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="187f412d-1758-44d9-b052-169e2564721d",
    )

    response = client.guest_diagnostics_settings.create_or_update(
        resource_group_name="Default-ResourceGroup",
        diagnostic_settings_name="SampleDiagSetting",
        diagnostic_settings={
            "location": "Global",
            "properties": {
                "dataSources": [
                    {
                        "configuration": {
                            "perfCounters": [
                                {"name": "\\Process(_Total)\\%Processor Time", "samplingPeriod": "PT1M"},
                                {"name": "\\Process(_Total)\\Working Set", "samplingPeriod": "PT1M"},
                            ]
                        },
                        "kind": "PerformanceCounter",
                        "sinks": [{"kind": "LogAnalytics"}],
                    },
                    {
                        "configuration": {
                            "providers": [
                                {"filter": "filter exp", "id": 1, "name": "AuditLog"},
                                {"id": 2, "name": "TraceLog"},
                            ]
                        },
                        "kind": "ETWProviders",
                        "sinks": [{"kind": "LogAnalytics"}],
                    },
                    {
                        "configuration": {
                            "eventLogs": [
                                {
                                    "filter": 'SourceName == Xyz AND EventId = "100" AND  $Xpath/Column="DCName" = "CatWoman"',
                                    "logName": "Application",
                                },
                                {
                                    "filter": 'SourceName == Xyz AND EventId = "100" AND  $Xpath/Column="DCName" = "BatMan"',
                                    "logName": "Application",
                                },
                            ]
                        },
                        "kind": "WindowsEventLogs",
                        "sinks": [{"kind": "LogAnalytics"}],
                    },
                ],
                "osType": "Windows",
            },
            "tags": {},
        },
    )
    print(response)


# x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/preview/2018-06-01-preview/examples/createOrUpdateGuestDiagnosticSettings.json
if __name__ == "__main__":
    main()
