from typing import Dict, Iterable, List, Sequence, Tuple, TypeVar, Union, overload

_K = TypeVar("_K")
_V = TypeVar("_V")

_RectStyle = Union[Tuple[float, float, float, float],
                   Tuple[Tuple[float, float], Tuple[float, float]]]

class Rect(object):
    x: int
    y: int
    top: int
    left: int
    bottom: int
    right: int
    topleft: int
    bottomleft: int
    topright: int
    bottomright: int
    midtop: int
    midleft: int
    midbottom: int
    midright: int
    center: int
    centerx: int
    centery: int
    size: int
    width: int
    height: int
    w: int
    h: int
    @overload
    def __init__(self, left: float, top: float, width: float, height: float) -> None: ...
    @overload
    def __init__(self, left_top: Iterable[float], width_height: Iterable[float]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    # This constructor is undocumented, but it works and is in fact used in
    # pygame's "Sprite Module Introduction".
    @overload
    def __init__(self, left_top_width_height: Iterable[float]) -> None: ...
    def copy(self) -> "Rect": ...
    def move(self, x: float, y: float) -> "Rect": ...
    def move_ip(self, x: float, y: float) -> None: ...
    def inflate(self, x: float, y: float) -> "Rect": ...
    def inflate_ip(self, x: float, y: float) -> None: ...
    def clamp(self, rect: "Rect") -> "Rect": ...
    def clamp_ip(self, rect: "Rect") -> None: ...
    def clip(self, rect: "Rect") -> "Rect": ...
    def union(self, rect: "Rect") -> "Rect": ...
    def union_ip(self, rect: "Rect") -> None: ...
    def unionall(self, rect_sequence: Sequence["Rect"]) -> "Rect": ...
    def unionall_ip(self, rect_sequence: Sequence["Rect"]) -> None: ...
    def fit(self, rect: "Rect") -> "Rect": ...
    def normalize(self) -> None: ...
    def contains(self, rect: "Rect") -> bool: ...
    @overload
    def collidepoint(self, x: float, y: float) -> bool: ...
    @overload
    def collidepoint(self, x_y: Iterable[float]) -> bool: ...
    def colliderect(self, rect: "Rect") -> bool: ...
    def collidelist(self, rect_list: List["Rect"]) -> int: ...
    def collidelistall(self, rect_list: List["Rect"]) -> List[int]: ...
    # Also undocumented: the dict collision methods take a 'values' argument
    # that defaults to False. If it is False, the keys in rect_dict must be
    # Rect-like; otherwise, the values must be Rects.
    @overload
    def collidedict(self, rect_dict: Dict[_RectStyle, _V], values: bool = ...) -> Tuple[_RectStyle, _V]: ...
    @overload
    def collidedict(self, rect_dict: Dict[_K, "Rect"], values: bool) -> Tuple[_K, "Rect"]: ...
    @overload
    def collidedictall(self, rect_dict: Dict[_RectStyle, _V], values: bool = ...) -> List[Tuple[_RectStyle, _V]]: ...
    @overload
    def collidedictall(self, rect_dict: Dict[_K, "Rect"], values: bool) -> List[Tuple[_K, "Rect"]]: ...
